/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.storage;

import cc.lechun.balance.dao.storage.StorageCardMapper;
import cc.lechun.balance.entity.storage.StorageCardEntity;
import cc.lechun.balance.entity.storage.StorageCardEntityExample;
import cc.lechun.balance.iservice.storage.StorageCardInterface;
import cc.lechun.balance.service.BaseService;
import cc.lechun.balance.tools.RandomUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageCardService
extends BaseService<StorageCardEntity, String, StorageCardEntityExample>
implements StorageCardInterface {
    @Autowired
    private StorageCardMapper storageCardMapper;

    public void testExample() {
        StorageCardEntityExample var1 = new StorageCardEntityExample();
        var1.createCriteria().andCreateTimeBetween(new Date(), new Date()).andGiftTitleBetween("", "");
        List storageCardEntityList = this.selectByExample((Object)var1);
    }

    public PageInfo queryStorageCardInfo(int currentPage, int pageSize, StorageCardEntity storageCardEntity) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List storageCardEntityList = this.storageCardMapper.queryStorageCardInfoList(storageCardEntity);
        storageCardEntityList = storageCardEntityList.stream().filter(StorageCardEntity2 -> StorageCardEntity2.getGiftState() != 0).collect(Collectors.toList());
        PageInfo pg = page.toPageInfo();
        pg.setList(storageCardEntityList);
        return pg;
    }

    public List<StorageCardEntity> queryStorageCardInfoList(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.queryStorageCardInfoList(storageCardEntity);
    }

    public int updateStorageCardState(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.updateStorageCardState(storageCardEntity);
    }

    public int saveStorageCard(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.insertSelective((Object)storageCardEntity);
    }

    public List<StorageCardEntity> findStorageCardInfo(StorageCardEntity storageCardEntity) {
        ArrayList<StorageCardEntity> storageCardList = new ArrayList();
        storageCardList = this.storageCardMapper.getList((Object)storageCardEntity);
        return storageCardList;
    }

    public int createStorageCard(StorageCardEntity storageCardEntity) {
        String storageCardNo = RandomUtils.generateNumber((int)12);
        storageCardEntity.setId(storageCardNo);
        return this.storageCardMapper.insertSelective((Object)storageCardEntity);
    }

    public int updateStorageCard(String Id, int giftState) {
        StorageCardEntity storageCardEntity = (StorageCardEntity)this.storageCardMapper.selectByPrimaryKey((Serializable)((Object)Id));
        if (storageCardEntity != null) {
            storageCardEntity.setGiftState(Integer.valueOf(giftState));
            return this.storageCardMapper.updateByPrimaryKeySelective((Object)storageCardEntity);
        }
        return 1;
    }

    public StorageCardEntity selectByProductId(String productId) {
        StorageCardEntityExample entityExample = new StorageCardEntityExample();
        entityExample.createCriteria().andProIdEqualTo(productId);
        List entityList = this.selectByExample((Object)entityExample);
        return entityList != null && entityList.size() > 0 ? (StorageCardEntity)entityList.get(0) : null;
    }
}

