/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.PlatformMapper;
import cc.lechun.authority.entity.PlatformAndGroupVo;
import cc.lechun.authority.entity.PlatformEntity;
import cc.lechun.authority.entity.PlatformEntityVo;
import cc.lechun.authority.iservice.PlatformInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatformService
implements PlatformInterface {
    private static final Logger log = LoggerFactory.getLogger(PlatformService.class);
    @Autowired
    private PlatformMapper platformMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @WriteDataSource
    public PlatformEntity savePlatForm(PlatformEntity PlatformEntity2) {
        PlatformEntity2.setCreateTime(DateUtils.now());
        this.platformMapper.insertSelective(PlatformEntity2);
        this.removeCache(PlatformEntity2.getPlatformId(), PlatformEntity2.getPlatformGroupId());
        return PlatformEntity2;
    }

    @Override
    @WriteDataSource
    public PlatformEntity updatePlatForm(PlatformEntity PlatformEntity2) {
        this.platformMapper.updateByPrimaryKeySelective(PlatformEntity2);
        this.removeCache(PlatformEntity2.getPlatformId(), PlatformEntity2.getPlatformGroupId());
        return PlatformEntity2;
    }

    @Override
    @WriteDataSource
    public void deletePlatForm(int platformId) {
        PlatformEntity PlatformEntity2 = this.getPlatForm(platformId);
        PlatformEntity2.setStatus(-1);
        this.platformMapper.updateByPrimaryKeySelective(PlatformEntity2);
        this.removeCache(platformId, PlatformEntity2.getPlatformGroupId());
    }

    @Override
    @ReadThroughSingleCache(namespace="PlatForm", expiration=7200)
    @ReadDataSource
    public PlatformEntity getPlatForm(@ParameterValueKeyProvider int platformId) {
        return (PlatformEntity)this.platformMapper.selectByPrimaryKey(Integer.valueOf(platformId));
    }

    @Override
    public int getPlatFormGroupId(int platformId) {
        PlatformEntity PlatformEntity2 = ((PlatformService)AopContext.currentProxy()).getPlatForm(platformId);
        if (PlatformEntity2 != null) {
            return PlatformEntity2.getPlatformGroupId();
        }
        return 0;
    }

    @Override
    @ReadDataSource
    public PlatformAndGroupVo getPlatFormAndGroup(int platformId) {
        log.info("getPlatFormAndGroup,platformId:" + platformId);
        try {
            Object obj = this.memcachedService.get("PlatFormAndGroup", String.valueOf(platformId));
            if (obj == null) {
                PlatformAndGroupVo vo = this.platformMapper.getPlatformAndGroup(platformId);
                this.memcachedService.set("PlatFormAndGroup", String.valueOf(platformId), (Object)vo, 7200);
                return vo;
            }
            return (PlatformAndGroupVo)obj;
        }
        catch (Exception e) {
            log.error("getPlatFormAndGroup ERROR", (Throwable)e);
            return this.platformMapper.getPlatformAndGroup(platformId);
        }
    }

    @Override
    @ReadDataSource
    public PlatformAndGroupVo getPlatFormAndGroup(int platformId, String uid) {
        log.info("getPlatFormAndGroup,platformId:" + platformId + ",uid=" + uid);
        try {
            Object obj = this.memcachedService.get("PlatFormAndGroup", String.valueOf(platformId));
            if (obj == null) {
                PlatformAndGroupVo vo = this.platformMapper.getPlatformAndGroup(platformId);
                this.memcachedService.set("PlatFormAndGroup", String.valueOf(platformId), (Object)vo, 7200);
                return vo;
            }
            return (PlatformAndGroupVo)obj;
        }
        catch (Exception e) {
            log.error("getPlatFormAndGroup ERROR", (Throwable)e);
            return this.platformMapper.getPlatformAndGroup(platformId);
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="ValidPlatFormList", expiration=7200)
    @ReadDataSource
    public List<PlatformEntity> getValidPlatFormList(@ParameterValueKeyProvider int platformGroupId) {
        PlatformEntity PlatformEntity2 = new PlatformEntity();
        PlatformEntity2.setStatus(1);
        PlatformEntity2.setPlatformGroupId(platformGroupId);
        return this.platformMapper.getList(PlatformEntity2);
    }

    @Override
    @ReadThroughSingleCache(namespace="PlatFormList", expiration=7200)
    @ReadDataSource
    public List<PlatformEntity> getPlatFormList(@ParameterValueKeyProvider int platformGroupId) {
        PlatformEntity PlatformEntity2 = new PlatformEntity();
        PlatformEntity2.setPlatformGroupId(platformGroupId);
        return this.platformMapper.getList(PlatformEntity2);
    }

    @Override
    public List<PlatformEntity> getPlatFormList() {
        return this.platformMapper.getList(new PlatformEntity());
    }

    @Override
    public List<PlatformEntity> getValidPlatFormList4All() {
        PlatformEntity PlatformEntity2 = new PlatformEntity();
        PlatformEntity2.setStatus(1);
        return this.platformMapper.getList(PlatformEntity2);
    }

    public PageInfo<PlatformEntityVo> getPlatFormList(int pageNum, int pageSize, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.platformMapper.getPlatformList(platformGroupId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    private void removeCache(Integer platformId, Integer platformGroupId) {
        this.memcachedService.delete("PlatForm", platformId + "");
        this.memcachedService.delete("PlatFormAndGroup", platformId + "");
        this.memcachedService.delete("PlatFormList", platformGroupId + "");
        this.memcachedService.delete("ValidPlatFormList", platformGroupId + "");
    }
}

