/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.channel;

import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.baseservice.service.channel.MessageHandle;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageContext {
    private final Map<String, MessageHandle> messageHandleMap = new ConcurrentHashMap<String, MessageHandle>();

    @Autowired
    public MessageContext(Map<String, MessageHandle> messageHandle) {
        this.messageHandleMap.clear();
        this.messageHandleMap.forEach((k, v) -> messageHandle.put((String)k, (MessageHandle)v));
    }

    public BaseJsonVo pushMessage(UserMessageVo messageVo) {
        MessageHandle messageHandle;
        if (messageVo != null && (messageHandle = this.messageHandleMap.get(MessageTypeEnum.getName(messageVo.getType()))) != null) {
            messageHandle.pushMessage(messageVo);
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
    }

    public BaseJsonVo pushMessage(SendMessageVo sendMessageVo) {
        MessageHandle messageHandle;
        if (sendMessageVo != null && (messageHandle = this.messageHandleMap.get(MessageTypeEnum.getName(sendMessageVo.getType()))) != null) {
            return messageHandle.pushMessage(sendMessageVo);
        }
        return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
    }
}

