/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.dao.TemplateMapper;
import cc.lechun.baseservice.entity.AppEntity;
import cc.lechun.baseservice.entity.TemplateEntity;
import cc.lechun.baseservice.model.sms.TemplateDo;
import cc.lechun.baseservice.model.sms.TemplateQueryDTO;
import cc.lechun.baseservice.service.IAppService;
import cc.lechun.baseservice.service.ITemplateService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateService
implements ITemplateService {
    private static final Logger logger = LoggerFactory.getLogger(TemplateService.class);
    @Autowired
    private TemplateMapper templateMapper;
    @Autowired
    private IAppService appService;
    @Autowired
    protected MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="TemplateService.getTemplateEntity")
    public TemplateEntity getTemplateEntity(Integer id) {
        return (TemplateEntity)this.templateMapper.selectByPrimaryKey(Short.valueOf(id.shortValue()));
    }

    @Override
    public BaseJsonVo saveTemplate(TemplateEntity templateEntity) {
        logger.info("\u5e94\u7528\u5bf9\u8c61:{}", (Object)templateEntity.toString());
        int result = 0;
        if (templateEntity.getId() == null) {
            templateEntity.setUpdateDate(DateUtils.now());
            templateEntity.setCreateDate(DateUtils.now());
            result = this.templateMapper.insertSelective(templateEntity);
        } else {
            this.removeCache(templateEntity);
            templateEntity.setUpdateDate(DateUtils.now());
            result = this.templateMapper.updateByPrimaryKeySelective(templateEntity);
        }
        return result >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public PageInfo getTemplateList(TemplateQueryDTO templateQueryDTO) {
        Page page = PageHelper.startPage((int)templateQueryDTO.getCurrentPage(), (int)templateQueryDTO.getPageSize()).setOrderBy(" id DESC ");
        TemplateEntity templateEntity = new TemplateEntity();
        if (templateQueryDTO.getAppId() != null) {
            templateEntity.setAppId(templateQueryDTO.getAppId());
        }
        PageInfo pg = page.toPageInfo();
        List list = this.templateMapper.getList(templateEntity);
        ArrayList list2 = new ArrayList();
        if (list != null) {
            list.forEach(t -> {
                TemplateDo templateDo = new TemplateDo();
                BeanUtils.copyProperties((Object)t, (Object)templateDo);
                AppEntity appEntity = this.appService.getAppEntity(t.getAppId());
                if (appEntity != null) {
                    templateDo.setAppName(appEntity.getName());
                }
                list2.add(templateDo);
            });
        }
        pg.setList(list2);
        pg.setTotal(page.getTotal());
        return pg;
    }

    private void removeCache(TemplateEntity templateEntity) {
        this.memcachedService.delete("TemplateService.getTemplateEntity", templateEntity.getId().toString());
    }
}

