/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.Columns;
import cc.lechun.baseservice.dao.MessageMapper;
import cc.lechun.baseservice.model.sms.MessageDTO;
import cc.lechun.baseservice.model.sms.MessageEntity;
import cc.lechun.baseservice.service.SmsMessageResultInterface;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsMessageResultService
extends BaseService
implements SmsMessageResultInterface {
    @Autowired
    private MessageMapper messageMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveSmsMessageResult(String channel, BaseJsonVo result, MessageDTO messageDTO) {
        try {
            MessageEntity message = new MessageEntity();
            message.setMobile(messageDTO.getMobile());
            message.setParams("");
            boolean templateId = false;
            message.setTemplateId(Short.valueOf(messageDTO.getTemplateId()));
            if (result.isSuccess()) {
                message.setSendStatus(Columns.SendStatus.SENDING);
            } else {
                message.setSendStatus(Columns.SendStatus.FAILURE);
                message.setFailCode(result.getError_code().toString());
            }
            message.setRetry(Integer.valueOf(0));
            message.setChannel(channel);
            message.setValidateCode("");
            message.setValidateStatus(Columns.ValidateStatus.NO);
            Date now = new Date();
            message.setCreateDate(now);
            message.setUpdateDate(now);
            message.setFailCode(result.getValue().toString());
            int rows = this.messageMapper.insertSelective(message);
            this.logger.info("{}\u63d2\u5165\u7ed3\u679c:{},\u751f\u6210\u7684\u81ea\u589eid\u4e3a:{}", new Object[]{message, rows, message.getId()});
            if (result.isSuccess()) return;
        }
        catch (Exception e) {
            this.logger.error("\u63d2\u5165Message\u6570\u636e\u5f02\u5e38" + messageDTO.toString(), (Throwable)e);
        }
    }
}

