/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.cache.RedisService;
import cc.lechun.baseservice.dao.TaskMapper;
import cc.lechun.baseservice.entity.GroupDetailEntity;
import cc.lechun.baseservice.entity.GroupDetailQuery;
import cc.lechun.baseservice.entity.TaskEntity;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.service.TaskInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskService
extends BaseService
implements TaskInterface {
    @Autowired
    private RedisService redisService;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private UserInterface userService;
    private final String MESSAGE_REDIS_KEY = "MESSAGE_REDIS_KEY";
    private final String UNSEND_MESSAGE_REDIS_KEY = "UNSEND_MESSAGE_REDIS_KEY";

    @Override
    public void pullUserToRedis() {
        int pageSize = 1000;
        try {
            TaskEntity task = new TaskEntity();
            task.setTaskStatus(1);
            task.setExecTime(DateUtils.now());
            task.setBeginTime(DateUtils.now());
            task.setEndTime(DateUtils.now());
            List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
            if (list != null && list.size() > 0) {
                list.forEach(taskItem -> {
                    int i = 0;
                    while (true) {
                        GroupDetailQuery groupDetailQuery = new GroupDetailQuery();
                        groupDetailQuery.setCurrentPage(i);
                        groupDetailQuery.setPageSize(pageSize);
                        List userList = this.userService.getUserByGroupId(groupDetailQuery).getList();
                        userList.forEach(userItem -> {
                            boolean addSuccess = this.redisService.sadd("MESSAGE_REDIS_KEY:" + taskItem.getId().toString(), userItem);
                            if (addSuccess) {
                                this.redisService.sadd("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId().toString(), userItem);
                            }
                        });
                        if (userList == null || userList.size() < 10000) break;
                        ++i;
                    }
                    TaskEntity update = new TaskEntity();
                    update.setTaskStatus(2);
                    update.setId(taskItem.getId());
                    if (this.taskMapper.updateByPrimaryKeySelective(update) > 0) {
                        this.logger.info("\u4efb\u52a1:{},{},\u6d88\u606f\u63a8\u9001\u4e2d..." + taskItem.getTaskName(), (Object)taskItem.getId());
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pullUserToMq() {
        Integer perSize = 100;
        TaskEntity task = new TaskEntity();
        task.setTaskStatus(2);
        task.setExecTime(DateUtils.now());
        task.setBeginTime(DateUtils.now());
        task.setEndTime(DateUtils.now());
        List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
        list.forEach(taskItem -> {
            Integer popNumPage = 1000;
            popNumPage = popNumPage == null || popNumPage == 0 ? 50 : popNumPage;
            for (int i = 0; i < popNumPage; ++i) {
                ArrayList<UserMessageVo> messageList = new ArrayList<UserMessageVo>();
                for (int j = 0; j < perSize; ++j) {
                    GroupDetailEntity user = (GroupDetailEntity)this.redisService.spop("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId());
                    if (user == null) {
                        i = popNumPage;
                        break;
                    }
                    this.redisService.sremove("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId(), user);
                    UserMessageVo messageVo = new UserMessageVo();
                    BeanUtils.copyProperties((Object)user, (Object)messageVo);
                    messageVo.setTaskId(taskItem.getId());
                    messageList.add(messageVo);
                }
                this.logger.info("\u8981\u63a8\u9001\u6a21\u677f\u6d88\u606f\u4e86[" + i + "]\uff1a" + JsonUtils.toJson(messageList, (boolean)true));
                this.pushNoticeMQ("AllSubscribes", "all", messageList, i, 1);
            }
        });
    }

    private void pushNoticeMQ(String customerType, String action, List<UserMessageVo> taskList, int pageNum, Integer platformId) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("customerType", customerType);
        messageMap.put("action", action);
        messageMap.put("list", taskList);
        messageMap.put("platformId", platformId);
        this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6d88\u606f\uff1a" + JsonUtils.toJson(messageMap, (boolean)true));
    }

    @Override
    public TaskEntity getTaskEntityById(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task == null) {
            return new TaskEntity();
        }
        return task;
    }
}

