/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.cache.RedisService;
import cc.lechun.baseservice.constant.EnvironmentEnum;
import cc.lechun.baseservice.constant.GroupTypeEnum;
import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.constant.PeriodTypeEnum;
import cc.lechun.baseservice.constant.TaskStatusEnum;
import cc.lechun.baseservice.dao.TaskMapper;
import cc.lechun.baseservice.entity.GroupDetailQuery;
import cc.lechun.baseservice.entity.TemplateEntity;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.model.sms.GroupDetailEntity;
import cc.lechun.baseservice.model.sms.TaskEntity;
import cc.lechun.baseservice.model.sms.TaskQueryVo;
import cc.lechun.baseservice.model.sms.TaskVo;
import cc.lechun.baseservice.model.sms.UserGroupEntity;
import cc.lechun.baseservice.service.ITemplateService;
import cc.lechun.baseservice.service.TaskInterface;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.apiinvoke.active.ActiveInvoke;
import cc.lechun.baseservice.service.apiinvoke.wechat.KeyworldInvoke;
import cc.lechun.baseservice.service.channel.MessageContext;
import cc.lechun.cms.dto.ActiveDTO;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TaskService
extends BaseService
implements TaskInterface {
    @Autowired
    private RedisService redisService;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private UserInterface userService;
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Lazy
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private MessageContext messageContext;
    @Autowired
    private ActiveInvoke activeInvoke;
    @Autowired
    private KeyworldInvoke keyworldInvoke;
    @Value(value="${lechun.environment}")
    private String environment;
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    private final String MESSAGE_REDIS_KEY = "MESSAGE_REDIS_KEY";
    private final String UNSEND_MESSAGE_REDIS_KEY = "UNSEND_MESSAGE_REDIS_KEY";

    @Override
    public void removeCache() {
        Set sets = this.redisCacheUtil.getKeysPattern("MESSAGE_REDIS_KEY");
        sets.addAll(this.redisCacheUtil.getKeysPattern("UNSEND_MESSAGE_REDIS_KEY"));
        if (sets != null & sets.size() > 0) {
            for (String s : sets) {
                Set keys = this.redisCacheUtil.getCacheSet(s);
                if (!(keys != null & keys.size() > 0)) continue;
                for (String key : keys) {
                    Object o;
                    if (key == null || (o = this.redisCacheUtil.get(key)) != null) continue;
                    this.redisCacheUtil.remove(s);
                }
            }
        }
        this.logger.info("\u91ca\u653eredis cache\u5b8c\u6bd5 {}", (Object)"\u5b8c\u6210");
    }

    @Override
    public void stopTask() {
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setTaskStatus(Integer.valueOf(TaskStatusEnum.SENDING.getValue()));
        List list = this.taskMapper.getList(taskEntity);
        if (list.size() > 0) {
            list.forEach(task -> this.setTaskFinish((TaskEntity)task));
        }
    }

    @Override
    public BaseJsonVo deleteTask(int taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(Integer.valueOf(taskId));
        if (task == null) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        if (task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue() || task.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            return BaseJsonVo.success((Object)("\u4efb\u52a1:" + TaskStatusEnum.getName(task.getTaskStatus()) + "\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        this.taskMapper.deleteByPrimaryKey(Integer.valueOf(taskId));
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo preview(Integer taskId, String account) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            UserMessageVo userMessageVo = new UserMessageVo();
            BeanUtils.copyProperties((Object)task, (Object)userMessageVo);
            userMessageVo.setCustomerId(account);
            userMessageVo.setMobile(account);
            userMessageVo.setTaskId(task.getId());
            userMessageVo.setTemplateId(String.valueOf(task.getTemplateId()));
            if (account.length() == 11) {
                userMessageVo.setType(MessageTypeEnum.SMS.getValue());
            } else if (account.contains("@")) {
                userMessageVo.setType(MessageTypeEnum.EMAIL.getValue());
            } else {
                userMessageVo.setType(task.getMessageType());
            }
            if (!StringUtils.isNotEmpty((String)task.getActiveNo())) return this.messageContext.pushMessage(userMessageVo, 1);
            BaseJsonVo<ActiveDTO> result = this.activeInvoke.getActiveByActiveNo(task.getActiveNo());
            if (!result.isSuccess()) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u9884\u89c8\u5931\u8d25");
            ActiveDTO activeDTO = (ActiveDTO)result.getValue();
            if (!task.getActiveNo().equals(activeDTO.getActiveNo())) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u9884\u89c8\u5931\u8d25");
            if (activeDTO.getStatus() == 0) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u542f\u7528\uff0c\u9884\u89c8\u5931\u8d25");
            }
            if (activeDTO.getBeginTime().after(DateUtils.now())) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u5f00\u59cb\uff0c\u9884\u89c8\u5931\u8d25");
            }
            if (!activeDTO.getEndTime().before(DateUtils.now())) return this.messageContext.pushMessage(userMessageVo, 1);
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u9884\u89c8\u5931\u8d25");
        }
        this.logger.error("\u65e0\u6548\u7684\u4efb\u52a1:{}", (Object)taskId);
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4efb\u52a1");
    }

    @Override
    public BaseJsonVo saveTask(TaskEntity taskEntity) {
        TaskEntity taskItem;
        TaskEntity temp;
        if (taskEntity.getId() == null || taskEntity.getId() == 0) {
            TaskEntity query = new TaskEntity();
            query.setTaskName(taskEntity.getTaskName());
            TaskEntity temp2 = (TaskEntity)this.taskMapper.getSingle(query);
            if (temp2 != null) {
                return BaseJsonVo.error((String)"\u540d\u79f0\u91cd\u590d,\u4fdd\u5b58\u5931\u8d25");
            }
            if (StringUtils.isNotEmpty((String)taskEntity.getActiveNo())) {
                query = new TaskEntity();
                query.setActiveNo(taskEntity.getActiveNo());
                temp2 = (TaskEntity)this.taskMapper.getSingle(query);
                if (temp2 != null) {
                    return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed1\u5b9a\u5176\u4ed6\u4efb\u52a1,\u8bf7\u6362\u4e00\u4e2a\u6d3b\u52a8\u518d\u8bd5,\u4fdd\u5b58\u5931\u8d25");
                }
            }
            taskEntity.setCreateTime(DateUtils.now());
            taskEntity.setTaskStatus(Integer.valueOf(TaskStatusEnum.WAIT_DELIVERY.getValue()));
            if (taskEntity.getPeriodType() > 0) {
                taskEntity.setNextTime(DateUtils.getAddDateByDay((Date)taskEntity.getExecTime(), (int)taskEntity.getPeriodType()));
            } else {
                taskEntity.setBeginTime(DateUtils.getAddDateBySecond((Date)taskEntity.getExecTime(), (int)-600));
                taskEntity.setEndTime(DateUtils.getAddDateBySecond((Date)taskEntity.getExecTime(), (int)600));
            }
            return this.taskMapper.insert(taskEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        TaskEntity query = new TaskEntity();
        if (StringUtils.isNotEmpty((String)taskEntity.getTaskName())) {
            query.setTaskName(taskEntity.getTaskName());
            temp = (TaskEntity)this.taskMapper.getSingle(query);
            if (temp != null && temp.getId().intValue() != taskEntity.getId().intValue()) {
                return BaseJsonVo.error((String)"\u540d\u79f0\u91cd\u590d,\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if (StringUtils.isNotEmpty((String)taskEntity.getActiveNo())) {
            query = new TaskEntity();
            query.setActiveNo(taskEntity.getActiveNo());
            temp = (TaskEntity)this.taskMapper.getSingle(query);
            if (temp != null && temp.getId().intValue() != taskEntity.getId().intValue()) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed1\u5b9a\u5176\u4ed6\u4efb\u52a1,\u8bf7\u6362\u4e00\u4e2a\u6d3b\u52a8\u518d\u8bd5,\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if ((taskItem = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskEntity.getId())).getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            return BaseJsonVo.error((String)("\u4efb\u52a1" + TaskStatusEnum.getName(taskItem.getTaskStatus()) + "\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        taskEntity.setTaskStatus(Integer.valueOf(TaskStatusEnum.WAIT_DELIVERY.getValue()));
        if (taskEntity.getPeriodType() > 0) {
            taskEntity.setNextTime(DateUtils.getAddDateByDay((Date)taskEntity.getExecTime(), (int)taskEntity.getPeriodType()));
        }
        this.taskMapper.updateByPrimaryKeySelective(taskEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    public PageInfo<TaskVo> getTaskList(TaskQueryVo taskQueryVo) {
        Page page = PageHelper.startPage((int)taskQueryVo.getCurrentPage(), (int)taskQueryVo.getPageSize());
        page.setOrderBy("ID desc");
        TaskEntity query = new TaskEntity();
        query.setBeginTime(DateUtils.getDateFromString((String)taskQueryVo.getBeginTime(), (String)"yyyy-MM-dd"));
        query.setEndTime(DateUtils.getDateFromString((String)taskQueryVo.getEndTime(), (String)"yyyy-MM-dd"));
        query.setTaskName(taskQueryVo.getTaskName());
        List<TaskEntity> list = this.taskMapper.getTaskList(query);
        ArrayList<TaskVo> taskVos = new ArrayList<TaskVo>();
        for (TaskEntity task : list) {
            TaskVo taskVo = new TaskVo();
            BeanUtils.copyProperties((Object)task, (Object)taskVo);
            taskVo.setActiveName("");
            if (task.getMessageType().intValue() == MessageTypeEnum.SMS.getValue()) {
                TemplateEntity templateEntity = this.templateService.getTemplateEntity(task.getTemplateId());
                taskVo.setContent(templateEntity == null ? "" : templateEntity.getTemplate());
            } else if (task.getMessageType().intValue() == MessageTypeEnum.WECHAT_CUSTOMER_MESSAGE.getValue()) {
                BaseJsonVo tempResult = this.keyworldInvoke.getKeyworldContent(task.getTemplateId());
                taskVo.setContent(tempResult.isSuccess() ? tempResult.getValue().toString() : "");
            } else if (task.getMessageType().intValue() == MessageTypeEnum.WECHAT_TEMPLATES_MESSAGE.getValue()) {
                taskVo.setContent("\u6a21\u677f\u6d88\u606f\u5185\u5bb9\u8bf7\u53bb\u6a21\u677f\u4e2d\u67e5\u770b");
            }
            UserGroupEntity groupEntity = this.userGroupInterface.getGroup(task.getGroupId());
            taskVo.setGroupName(groupEntity == null ? "" : groupEntity.getUserGroupName());
            taskVo.setMessageTypeName(MessageTypeEnum.getName(task.getMessageType()));
            taskVo.setPeriodTypeName(PeriodTypeEnum.getName(task.getPeriodType()));
            taskVo.setTaskStatusName(TaskStatusEnum.getName(task.getTaskStatus()));
            taskVos.add(taskVo);
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(taskVos);
        return pg;
    }

    @Override
    public void pullUserToRedis() {
        int pageSize = 1000;
        try {
            TaskEntity task = new TaskEntity();
            task.setTaskStatus(Integer.valueOf(TaskStatusEnum.APPROVE.getValue()));
            task.setBeginTime(DateUtils.now());
            task.setEndTime(DateUtils.now());
            List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
            if (list != null && list.size() > 0) {
                list.forEach(taskItem -> {
                    this.logger.info("\u5df2\u5ba1\u6838\u7684\u4efb\u52a1\u8bb0\u5f55:{}", (Object)taskItem.toString());
                    UserGroupEntity groupEntity = this.userGroupInterface.getGroup(taskItem.getGroupId());
                    if (taskItem.getExecTime().before(DateUtils.now()) && taskItem.getExecTime().after(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)-300))) {
                        this.logger.info("\u5468\u671f\u6267\u884c\u4efb\u52a1\u8bbe\u7f6e\u4f18\u60e0\u5238\u6b21\u6570\u589e\u52a0\u5f00\u59cb:{}", (Object)taskItem.toString());
                        this.setSendCashNum((TaskEntity)taskItem, groupEntity);
                        this.logger.info("\u5f00\u59cb\u7528\u6237\u5199\u5165redis:{}", (Object)taskItem.toString());
                        this.pullUserToRedis((TaskEntity)taskItem);
                    } else {
                        this.logger.info("\u4efb\u52a1{}\u4e0d\u5728\u6267\u884c\u65f6\u95f4\u6ee1\u56ed\u5185", (Object)taskItem.toString());
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSendCashNum(TaskEntity task, UserGroupEntity groupEntity) {
        try {
            if (StringUtils.isNotEmpty((String)task.getActiveNo())) {
                if (groupEntity == null) {
                    this.logger.error("\u65e0\u6548\u7684\u7528\u6237{}", (Object)task.toString());
                    return;
                }
                if (groupEntity.getGroupType().intValue() == GroupTypeEnum.TEMPLATE.getValue() && groupEntity.getSendNum() != null && groupEntity.getSendNum() > 0) {
                    BaseJsonVo baseJsonVo = this.activeInvoke.setCashSendNum(task.getActiveNo(), groupEntity.getSendNum());
                    this.logger.info("\u8bbe\u7f6e\u4f18\u60e0\u5238\u63a8\u9001\u6b21\u6570:{}", (Object)baseJsonVo.isSuccess());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTaskSending(Integer taskId) {
        TaskEntity update = new TaskEntity();
        update.setId(taskId);
        update.setTaskStatus(Integer.valueOf(TaskStatusEnum.SENDING.getValue()));
        this.taskMapper.updateByPrimaryKeySelective(update);
        this.logger.info("\u5df2\u8bbe\u7f6e\u4efb\u52a1{}\u53d1\u9001\u4e2d", (Object)taskId);
    }

    @Override
    public void pullUserToRedis(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            this.pullUserToRedis(task);
        } else {
            this.logger.error("\u65e0\u6548\u7684\u4efb\u52a1:{}", (Object)taskId);
        }
    }

    @Override
    public void pullUserToRedis(TaskEntity task) {
        this.logger.info("\u5c06\u4efb\u52a1\u5173\u8054\u7528\u6237\u63a8\u9001\u5230redis\u4e2d....{}", (Object)task.toString());
        if (task.getBeginTime().before(DateUtils.now()) && task.getEndTime().after(DateUtils.now()) && task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue()) {
            this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4efb\u52a1\u53d1\u9001\u4e2d:{}", (Object)task.toString());
            this.setTaskSending(task.getId());
            this.logger.info("\u8bbe\u7f6e\u4efb\u52a1{}\u53d1\u9001\u4e2d\u5b8c\u6210", (Object)task.toString());
            boolean limit = EnvironmentEnum.PRODUCT.getValue().equals(this.environment);
            this.logger.info("\u73af\u5883:{}", (Object)this.environment);
            int pageSize = 1000;
            int i = 0;
            while (true) {
                GroupDetailQuery groupDetailQuery = new GroupDetailQuery();
                groupDetailQuery.setCurrentPage(i);
                groupDetailQuery.setPageSize(pageSize);
                groupDetailQuery.setGroupId(task.getGroupId());
                List userList = this.userService.getUserByGroupId(groupDetailQuery).getList();
                userList.forEach(userItem -> {
                    String account = userItem.getMobile();
                    if (task.getMessageType().intValue() == MessageTypeEnum.SMS.getValue()) {
                        account = userItem.getMobile();
                    } else if (task.getMessageType().intValue() == MessageTypeEnum.WECHAT_TEMPLATES_MESSAGE.getValue() || task.getMessageType().intValue() == MessageTypeEnum.WECHAT_CUSTOMER_MESSAGE.getValue()) {
                        account = userItem.getCustomerId();
                    }
                    boolean addSuccess = this.redisService.sadd("MESSAGE_REDIS_KEY" + task.getId().toString(), userItem);
                    if (addSuccess) {
                        if (limit) {
                            if (this.redisService.sadd("UNSEND_MESSAGE_REDIS_KEY:" + DateUtils.date(), account)) {
                                this.redisService.sadd("UNSEND_MESSAGE_REDIS_KEY:" + task.getId().toString(), userItem);
                                this.logger.info("\u7528\u6237\u5e10\u53f7:{},\u65e5\u671f:{}\u5df2\u88ab\u6dfb\u52a0", (Object)userItem.toString(), (Object)DateUtils.date());
                            } else {
                                this.logger.info("\u7528\u6237\u5e10\u53f7:{},\u65e5\u671f:{}\u5df2\u88ab\u6dfb\u52a0\u8fc7,\u4e0d\u91cd\u590d\u6dfb\u52a0", (Object)userItem.toString(), (Object)DateUtils.date());
                            }
                        } else {
                            this.redisService.sadd("UNSEND_MESSAGE_REDIS_KEY:" + task.getId().toString(), userItem);
                            this.logger.info("\u7528\u6237\u5e10\u53f7:{},\u65e5\u671f:{}\u5df2\u88ab\u6dfb\u52a0", userItem, (Object)DateUtils.date());
                        }
                    }
                });
                if (userList == null || userList.size() < 1000) break;
                ++i;
            }
            this.redisService.setExpire("SENDKEY:PUSH:MQ_" + task.getId(), 60L, TimeUnit.SECONDS);
        }
    }

    private void setTaskFinish(TaskEntity task) {
        TaskEntity update = new TaskEntity();
        update.setTaskStatus(Integer.valueOf(TaskStatusEnum.FINISH.getValue()));
        update.setId(task.getId());
        if (this.taskMapper.updateByPrimaryKeySelective(update) > 0) {
            this.logger.info("\u4efb\u52a1:{},{},\u6d88\u606f\u63a8\u9001\u5b8c\u6210...", (Object)task.getTaskName(), (Object)task.getId());
        }
    }

    private void setUserGroupStatus(TaskEntity task) {
        this.logger.info("\u4efb\u52a1{}\u53d1\u9001\u5b8c\u6210\u8bbe\u7f6e\u7528\u6237\u7ec4\u672a\u66f4\u65b0", (Object)task);
        this.userGroupInterface.updateStatus(task.getGroupId(), 0, null);
    }

    @Override
    public void pullUserToMq() {
        Integer perSize = 100;
        TaskEntity task = new TaskEntity();
        task.setTaskStatus(Integer.valueOf(TaskStatusEnum.SENDING.getValue()));
        List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
        if (list != null && list.size() > 0) {
            TaskEntity taskItem = list.get(0);
            Integer popNumPage = 1000;
            popNumPage = popNumPage == null || popNumPage == 0 ? 50 : popNumPage;
            for (int i = 0; i < popNumPage; ++i) {
                ArrayList<UserMessageVo> messageList = new ArrayList<UserMessageVo>();
                for (int j = 0; j < perSize; ++j) {
                    GroupDetailEntity user = (GroupDetailEntity)this.redisService.spop("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId() + ":" + DateUtils.date());
                    if (user == null) {
                        i = popNumPage;
                        this.setTaskFinish(taskItem);
                        this.setUserGroupStatus(taskItem);
                        break;
                    }
                    this.redisService.sremove("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId() + ":" + DateUtils.date(), user);
                    UserMessageVo messageVo = new UserMessageVo();
                    BeanUtils.copyProperties((Object)user, (Object)messageVo);
                    messageVo.setTaskId(taskItem.getId());
                    messageVo.setType(taskItem.getMessageType());
                    messageVo.setActiveNo(taskItem.getActiveNo());
                    messageVo.setTemplateId(taskItem.getTemplateId().toString());
                    UserGroupEntity userGroupEntity = this.userGroupInterface.getGroup(user.getGroupId());
                    messageVo.setGroupType(userGroupEntity != null ? userGroupEntity.getGroupType() : 0);
                    messageList.add(messageVo);
                }
                this.logger.info("\u8981\u63a8\u9001\u6d88\u606f\u4e86[" + i + "]\uff1a" + JsonUtils.toJson(messageList, (boolean)true));
                if (messageList.size() <= 0) continue;
                this.pushNoticeMQ("AllSubscribes", "all", messageList, i, 1);
            }
        }
    }

    @Override
    public void pullUserToMq(Integer taskId) {
        Integer perSize = 100;
        TaskEntity taskItem = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (taskItem.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            Integer popNumPage = 1000;
            popNumPage = popNumPage == null || popNumPage == 0 ? 50 : popNumPage;
            for (int i = 0; i < popNumPage; ++i) {
                ArrayList<UserMessageVo> messageList = new ArrayList<UserMessageVo>();
                for (int j = 0; j < perSize; ++j) {
                    GroupDetailEntity user = (GroupDetailEntity)this.redisService.spop("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId() + ":" + DateUtils.date());
                    if (user == null) {
                        i = popNumPage;
                        this.setTaskFinish(taskItem);
                        this.setUserGroupStatus(taskItem);
                        break;
                    }
                    this.redisService.sremove("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId() + ":" + DateUtils.date(), user);
                    UserMessageVo messageVo = new UserMessageVo();
                    BeanUtils.copyProperties((Object)user, (Object)messageVo);
                    messageVo.setTaskId(taskItem.getId());
                    messageVo.setType(taskItem.getMessageType());
                    messageVo.setActiveNo(taskItem.getActiveNo());
                    messageVo.setTemplateId(taskItem.getTemplateId().toString());
                    UserGroupEntity userGroupEntity = this.userGroupInterface.getGroup(user.getGroupId());
                    messageVo.setGroupType(userGroupEntity != null ? userGroupEntity.getGroupType() : 0);
                    messageList.add(messageVo);
                }
                this.logger.info("\u8981\u63a8\u9001\u6d88\u606f\u4e86[" + i + "]\uff1a" + JsonUtils.toJson(messageList, (boolean)true));
                if (messageList.size() <= 0) continue;
                this.pushNoticeMQ("AllSubscribes", "all", messageList, i, 1);
            }
        }
    }

    private void pushNoticeMQ(String customerType, String action, List<UserMessageVo> taskList, int pageNum, Integer platformId) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("action", action);
        messageMap.put("list", taskList);
        messageMap.put("platformId", platformId);
        this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6d88\u606f\uff1a" + JsonUtils.toJson(messageMap, (boolean)true));
        MessageResult mr = this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.templeteMessageSend, new MessageParam(String.valueOf(pageNum), messageMap));
        this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c\uff1a" + mr.isStatus() + "  " + mr.getMsg().toString());
    }

    @Override
    public TaskEntity getTaskEntityById(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task == null) {
            return new TaskEntity();
        }
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo approveTask(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task == null) return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4efb\u52a1");
        UserGroupEntity userGroupEntity = this.userGroupInterface.getGroup(task.getGroupId());
        if (userGroupEntity == null || userGroupEntity.getId() == 0) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u7528\u6237\u7ec4\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25");
        }
        if (StringUtils.isNotEmpty((String)task.getActiveNo())) {
            BaseJsonVo<ActiveDTO> result = this.activeInvoke.getActiveByActiveNo(task.getActiveNo());
            if (!result.isSuccess()) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25");
            ActiveDTO activeDTO = (ActiveDTO)result.getValue();
            if (!task.getActiveNo().equals(activeDTO.getActiveNo())) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25");
            if (activeDTO.getStatus() == 0) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u542f\u7528\uff0c\u5ba1\u6838\u5931\u8d25");
            }
            if (activeDTO.getBeginTime().after(DateUtils.now())) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u5f00\u59cb\uff0c\u5ba1\u6838\u5931\u8d25");
            }
            if (activeDTO.getEndTime().before(DateUtils.now())) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u5ba1\u6838\u5931\u8d25");
            }
        }
        if (task.getTaskStatus().intValue() != TaskStatusEnum.WAIT_DELIVERY.getValue()) return BaseJsonVo.error((String)"\u4efb\u52a1\u5df2\u5ba1\u6838\u8fc7");
        TaskEntity update = new TaskEntity();
        update.setId(taskId);
        update.setTaskStatus(Integer.valueOf(TaskStatusEnum.APPROVE.getValue()));
        this.taskMapper.updateByPrimaryKeySelective(update);
        if (!task.getExecTime().after(DateUtils.now())) return BaseJsonVo.success((Object)"\u5ba1\u6838\u6210\u529f");
        this.redisService.setExpire("APPROVE:TASK_" + taskId, (DateUtils.now().getTime() - task.getExecTime().getTime()) / 86400L, TimeUnit.SECONDS);
        return BaseJsonVo.success((Object)"\u5ba1\u6838\u6210\u529f");
    }

    @Override
    public BaseJsonVo cancelTask(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            if (task.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue() || task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue()) {
                TaskEntity update = new TaskEntity();
                update.setId(taskId);
                update.setTaskStatus(Integer.valueOf(TaskStatusEnum.WAIT_DELIVERY.getValue()));
                this.taskMapper.updateByPrimaryKeySelective(update);
                return BaseJsonVo.success((Object)"\u64a4\u9500\u6210\u529f");
            }
            return BaseJsonVo.error((String)("\u4efb\u52a1" + TaskStatusEnum.getName(task.getTaskStatus()) + ",\u65e0\u6cd5\u64a4\u9500"));
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4efb\u52a1");
    }
}

