/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.RuleTypeEnum;
import cc.lechun.baseservice.dao.TagRuleMapper;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.baseservice.model.sms.TagRuleVo;
import cc.lechun.baseservice.service.UserGroupRuleInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserGroupRuleService
extends BaseService
implements UserGroupRuleInterface {
    @Autowired
    private TagRuleMapper tagRuleMapper;

    @Override
    public BaseJsonVo<List<TagRuleEntity>> getTagRuleListByGroupId(Integer groupId) {
        TagRuleEntity query = new TagRuleEntity();
        query.setGroupId(groupId);
        return BaseJsonVo.success((Object)this.tagRuleMapper.getList(query));
    }

    @Override
    public BaseJsonVo updateRuleStatus(Integer ruleId) {
        TagRuleEntity tagRuleEntity = (TagRuleEntity)this.tagRuleMapper.selectByPrimaryKey(ruleId);
        if (tagRuleEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u89c4\u5219.");
        }
        TagRuleEntity update = new TagRuleEntity();
        update.setId(ruleId);
        update.setStatus(tagRuleEntity.getStatus() == 1 ? 0 : 1);
        this.tagRuleMapper.updateByPrimaryKeySelective(update);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteRule(Integer ruleId) {
        this.tagRuleMapper.deleteByPrimaryKey(ruleId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteRuleByGroupId(Integer groupId) {
        TagRuleEntity query = new TagRuleEntity();
        query.setGroupId(groupId);
        List list = this.tagRuleMapper.getList(query);
        if (list.size() > 0) {
            list.forEach(rule -> this.tagRuleMapper.deleteByPrimaryKey(rule.getId()));
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo<List<TagRuleVo>> getRuleVoList(Integer groupId) {
        Page page = PageHelper.startPage((int)1, (int)999);
        page.setOrderBy("ID desc");
        TagRuleEntity query = new TagRuleEntity();
        query.setGroupId(groupId);
        List list = this.tagRuleMapper.getList(query);
        ArrayList<TagRuleVo> tagRuleVos = new ArrayList<TagRuleVo>();
        for (TagRuleEntity tagRuleEntity : list) {
            TagRuleVo tagRuleVo = new TagRuleVo();
            BeanUtils.copyProperties((Object)tagRuleEntity, (Object)tagRuleVo);
            tagRuleVo.setConditionName(RuleTypeEnum.getName(tagRuleEntity.getRuleType()));
            tagRuleVo.setStatusName(tagRuleEntity.getStatus() == 1 ? "\u5df2\u542f\u7528" : "\u672a\u542f\u7528");
            tagRuleVos.add(tagRuleVo);
        }
        return BaseJsonVo.success(tagRuleVos);
    }

    @Override
    public BaseJsonVo saveRule(TagRuleEntity tagRuleEntity) {
        if (tagRuleEntity.getId() == null || tagRuleEntity.getId() == 0) {
            TagRuleEntity query = new TagRuleEntity();
            query.setGroupId(tagRuleEntity.getGroupId());
            query.setRuleType(tagRuleEntity.getRuleType());
            TagRuleEntity temp = (TagRuleEntity)this.tagRuleMapper.getSingle(query);
            if (temp != null) {
                temp.setRuleValue(tagRuleEntity.getRuleValue());
                temp.setCreateTime(DateUtils.now());
                this.tagRuleMapper.updateByPrimaryKeySelective(temp);
                return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
            }
            tagRuleEntity.setCreateTime(DateUtils.now());
            tagRuleEntity.setStatus(1);
            return this.tagRuleMapper.insert(tagRuleEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        this.tagRuleMapper.updateByPrimaryKeySelective(tagRuleEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }
}

