/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.GroupTypeEnum;
import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.dao.UserGroupMapper;
import cc.lechun.baseservice.entity.UserGroupVo;
import cc.lechun.baseservice.model.sms.UserGroupEntity;
import cc.lechun.baseservice.model.sms.UserGroupQueryVo;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserGroupService
extends BaseService
implements UserGroupInterface {
    @Autowired
    private UserGroupMapper userGroupMapper;

    @Override
    public BaseJsonVo deleteGroup(int groupId) {
        UserGroupEntity groupEntity = (UserGroupEntity)this.userGroupMapper.selectByPrimaryKey(Integer.valueOf(groupId));
        if (groupEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u7528\u6237\u7ec4!");
        }
        if (groupEntity.getGroupType().intValue() == GroupTypeEnum.TEMPLATE.getValue()) {
            return BaseJsonVo.error((String)"\u6a21\u677f\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        return this.userGroupMapper.deleteByPrimaryKey(Integer.valueOf(groupId)) > 0 ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    public BaseJsonVo saveGroup(UserGroupEntity userGroupEntity) {
        if (userGroupEntity.getId() == null || userGroupEntity.getId() == 0) {
            UserGroupEntity query = new UserGroupEntity();
            query.setUserGroupName(userGroupEntity.getUserGroupName());
            UserGroupEntity temp = (UserGroupEntity)this.userGroupMapper.getSingle(query);
            if (temp != null) {
                return BaseJsonVo.error((String)"\u7ec4\u540d\u79f0\u91cd\u590d,\u4fdd\u5b58\u5931\u8d25");
            }
            userGroupEntity.setCreateTime(DateUtils.now());
            userGroupEntity.setNum(Integer.valueOf(0));
            userGroupEntity.setStatus(Integer.valueOf(0));
            userGroupEntity.setSendNum(Integer.valueOf(0));
            userGroupEntity.setMessageType(Integer.valueOf(MessageTypeEnum.SMS.getValue()));
            return this.userGroupMapper.insert(userGroupEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        UserGroupEntity query = new UserGroupEntity();
        if (StringUtils.isNotEmpty((String)userGroupEntity.getUserGroupName())) {
            query.setUserGroupName(userGroupEntity.getUserGroupName());
            UserGroupEntity temp = (UserGroupEntity)this.userGroupMapper.getSingle(query);
            if (temp != null && temp.getId().intValue() != userGroupEntity.getId().intValue()) {
                return BaseJsonVo.error((String)"\u7ec4\u540d\u79f0\u91cd\u590d,\u4fdd\u5b58\u5931\u8d25");
            }
        }
        this.userGroupMapper.updateByPrimaryKeySelective(userGroupEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    @Override
    public UserGroupEntity getGroup(Integer groupId) {
        return (UserGroupEntity)this.userGroupMapper.selectByPrimaryKey(groupId);
    }

    @Override
    public PageInfo<UserGroupVo> getUserGroupList(UserGroupQueryVo userGroupQueryVo) {
        Page page = PageHelper.startPage((int)userGroupQueryVo.getCurrentPage(), (int)userGroupQueryVo.getPageSize());
        page.setOrderBy("ID desc");
        List<UserGroupEntity> list = this.userGroupMapper.getUserGrouList(userGroupQueryVo);
        ArrayList<UserGroupVo> userGroupVos = new ArrayList<UserGroupVo>();
        for (UserGroupEntity group : list) {
            UserGroupVo userGroupVo = new UserGroupVo();
            BeanUtils.copyProperties((Object)group, (Object)userGroupVo);
            userGroupVo.setGroupTypeName(GroupTypeEnum.getName(group.getGroupType()));
            userGroupVo.setMessageTypeName(MessageTypeEnum.getName(group.getGroupType()));
            userGroupVo.setStatusName(group.getStatus() == 1 ? "\u5df2\u66f4\u65b0" : "\u672a\u66f4\u65b0");
            userGroupVos.add(userGroupVo);
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(userGroupVos);
        return pg;
    }

    @Override
    public BaseJsonVo updateStatus(Integer groupId, Integer status, Integer groupType) {
        UserGroupEntity result = (UserGroupEntity)this.userGroupMapper.selectByPrimaryKey(groupId);
        UserGroupEntity userGroupEntity = new UserGroupEntity();
        userGroupEntity.setId(groupId);
        userGroupEntity.setStatus(status);
        userGroupEntity.setUpdateTime(DateUtils.now());
        if (status == 1) {
            userGroupEntity.setSendNum(Integer.valueOf(result.getSendNum() == null || result.getSendNum() == 0 ? 0 : result.getSendNum() + 1));
        } else if (status == 0) {
            userGroupEntity.setSendNum(Integer.valueOf(result.getSendNum() == null ? 1 : result.getSendNum() + 1));
        }
        return BaseJsonVo.success((Object)this.userGroupMapper.updateByPrimaryKeySelective(userGroupEntity));
    }
}

