/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.GroupTypeEnum;
import cc.lechun.baseservice.dao.GroupDetailMapper;
import cc.lechun.baseservice.entity.GroupDetailQuery;
import cc.lechun.baseservice.entity.UserGroupVo;
import cc.lechun.baseservice.model.sms.GroupDetailEntity;
import cc.lechun.baseservice.model.sms.UserGroupEntity;
import cc.lechun.baseservice.model.sms.UserGroupQueryVo;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.apiinvoke.customer.CustomerInfoInvoke;
import cc.lechun.cms.dto.CustomerInfoDTO;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserService
extends BaseService
implements UserInterface {
    @Autowired
    private GroupDetailMapper groupDetailMapper;
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Autowired
    private CustomerInfoInvoke customerInfoInvoke;

    @Override
    public BaseJsonVo deleteUser(Integer groupId) {
        this.groupDetailMapper.deleteByGroupId(groupId);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateAllGroupNum() {
        UserGroupQueryVo userGroupQueryVo = new UserGroupQueryVo();
        userGroupQueryVo.setPageSize(Integer.valueOf(999999));
        userGroupQueryVo.setCurrentPage(Integer.valueOf(0));
        PageInfo<UserGroupVo> pageInfo = this.userGroupInterface.getUserGroupList(userGroupQueryVo);
        if (pageInfo != null && pageInfo.getList() != null && pageInfo.getList().size() > 0) {
            for (UserGroupVo groupEntity : pageInfo.getList()) {
                if (groupEntity.getGroupType().intValue() != GroupTypeEnum.TEMPLATE.getValue()) continue;
                this.updateGroupNum(groupEntity.getId());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateGroupNum(int groupId) {
        GroupDetailQuery groupDetailQuery = new GroupDetailQuery();
        groupDetailQuery.setCurrentPage(0);
        groupDetailQuery.setPageSize(9999999);
        groupDetailQuery.setGroupId(groupId);
        long total = this.getUserByGroupId(groupDetailQuery).getTotal();
        this.logger.info("\u67e5\u8be2\u7528\u6237\u7ec4\u7528\u6237\u6570:{}", (Object)total);
        UserGroupEntity update = new UserGroupEntity();
        update.setId(Integer.valueOf(groupId));
        update.setNum(Integer.valueOf(new Long(total).intValue()));
        this.userGroupInterface.saveGroup(update);
        this.logger.info("\u7528\u6237\u7ec4\u7528\u6237\u6570\u66f4\u65b0\u6210\u529f:{}", (Object)total);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateGroupNum(int groupId, int num) {
        this.logger.info("\u67e5\u8be2\u7528\u6237\u7ec4\u7528\u6237\u6570:{}", (Object)num);
        UserGroupEntity update = new UserGroupEntity();
        update.setId(Integer.valueOf(groupId));
        update.setNum(Integer.valueOf(new Long(num).intValue()));
        this.userGroupInterface.saveGroup(update);
        this.logger.info("\u7528\u6237\u7ec4\u7528\u6237\u6570\u66f4\u65b0\u6210\u529f:{}", (Object)num);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo<GroupDetailEntity> getUserByGroupId(GroupDetailQuery user) {
        Page page = PageHelper.startPage((int)user.getCurrentPage(), (int)user.getPageSize());
        GroupDetailEntity groupDetailEntity = new GroupDetailEntity();
        if (user.getGroupId() != null) {
            groupDetailEntity.setGroupId(user.getGroupId());
        }
        this.groupDetailMapper.getList(groupDetailEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveUserList(List<GroupDetailEntity> list) {
        if (list != null && list.size() > 0) {
            list.forEach(user -> {
                BaseJsonVo baseJsonVo;
                if (StringUtils.isEmpty((String)user.getCustomerId())) {
                    user.setCustomerId("");
                }
                if (StringUtils.isEmpty((String)user.getEmail())) {
                    user.setEmail("");
                }
                if (StringUtils.isEmpty((String)user.getMobile())) {
                    if (StringUtils.isNotEmpty((String)user.getCustomerId())) {
                        baseJsonVo = this.customerInfoInvoke.getCustomerInfo(user.getCustomerId(), 1);
                        if (baseJsonVo.isSuccess()) {
                            user.setMobile(((CustomerInfoDTO)baseJsonVo.getValue()).getMobile());
                        }
                    } else {
                        user.setOpenId("");
                    }
                }
                if (StringUtils.isEmpty((String)user.getOpenId())) {
                    if (StringUtils.isNotEmpty((String)user.getCustomerId())) {
                        baseJsonVo = this.customerInfoInvoke.getCustomerInfo(user.getCustomerId(), 1);
                        if (baseJsonVo.isSuccess()) {
                            user.setOpenId(((CustomerInfoDTO)baseJsonVo.getValue()).getOpenId());
                        }
                    } else {
                        user.setOpenId("");
                    }
                }
                user.setCreateTime(DateUtils.now());
                this.logger.info("\u7528\u6237\u7ec4\u7528\u6237:{}", (Object)user.toString());
            });
        }
        Integer groupId = list.get(0).getGroupId();
        this.userGroupInterface.updateStatus(groupId, 1, null);
        this.updateGroupNum(groupId, list.size());
        return this.groupDetailMapper.batchInsert(list) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

