/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.ruleUser;

import cc.lechun.baseservice.entity.TagEntity;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.baseservice.model.sms.UserGroupEntity;
import cc.lechun.baseservice.service.TagInterface;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.baseservice.service.UserGroupRuleInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.ruleUser.IRuleCustomer;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleUserContext
extends BaseService {
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Autowired
    private UserGroupRuleInterface groupRuleInterface;
    @Autowired
    private TagInterface tagInterface;
    @Autowired
    private UserInterface userInterface;
    private final Map<String, IRuleCustomer> ruleCustomerMap = new ConcurrentHashMap<String, IRuleCustomer>();

    @Autowired
    public RuleUserContext(Map<String, IRuleCustomer> ruleCustomerMap) {
        this.ruleCustomerMap.clear();
        ruleCustomerMap.forEach((k, v) -> this.ruleCustomerMap.put((String)k, (IRuleCustomer)v));
    }

    public void importLableUser(final Integer groupId) {
        ThreadPool.services.execute(new Runnable(){

            @Override
            public void run() {
                RuleUserContext.this.userInterface.deleteUser(groupId);
                RuleUserContext.this.logger.info("\u5f00\u59cb\u5bfc\u5165\u7528\u6237:groupId={}", (Object)groupId);
                UserGroupEntity groupEntity = RuleUserContext.this.userGroupInterface.getGroup(groupId);
                if (groupEntity != null) {
                    BaseJsonVo<List<TagRuleEntity>> result = RuleUserContext.this.groupRuleInterface.getTagRuleListByGroupId(groupId);
                    if (!result.isSuccess()) {
                        return;
                    }
                    RuleUserContext.this.logger.info("\u67e5\u8be2\u7528\u6237\u7ec4:{}", (Object)groupEntity.toString());
                    List tagIdList = ((List)result.getValue()).stream().filter(RuleUserContext.distinctByKey(b -> b.getTagId())).map(TagRuleEntity::getTagId).collect(Collectors.toList());
                    if (tagIdList != null && tagIdList.size() > 0) {
                        RuleUserContext.this.logger.info("\u67e5\u8be2\u7528\u6237\u7ec4\u6807\u7b7e:{}", tagIdList.get(0));
                        TagEntity tagEntity = RuleUserContext.this.tagInterface.getTagEntityByTagId((Integer)tagIdList.get(0));
                        Integer tagId = tagEntity.getPid() == 0 ? tagEntity.getId() : tagEntity.getPid();
                        IRuleCustomer ruleCustomer = (IRuleCustomer)RuleUserContext.this.ruleCustomerMap.get("tag_" + tagId);
                        if (ruleCustomer != null) {
                            ruleCustomer.saveGroupUser((List)result.getValue());
                        }
                    }
                }
            }
        });
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

