/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.channel;

import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.baseservice.service.apiinvoke.mall.MallCashInvoke;
import cc.lechun.baseservice.service.channel.MessageHandle;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.sms.service.impl.MW.MwrptResult;
import cc.lechun.sms.service.impl.MW.RPTResult;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageContext
extends BaseService {
    private final Map<String, MessageHandle> messageHandleMap = new ConcurrentHashMap<String, MessageHandle>();
    @Autowired
    private MallCashInvoke cashInvoke;

    @Autowired
    public MessageContext(Map<String, MessageHandle> messageHandle) {
        this.messageHandleMap.clear();
        messageHandle.forEach((k, v) -> this.messageHandleMap.put((String)k, (MessageHandle)v));
    }

    public BaseJsonVo getMongateBalance() {
        MessageHandle messageHandle = this.messageHandleMap.get(MessageTypeEnum.SMS.getName());
        if (messageHandle != null) {
            return messageHandle.getMongateBalance();
        }
        return BaseJsonVo.error((String)"\u67e5\u8be2\u51fa\u9519");
    }

    public MwrptResult getRptResult(RPTResult rptResult) {
        MessageHandle messageHandle = this.messageHandleMap.get(MessageTypeEnum.SMS.getName());
        if (messageHandle != null) {
            return messageHandle.getRptResult(rptResult);
        }
        return new MwrptResult();
    }

    public BaseJsonVo pushMessage(String content, String account, String custid) {
        MessageHandle messageHandle = this.messageHandleMap.get(MessageTypeEnum.SMS.getName());
        if (messageHandle != null) {
            return messageHandle.pushMessage(content, account, custid);
        }
        return BaseJsonVo.error((String)"\u521d\u59cb\u5316\u51fa\u9519");
    }

    public BaseJsonVo pushMessage(Map<String, Object> param) {
        String action = param.get("action").toString();
        Integer platformId = Integer.valueOf(param.get("platformId").toString());
        List list = (List)param.get("list");
        if (list != null) {
            list.forEach(userMessageVo -> {
                this.logger.info("\u63a5\u6536\u6d88\u606f\u5bf9\u8c61:{}", (Object)userMessageVo.toString());
                LocalTime now = LocalTime.now();
                if (now.getHour() >= 8 && now.getHour() <= 22) {
                    this.pushMessage((UserMessageVo)userMessageVo, platformId);
                } else {
                    this.logger.info("\u5f53\u65f6\u65f6\u95f4\u4e3a:{},\u907f\u514d\u9a9a\u6270\u7528\u6237\u4e0d\u63a8\u9001\u6d88\u606f", (Object)DateUtils.now());
                }
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo pushMessage(UserMessageVo messageVo, Integer platformId) {
        if (messageVo != null) {
            this.logger.info("\u5f00\u59cb\u7ed9\u7528\u6237\u63a8\u9001\u6d88\u606f:{}", (Object)messageVo.toString());
            MessageHandle messageHandle = this.messageHandleMap.get(MessageTypeEnum.getName(messageVo.getType()));
            if (messageHandle != null) {
                boolean flag = true;
                if (StringUtils.isNotEmpty((String)messageVo.getActiveNo())) {
                    if (StringUtils.isNotEmpty((String)messageVo.getCustomerId())) {
                        try {
                            BaseJsonVo baseJsonVo = this.cashInvoke.sendCashticket(messageVo.getCustomerId(), messageVo.getActiveNo(), 0.0, "", platformId, true, true);
                            if (!baseJsonVo.isSuccess()) {
                                if (!baseJsonVo.getMessage().equals("\u6ca1\u6709\u6307\u5b9a\u53d1\u653e\u4f18\u60e0\u5238\u6279\u6b21")) {
                                    flag = false;
                                }
                                this.logger.info("\u7528\u6237:{}\u4f18\u60e0\u5238\u53d1\u653e\u5931\u8d25,\u6d88\u606f{}", (Object)messageVo.getCustomerId(), (Object)baseJsonVo.getMessage());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.logger.info("\u7528\u6237customerId\u4e3a\u7a7a\uff0c\u4e0d\u53d1\u9001\u4f18\u60e0\u5238", (Object)messageVo.toString());
                    }
                } else {
                    this.logger.info("\u4efb\u52a1:{}\u672a\u5173\u8054\u6d3b\u52a8\uff0c\u4e0d\u53d1\u9001\u4f18\u60e0\u5238", (Object)messageVo.toString());
                }
                if (flag) {
                    messageHandle.pushMessage(messageVo);
                }
                return BaseJsonVo.success((Object)"");
            }
        }
        return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
    }

    public BaseJsonVo pushMessage(int type, String content, String accountList, String custid) {
        MessageHandle messageHandle = this.messageHandleMap.get(MessageTypeEnum.getName(type));
        if (messageHandle != null) {
            return messageHandle.pushBatchMessage(content, accountList, custid);
        }
        return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
    }

    public BaseJsonVo pushMessage(SendMessageVo sendMessageVo) {
        MessageHandle messageHandle;
        if (sendMessageVo != null && (messageHandle = this.messageHandleMap.get(MessageTypeEnum.getName(sendMessageVo.getType()))) != null) {
            return messageHandle.pushMessage(sendMessageVo);
        }
        return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
    }
}

