/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.channel;

import cc.lechun.baseservice.cache.RedisService;
import cc.lechun.baseservice.constant.BaseResultEnum;
import cc.lechun.baseservice.constant.MessagePushStatusEnum;
import cc.lechun.baseservice.dao.MessageMapper;
import cc.lechun.baseservice.entity.TaskPushLogEntity;
import cc.lechun.baseservice.entity.TemplateEntity;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.exception.BaseException;
import cc.lechun.baseservice.model.sms.MessageContentDTO;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.baseservice.service.IAppService;
import cc.lechun.baseservice.service.ITemplateService;
import cc.lechun.baseservice.service.SmsMessageResultInterface;
import cc.lechun.baseservice.service.TaskPushLogInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.apiinvoke.active.ActiveInvoke;
import cc.lechun.baseservice.service.apiinvoke.mall.MallCashInvoke;
import cc.lechun.baseservice.service.channel.ChannelMessageBase;
import cc.lechun.baseservice.service.channel.MessageHandle;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.sms.service.IMWIntellectManageService;
import cc.lechun.sms.service.IMWShortUrlManageService;
import cc.lechun.sms.service.IMessageService;
import cc.lechun.sms.service.impl.MW.IntellectQueryDo;
import cc.lechun.sms.service.impl.MW.MwrptResult;
import cc.lechun.sms.service.impl.MW.RPTResult;
import cc.lechun.sms.service.impl.MW.ShortUrlBO;
import cc.lechun.sms.service.impl.MW.ShortUrlParam;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SMS")
public class SmsMessage
extends ChannelMessageBase
implements MessageHandle {
    @Autowired
    private IMessageService messageService;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private MessageMapper messageMapper;
    @Autowired
    private IAppService appService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private UserInterface userInterface;
    @Autowired
    SmsMessageResultInterface smsMessageResultInterface;
    @Autowired
    TaskPushLogInterface taskPushLogInterface;
    @Autowired
    MallCashInvoke mallCashInvoke;
    @Autowired
    IMWIntellectManageService imwIntellectManageService;
    @Autowired
    IMWShortUrlManageService imwShortUrlManageService;
    @Autowired
    ActiveInvoke activeInvoke;

    @Override
    public BaseJsonVo getMongateBalance() {
        return this.messageService.getMongateBalance();
    }

    @Override
    public MwrptResult getRptResult(RPTResult rptResult) {
        return this.smsMessageResultInterface.saveSmsMessageListResult("MW", rptResult);
    }

    @Override
    public void pushMessage(UserMessageVo userMessageVo) {
        int status;
        this.logger.info("\u67e5\u627e\u6a21\u677f\u4fe1\u606f:{}", (Object)userMessageVo.toString());
        if (StringUtils.isEmpty((String)userMessageVo.getMobile())) {
            this.logger.info("\u624b\u673a\u53f7\u4e3a\u7a7a:{}", (Object)userMessageVo.toString());
            return;
        }
        TemplateEntity template = this.templateService.getTemplateEntity(Integer.valueOf(userMessageVo.getTemplateId()));
        if (template == null) {
            throw new BaseException(BaseResultEnum.TEMPLATE_NOT_EXIST);
        }
        this.logger.info("\u77ed\u4fe1/\u5f69\u4fe1\u6a21\u677f:{}", (Object)template.toString());
        MessageContentDTO messageDTO = new MessageContentDTO();
        messageDTO.setMobile(userMessageVo.getMobile());
        Boolean isCaixin = false;
        BaseJsonVo result = null;
        if (StringUtils.isNotEmpty((String)template.getChannelTemplateNo())) {
            try {
                final IntellectQueryDo.Mobiles mobiles = new IntellectQueryDo.Mobiles();
                mobiles.setMobile(userMessageVo.getMobile());
                IntellectQueryDo intellectQueryDo = new IntellectQueryDo();
                intellectQueryDo.setMobiles((List)new ArrayList<IntellectQueryDo.Mobiles>(){
                    {
                        this.add(mobiles);
                    }
                });
                JSONObject jsonObject = this.imwIntellectManageService.queryAimAbility(intellectQueryDo);
                this.logger.info("\u662f\u5426\u80fd\u53d1\uff1a{}", (Object)JsonUtils.toJson((Object)jsonObject, (boolean)false));
                Integer receiveState = (Integer)((HashMap)((ArrayList)((HashMap)jsonObject.get((Object)"data")).get("mobiles")).get(0)).get("receiveState");
                if (receiveState != null && receiveState == 1) {
                    ShortUrlBO shortUrlBO = new ShortUrlBO();
                    shortUrlBO.setTplId(template.getChannelTemplateNo());
                    final ShortUrlParam shortUrlParam = new ShortUrlParam();
                    shortUrlParam.setCustFlag(userMessageVo.getMobile());
                    shortUrlBO.setParamList((List)new ArrayList<ShortUrlParam>(){
                        {
                            this.add(shortUrlParam);
                        }
                    });
                    JSONObject jsonObject1 = this.imwShortUrlManageService.applyAimUrl(shortUrlBO);
                    this.logger.info("\u8f6c\u77ed\u8fde\u63a5\uff1a{}", (Object)JsonUtils.toJson((Object)jsonObject1, (boolean)false));
                    this.logger.info("\u8f6c\u77ed\u8fde\u63a51\uff0c\u6570\u7ec4\u5185\u5bf9\u8c61\u7c7b\u578b\uff1a{}", (Object)JsonUtils.toJson((Object)jsonObject1, (boolean)false));
                    String shortLink = (String)((HashMap)((List)((HashMap)jsonObject1.get((Object)"data")).get("paramList")).get(0)).get("aimUrl");
                    messageDTO.setContent(template.getTemplate() + shortLink);
                    TaskPushLogEntity log = new TaskPushLogEntity();
                    log.setId(userMessageVo.getTaskPushLogId());
                    log.setPushText(messageDTO.getContent());
                    log.setPushThirdTime(DateUtils.now());
                    log.setIsCaixin(1);
                    this.taskPushLogInterface.savePushLogSelect(log);
                    result = this.messageService.send(template.getTemplate() + shortLink, userMessageVo.getMobile(), String.valueOf(log.getId()));
                    if (result.isSuccess()) {
                        isCaixin = true;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u5f69\u4fe1\u5931\u8d25", (Throwable)e);
            }
        }
        if (!isCaixin.booleanValue()) {
            LinkedHashMap<String, String> paraMap = new LinkedHashMap();
            BaseJsonVo<LinkedHashMap<String, String>> baseJsonVo = this.userInterface.getContentParaMap(userMessageVo);
            if (baseJsonVo.isSuccess()) {
                paraMap = (Map)baseJsonVo.getValue();
            }
            if (StringUtils.isNotEmpty((String)template.getShortLink())) {
                if (template.getShortLink().contains("//t.lechun.cc")) {
                    if (StringUtils.isNotEmpty((String)template.getTemplate())) {
                        template.setTemplate(template.getTemplate() + template.getShortLink());
                    }
                } else {
                    String url = template.getShortLink();
                    String regex = "\\$\\{mobile}";
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(url);
                    url = matcher.replaceAll(messageDTO.getMobile());
                    BaseJsonVo jsonVo = this.activeInvoke.getShortLink(url, "", "\u7269\u6d41\u7535call\u77ed\u4fe1\u914d\u56fe");
                    if (jsonVo.isSuccess()) {
                        url = jsonVo.getValue().toString();
                        if (StringUtils.isNotEmpty((String)template.getTemplate())) {
                            template.setTemplate(template.getTemplate() + url);
                        }
                    } else {
                        this.logger.info("\u52a8\u6001\u751f\u6210\u77ed\u8fde\u63a5\u5f02\u5e38" + url);
                        throw new BaseException(BaseResultEnum.GENERATE_SHORT_LINK);
                    }
                }
            }
            messageDTO.setContent(this.renderString(template.getTemplate(), paraMap));
            result = this.messageService.send(messageDTO);
        }
        this.logger.info("\u7528\u6237{}\u77ed\u4fe1{}\u63a8\u9001{}", new Object[]{userMessageVo.getMobile(), messageDTO.getContent(), result.isSuccess()});
        int n = status = result.isSuccess() ? MessagePushStatusEnum.SUCCESS.getValue() : MessagePushStatusEnum.FAIL.getValue();
        if (userMessageVo.getTaskId() != null) {
            result = this.saveUserMessageRecord(userMessageVo, status);
            this.logger.info("\u7528\u6237{}\u77ed\u4fe1{}\u8bb0\u5f55\u4fdd\u5b58{}", new Object[]{userMessageVo.getMobile(), messageDTO.getContent(), result.isSuccess()});
            if (!isCaixin.booleanValue()) {
                TaskPushLogEntity log = new TaskPushLogEntity();
                log.setId(userMessageVo.getTaskPushLogId());
                log.setPushText(messageDTO.getContent());
                log.setIsSuccess(result.isSuccess() ? 1 : 0);
                log.setPushThirdTime(DateUtils.now());
                result = this.taskPushLogInterface.savePushLogSelect(log);
            }
        }
    }

    @Override
    public BaseJsonVo pushMessage(SendMessageVo sendMessageVo) {
        MessageContentDTO messageDTO = new MessageContentDTO();
        messageDTO.setMobile(sendMessageVo.getAccount());
        messageDTO.setContent(sendMessageVo.getContent());
        return this.messageService.send(messageDTO);
    }

    @Override
    public BaseJsonVo pushMessage(String content, String account, String custid) {
        BaseJsonVo baseJsonVo = this.messageService.send(content, account, custid);
        this.logger.info("\u7528\u6237{}\u77ed\u4fe1{}\u63a8\u9001{}", new Object[]{account, content, baseJsonVo.isSuccess()});
        this.smsMessageResultInterface.saveSmsMessageResult("MW", baseJsonVo, account, content);
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo pushBatchMessage(String content, String accountList, String custid) {
        this.logger.info("\u8981\u63a8\u9001\u7684\u624b\u673a\u53f7:{}", (Object)accountList);
        try {
            BaseJsonVo<String> filter = this.mallCashInvoke.filter(1, accountList, null, null, null);
            this.logger.info("\u5224\u65ad\u9ed1\u540d\u5355[{}][{}]", (Object)accountList, (Object)JsonUtils.toJson(filter, (boolean)false));
            if (!filter.isSuccess()) {
                return filter;
            }
            accountList = (String)filter.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info("\u7ecf\u8fc7\u9ed1\u540d\u5355\u8fc7\u6ee4\u540e\u8981\u63a8\u9001\u7684\u624b\u673a\u53f7:{}", (Object)accountList);
        BaseJsonVo baseJsonVo = this.messageService.batchSend(content, accountList, custid);
        this.smsMessageResultInterface.saveSmsMessageListResult("MW", baseJsonVo, accountList, content);
        return baseJsonVo;
    }

    private String getValidateCode(byte length) {
        int base = (int)Math.pow(10.0, length - 1);
        int result = new Random().nextInt(9 * base) + base;
        return String.valueOf(result);
    }

    private String renderString(String content, Map<String, String> map) {
        if (map != null) {
            Set<Map.Entry<String, String>> sets = map.entrySet();
            for (Map.Entry<String, String> entry : sets) {
                String regex = "\\$\\{" + entry.getKey() + "}";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(content);
                content = matcher.replaceAll(String.valueOf(entry.getValue()));
            }
        }
        return content;
    }
}

