/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.cache.RedisService;
import cc.lechun.baseservice.service.IAiCallService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.sms.aicall.AiCallConstant;
import cc.lechun.sms.aicall.commons.in.TaskContact;
import cc.lechun.sms.aicall.commons.out.TokenInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AiCallService
implements IAiCallService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RedisService redisService;

    @Override
    public String getAiCallToken() {
        Object o = this.redisService.get("SOBOT_AI_CALL_TOKEN_REDIS_KEY");
        if (o != null && StringUtils.isNotEmpty((String)o.toString())) {
            return (String)o;
        }
        TokenInfo aiCallToken = AiCallConstant.getAiCallToken();
        if (aiCallToken != null) {
            this.redisService.save("SOBOT_AI_CALL_TOKEN_REDIS_KEY", aiCallToken.getAccessToken(), aiCallToken.getExpiresIn() - 60L);
            return aiCallToken.getAccessToken();
        }
        return null;
    }

    @Override
    public BaseJsonVo getAiModules() {
        String token = this.getAiCallToken();
        if (token == null) {
            return BaseJsonVo.error((String)"\u667a\u9f7fAI\u7535\u8bdd\u83b7\u53d6TOKEN\u5931\u8d25");
        }
        return AiCallConstant.getAiModules((String)token);
    }

    @Override
    public BaseJsonVo createTask() {
        String token = this.getAiCallToken();
        if (token == null) {
            return BaseJsonVo.error((String)"\u667a\u9f7fAI\u7535\u8bdd\u83b7\u53d6TOKEN\u5931\u8d25");
        }
        return AiCallConstant.createTask((String)token);
    }

    @Override
    public BaseJsonVo addMobileToTask(List<TaskContact> contacts) {
        String token = this.getAiCallToken();
        if (token == null) {
            return BaseJsonVo.error((String)"\u667a\u9f7fAI\u7535\u8bdd\u83b7\u53d6TOKEN\u5931\u8d25");
        }
        return AiCallConstant.addMobileToTask((String)token, contacts);
    }
}

