/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.MessageNoticeEnum;
import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.dao.MessageLimitMapper;
import cc.lechun.baseservice.entity.MessageLimitEntity;
import cc.lechun.baseservice.model.sms.MessageLimitDTO;
import cc.lechun.baseservice.service.MessageLimitInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.google.code.ssm.api.ReadThroughAssignCache;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageLimitService
extends BaseService
implements MessageLimitInterface {
    @Autowired
    private MessageLimitMapper messageLimitMapper;
    @Autowired
    protected MemcachedService memcachedService;

    @Override
    public BaseJsonVo deleteMessageLimit(Integer limitId) {
        MessageLimitEntity messageLimitEntity = (MessageLimitEntity)this.messageLimitMapper.selectByPrimaryKey(limitId);
        if (messageLimitEntity == null) {
            return BaseJsonVo.error((String)"\u7684\u7528\u6237\u914d\u7f6e!");
        }
        this.removeCache(messageLimitEntity);
        return this.messageLimitMapper.deleteByPrimaryKey(limitId) > 0 ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    @ReadThroughAssignCache(assignedKey="List2", namespace="MessageLimitService.getMessageLimitList", expiration=300)
    public List<MessageLimitEntity> getMessageLimitList() {
        MessageLimitEntity query = new MessageLimitEntity();
        return this.messageLimitMapper.getList(query);
    }

    @Override
    @ReadThroughAssignCache(assignedKey="List", namespace="MessageLimitService.getMessageLimitList", expiration=300)
    public List<MessageLimitDTO> getMessageLimitDTOList() {
        MessageLimitEntity query = new MessageLimitEntity();
        List list = this.messageLimitMapper.getList(query);
        ArrayList<MessageLimitDTO> result = new ArrayList<MessageLimitDTO>();
        for (MessageLimitEntity messageLimitEntity : list) {
            MessageLimitDTO messageLimitDTO = new MessageLimitDTO();
            BeanUtils.copyProperties((Object)messageLimitEntity, (Object)messageLimitDTO);
            messageLimitDTO.setLimitTypeName(MessageTypeEnum.getName(messageLimitEntity.getLimitType()));
            messageLimitDTO.setTaskTypeName(MessageNoticeEnum.getName(messageLimitEntity.getTaskType()));
            result.add(messageLimitDTO);
        }
        return result;
    }

    @Override
    public BaseJsonVo saveMessageLimit(MessageLimitEntity messageLimitEntity) {
        this.removeCache(messageLimitEntity);
        if (messageLimitEntity.getLimitId() == null || messageLimitEntity.getLimitId() == 0) {
            MessageLimitEntity query = new MessageLimitEntity();
            query.setLimitType(messageLimitEntity.getLimitType());
            query.setTaskType(messageLimitEntity.getTaskType());
            MessageLimitEntity temp = (MessageLimitEntity)this.messageLimitMapper.getSingle(query);
            if (temp != null) {
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u9650\u5236\u89c4\u5219\u5df2\u5b58\u5728!");
            }
            return this.messageLimitMapper.insert(messageLimitEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        this.messageLimitMapper.updateByPrimaryKeySelective(messageLimitEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    private void removeCache(MessageLimitEntity messageLimitEntity) {
        this.memcachedService.delete("MessageLimitService.getMessageLimitList", "List2");
        this.memcachedService.delete("MessageLimitService.getMessageLimitList", "List");
    }
}

