/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.RealTimeExecTaskStatusEnum;
import cc.lechun.baseservice.dao.RealtimeTaskMapper;
import cc.lechun.baseservice.entity.RealtimeTaskEntity;
import cc.lechun.baseservice.service.RealTimeTaskInterface;
import cc.lechun.baseservice.service.TaskInterface;
import cc.lechun.baseservice.service.apiinvoke.customer.CustomerInfoInvoke;
import cc.lechun.cms.dto.CustomerInfoDTO;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class RealTimeTaskService
implements RealTimeTaskInterface {
    private static final Logger logger = LoggerFactory.getLogger(RealTimeTaskService.class);
    @Autowired
    private RealtimeTaskMapper realtimeTaskMapper;
    @Autowired
    protected MemcachedService memcachedService;
    @Autowired
    private TaskInterface taskInterface;
    @Autowired
    private CustomerInfoInvoke customerInfoInvoke;

    @Override
    @Async
    public void pushRealTimeTask() {
        int pageSize = 1000;
        int i = 0;
        while (true) {
            Page page = PageHelper.startPage((int)i, (int)pageSize);
            RealtimeTaskEntity realtimeTaskEntity = new RealtimeTaskEntity();
            realtimeTaskEntity.setExecStatus(RealTimeExecTaskStatusEnum.UNDO.getValue());
            List<RealtimeTaskEntity> list = this.realtimeTaskMapper.getCustomerList(RealTimeExecTaskStatusEnum.UNDO.getValue(), DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-2), (String)""));
            boolean stopFlag = false;
            if (list.size() == 0 || list.size() < pageSize) {
                stopFlag = true;
            }
            for (RealtimeTaskEntity taskEntity : list) {
                if (!taskEntity.getCreateTime().before(DateUtils.now())) continue;
                this.saveRealTimeTaskResult(taskEntity.getRealtimeTaskId(), "", RealTimeExecTaskStatusEnum.DONE_SUBSCRIPT.getValue());
                BaseJsonVo customerInfoResult = this.customerInfoInvoke.getCustomerInfo(taskEntity.getAccount(), taskEntity.getPlatformId());
                if (customerInfoResult.isSuccess()) {
                    logger.info("\u7528\u6237\u4fe1\u606f:" + ((CustomerInfoDTO)customerInfoResult.getValue()).toString());
                    if (customerInfoResult.getValue() != null && ((CustomerInfoDTO)customerInfoResult.getValue()).getIsNew() != null && ((CustomerInfoDTO)customerInfoResult.getValue()).getIsNew() == 1) {
                        this.taskInterface.preview(taskEntity.getTaskId(), taskEntity.getAccount());
                        continue;
                    }
                    logger.info("{}\u975e\u65b0\u7528\u6237\u4e0d\u63a8\u9001", (Object)((CustomerInfoDTO)customerInfoResult.getValue()).getCustomerId());
                    continue;
                }
                logger.info("\u67e5\u8be2\u7528\u6237\u51fa\u9519:{}", (Object)customerInfoResult.getMessage());
            }
            if (stopFlag) break;
            ++i;
        }
    }

    @Override
    @Async
    public void pushRealTimeTask(int type) {
        int pageSize = 1000;
        int i = 0;
        while (true) {
            Page page = PageHelper.startPage((int)i, (int)pageSize);
            RealtimeTaskEntity realtimeTaskEntity = new RealtimeTaskEntity();
            if (type == RealTimeExecTaskStatusEnum.DONE_SUBSCRIPT.getValue()) {
                realtimeTaskEntity.setExecStatus(RealTimeExecTaskStatusEnum.UNDO.getValue());
            } else if (type == RealTimeExecTaskStatusEnum.DONE_MARKET.getValue()) {
                realtimeTaskEntity.setExecStatus(RealTimeExecTaskStatusEnum.DONE_SUBSCRIPT.getValue());
            }
            List<RealtimeTaskEntity> list = this.realtimeTaskMapper.getCustomerList(type, DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-2), (String)""));
            boolean stopFlag = false;
            if (list.size() == 0 || list.size() < pageSize) {
                stopFlag = true;
            }
            for (RealtimeTaskEntity taskEntity : list) {
                if (!taskEntity.getCreateTime().before(DateUtils.now())) continue;
                this.saveRealTimeTaskResult(taskEntity.getRealtimeTaskId(), "", type + 1);
                if (type == RealTimeExecTaskStatusEnum.UNDO.getValue()) {
                    BaseJsonVo customerInfoResult = this.customerInfoInvoke.getCustomerInfo(taskEntity.getAccount(), taskEntity.getPlatformId());
                    if (customerInfoResult.isSuccess()) {
                        logger.info("\u7528\u6237\u4fe1\u606f:" + ((CustomerInfoDTO)customerInfoResult.getValue()).toString());
                        if (customerInfoResult.getValue() != null && ((CustomerInfoDTO)customerInfoResult.getValue()).getIsNew() != null && ((CustomerInfoDTO)customerInfoResult.getValue()).getIsNew() == 1) {
                            this.taskInterface.preview(taskEntity.getTaskId(), taskEntity.getAccount());
                            continue;
                        }
                        logger.info("{}\u975e\u65b0\u7528\u6237\u4e0d\u63a8\u9001", (Object)((CustomerInfoDTO)customerInfoResult.getValue()).getCustomerId());
                        continue;
                    }
                    logger.info("\u67e5\u8be2\u7528\u6237\u51fa\u9519:{}", (Object)customerInfoResult.getMessage());
                    continue;
                }
                if (type != RealTimeExecTaskStatusEnum.DONE_SUBSCRIPT.getValue()) continue;
                logger.info("\u7528\u6237\u4fe1\u606f:" + taskEntity.getAccount());
                BaseJsonVo baseJsonVo = this.taskInterface.preview(57, taskEntity.getAccount());
                logger.info("\u7528\u6237\u4fe1\u606f{} \u63a8\u9001:{}", (Object)taskEntity.getAccount(), (Object)baseJsonVo.isSuccess());
            }
            if (stopFlag) break;
            ++i;
        }
    }

    @Override
    public BaseJsonVo saveRealTimeTask(String account, Integer taskId, Integer platformId) {
        RealtimeTaskEntity realtimeTaskEntity = new RealtimeTaskEntity();
        realtimeTaskEntity.setPlatformId(platformId);
        realtimeTaskEntity.setAccount(account);
        realtimeTaskEntity.setTaskId(taskId);
        realtimeTaskEntity.setCreateTime(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)1800));
        realtimeTaskEntity.setExecStatus(RealTimeExecTaskStatusEnum.UNDO.getValue());
        realtimeTaskEntity.setMessage("");
        return this.realtimeTaskMapper.insertSelective(realtimeTaskEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveRealTimeTaskResult(Integer realtimeTaskId, String message, Integer execStatus) {
        RealtimeTaskEntity realtimeTaskEntity = new RealtimeTaskEntity();
        realtimeTaskEntity.setRealtimeTaskId(realtimeTaskId);
        realtimeTaskEntity.setExecStatus(execStatus);
        realtimeTaskEntity.setCreateTime(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)7200));
        realtimeTaskEntity.setTaskId(57);
        this.realtimeTaskMapper.updateByPrimaryKeySelective(realtimeTaskEntity);
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(RealtimeTaskEntity realtimeTaskEntity) {
        this.memcachedService.delete("RealTimeTaskService.getAppEntity", realtimeTaskEntity.getRealtimeTaskId().toString());
    }
}

