/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.Columns;
import cc.lechun.baseservice.dao.MessageMapper;
import cc.lechun.baseservice.entity.MessageEntity;
import cc.lechun.baseservice.model.sms.MessageDTO;
import cc.lechun.baseservice.service.SmsMessageResultInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.sms.service.impl.MW.MwrptResult;
import cc.lechun.sms.service.impl.MW.RPT;
import cc.lechun.sms.service.impl.MW.RPTResult;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsMessageResultService
extends BaseService
implements SmsMessageResultInterface {
    @Autowired
    private MessageMapper messageMapper;

    @Override
    public MwrptResult saveSmsMessageListResult(String channel, final RPTResult rptResult) {
        MwrptResult mwrptResult = new MwrptResult();
        try {
            mwrptResult.setCmd(rptResult.getCmd());
            mwrptResult.setSeqid(rptResult.getSeqid());
            if (rptResult == null) {
                mwrptResult.setResult(-1);
                return mwrptResult;
            }
            if (CollectionUtils.isEmpty((Collection)rptResult.getRpts())) {
                mwrptResult.setResult(-1);
                return mwrptResult;
            }
            mwrptResult.setResult(0);
            ExecutorService pool = Executors.newFixedThreadPool(1);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    for (RPT rpt : rptResult.getRpts()) {
                        MessageEntity query = new MessageEntity();
                        query.setMobile(rpt.getMobile());
                        query.setBizId(rpt.getCustid());
                        MessageEntity messageEntity = (MessageEntity)SmsMessageResultService.this.messageMapper.getSingle(query);
                        if (messageEntity == null || messageEntity.getId() == null) continue;
                        messageEntity.setSendStatus(rpt.getStatus() == 0 ? 2 : 0);
                        messageEntity.setUpdateDate(DateUtils.now());
                        messageEntity.setReceiveDate(DateUtils.now());
                        messageEntity.setFailCode(rpt.getErrcode());
                        SmsMessageResultService.this.messageMapper.updateByPrimaryKeySelective(messageEntity);
                    }
                }
            });
            pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            mwrptResult.setResult(-1);
        }
        return mwrptResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveSmsMessageResult(String channel, BaseJsonVo result, MessageDTO messageDTO) {
        try {
            MessageEntity message = new MessageEntity();
            message.setMobile(messageDTO.getMobile());
            message.setParams("");
            boolean templateId = false;
            if (messageDTO.getTemplateId() != null) {
                message.setTemplateId(Short.valueOf(messageDTO.getTemplateId()));
            }
            if (result.isSuccess()) {
                message.setSendStatus(Columns.SendStatus.SENDING);
            } else {
                message.setSendStatus(Columns.SendStatus.FAILURE);
                message.setFailCode(result.getError_code().toString());
            }
            message.setRetry(0);
            message.setChannel(channel);
            message.setValidateCode("");
            message.setValidateStatus(Columns.ValidateStatus.NO);
            Date now = new Date();
            message.setCreateDate(now);
            message.setUpdateDate(now);
            message.setFailCode(result.getValue().toString());
            int rows = this.messageMapper.insertSelective(message);
            this.logger.info("{}\u63d2\u5165\u7ed3\u679c:{},\u751f\u6210\u7684\u81ea\u589eid\u4e3a:{}", new Object[]{message, rows, message.getId()});
            if (result.isSuccess()) return;
        }
        catch (Exception e) {
            this.logger.error("\u63d2\u5165Message\u6570\u636e\u5f02\u5e38" + messageDTO.toString(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveSmsMessageResult(String channel, BaseJsonVo result, String account, String content) {
        try {
            MessageEntity message = new MessageEntity();
            message.setMobile(account);
            message.setParams(content);
            if (result.isSuccess()) {
                message.setSendStatus(Columns.SendStatus.SENDING);
                message.setBizId(result.getValue().toString());
            } else {
                message.setSendStatus(Columns.SendStatus.FAILURE);
                message.setFailCode(result.getError_code().toString());
            }
            message.setRetry(0);
            message.setChannel(channel);
            message.setValidateCode("");
            message.setValidateStatus(Columns.ValidateStatus.NO);
            Date now = new Date();
            message.setCreateDate(now);
            Short templateId = 1;
            message.setTemplateId(templateId);
            message.setUpdateDate(now);
            message.setFailCode(result.isSuccess() ? "" : result.getError_msg());
            int rows = this.messageMapper.insertSelective(message);
            this.logger.info("{}\u63d2\u5165\u7ed3\u679c:{},\u751f\u6210\u7684\u81ea\u589eid\u4e3a:{}", new Object[]{message, rows, message.getId()});
            if (result.isSuccess()) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u63d2\u5165Message\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void saveSmsMessageListResult(final String channel, final BaseJsonVo result, final String accountList, final String content) {
        try {
            ExecutorService pool = Executors.newFixedThreadPool(1);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    if (accountList.contains(",")) {
                        for (String item : accountList.split(",")) {
                            SmsMessageResultService.this.saveSmsMessageResult(channel, result, item, content);
                        }
                    }
                }
            });
            pool.shutdown();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    @Override
    public boolean hasRecord(String mobile, int day) {
        return this.messageMapper.hasRecord(day, mobile) >= 1;
    }
}

