/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.dao.TagOptionMapper;
import cc.lechun.baseservice.entity.TagOptionEntity;
import cc.lechun.baseservice.service.TagOptionInterface;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TagOptionService
extends BaseService
implements TagOptionInterface {
    @Autowired
    private TagOptionMapper tagOptionMapper;

    @Override
    public BaseJsonVo saveTagOptionEntity(TagOptionEntity tagOptionEntity) {
        TagOptionEntity query = new TagOptionEntity();
        query.setTagId(tagOptionEntity.getTagId());
        query.setTagKey(tagOptionEntity.getTagKey());
        TagOptionEntity temp = (TagOptionEntity)this.tagOptionMapper.getSingle(query);
        if (temp == null) {
            this.tagOptionMapper.insert(tagOptionEntity);
        } else {
            tagOptionEntity.setId(temp.getId());
            this.tagOptionMapper.updateByPrimaryKeySelective(tagOptionEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @ReadThroughSingleCache(namespace="TagOptionService.getTagOptionListByTagId", expiration=80)
    public List<TagOptionEntity> getTagOptionListByTagId(@ParameterValueKeyProvider Integer tagId) {
        TagOptionEntity tagOptionEntity = new TagOptionEntity();
        tagOptionEntity.setTagId(tagId);
        tagOptionEntity.setStatus(1);
        return this.tagOptionMapper.getList(tagOptionEntity);
    }

    @Override
    public PageInfo<TagOptionEntity> getTagOptionListByTagId(Integer tagId, String name) {
        Page page = PageHelper.startPage((int)1, (int)99990);
        page.setOrderBy("ID desc");
        TagOptionEntity tagOptionEntity = new TagOptionEntity();
        tagOptionEntity.setTagId(tagId);
        tagOptionEntity.setStatus(1);
        if (StringUtils.isNotEmpty((String)name)) {
            tagOptionEntity.setTagValue(name);
        }
        this.tagOptionMapper.getTagOptionList(tagOptionEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    @ReadThroughSingleCache(namespace="TagOptionService.getTagOption", expiration=120)
    public TagOptionEntity getTagOption(@ParameterValueKeyProvider(order=0) Integer tagId, @ParameterValueKeyProvider(order=1) String key) {
        TagOptionEntity tagOptionEntity = new TagOptionEntity();
        tagOptionEntity.setTagId(tagId);
        tagOptionEntity.setStatus(1);
        tagOptionEntity.setTagKey(key);
        return (TagOptionEntity)this.tagOptionMapper.getSingle(tagOptionEntity);
    }
}

