/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.TagClassEnum;
import cc.lechun.baseservice.dao.TagMapper;
import cc.lechun.baseservice.entity.TagEntity;
import cc.lechun.baseservice.entity.TagListVo;
import cc.lechun.baseservice.entity.TagVo;
import cc.lechun.baseservice.service.TagInterface;
import cc.lechun.baseservice.service.TagOptionInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TagService
extends BaseService
implements TagInterface {
    @Autowired
    private TagMapper tagMapper;
    @Autowired
    private TagOptionInterface tagOptionInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="TagService.getTagList", expiration=80)
    public List<TagVo> getTagList(@ParameterValueKeyProvider Integer pid) {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setPid(pid);
        List list = this.tagMapper.getList(tagEntity);
        ArrayList<TagVo> tagVoList = new ArrayList<TagVo>();
        if (list.size() > 0) {
            list.forEach(tag -> {
                TagVo tagVo = new TagVo();
                BeanUtils.copyProperties((Object)tag, (Object)tagVo);
                tagVo.setTagClassName(TagClassEnum.getName(tag.getTagClass()));
                tagVoList.add(tagVo);
            });
        }
        return tagVoList;
    }

    @Override
    @ReadThroughSingleCache(namespace="TagService.getTagListVoList", expiration=300)
    public List<TagListVo> getTagListVoList(@ParameterValueKeyProvider Integer pid) {
        ArrayList<TagListVo> result = new ArrayList<TagListVo>();
        List<TagVo> tagVoList = this.getTagList(pid);
        tagVoList.forEach(tagVo -> tagVo.setTagOptionList(this.tagOptionInterface.getTagOptionListByTagId(tagVo.getId())));
        List<TagClassEnum> temp = TagClassEnum.getList();
        temp.forEach(tagClassEnum -> {
            TagListVo tagListVo = new TagListVo();
            tagListVo.setTagClassName(tagClassEnum.getName());
            tagListVo.setTagClassId(tagClassEnum.getValue());
            tagListVo.setTagVos(tagVoList.stream().filter(tagVo -> tagVo.getTagClass().equals(tagClassEnum.getValue())).collect(Collectors.toList()));
            result.add(tagListVo);
        });
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="TagService.getTagEntityByTagId", expiration=80)
    public TagEntity getTagEntityByTagId(@ParameterValueKeyProvider Integer tagId) {
        return (TagEntity)this.tagMapper.selectByPrimaryKey(tagId);
    }

    @Override
    public BaseJsonVo deleteTagById(Integer tagId) {
        TagEntity tagEntity = new TagEntity();
        tagEntity.setId(tagId);
        tagEntity.setPid(0);
        this.removeCache(tagEntity);
        return this.tagMapper.deleteByPrimaryKey(tagId) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public void saveTag(TagEntity tagEntity) {
        this.removeCache(tagEntity);
        if (tagEntity.getId() == null || tagEntity.getId() == 0) {
            tagEntity.setCreateTime(DateUtils.now());
            this.tagMapper.insert(tagEntity);
        } else {
            this.tagMapper.updateByPrimaryKeySelective(tagEntity);
        }
    }

    private void removeCache(TagEntity tagEntity) {
        if (tagEntity.getPid() != null) {
            this.memcachedService.delete("TagService.getTagList", tagEntity.getPid().toString());
            this.memcachedService.delete("TagService.getTagListVoList", tagEntity.getPid().toString());
        }
        if (tagEntity.getId() != null) {
            this.memcachedService.delete("TagService.getTagEntityByTagId", tagEntity.getId().toString());
        }
    }
}

