/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.TagTypeEnum;
import cc.lechun.baseservice.dao.TagTypeRuleMapper;
import cc.lechun.baseservice.entity.TagTypeRuleEntity;
import cc.lechun.baseservice.entity.TagTypeRuleQueryVo;
import cc.lechun.baseservice.entity.TagTypeRuleVo;
import cc.lechun.baseservice.service.TagTypeRuleInterface;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TagTypeRuleService
extends BaseService
implements TagTypeRuleInterface {
    @Autowired
    private TagTypeRuleMapper tagTypeRuleMapper;

    @Override
    public PageInfo getRuleTypeList(TagTypeRuleQueryVo tagTypeRuleQueryVo) {
        Page page = PageHelper.startPage((int)tagTypeRuleQueryVo.getCurrentPage(), (int)tagTypeRuleQueryVo.getPageSize());
        page.setOrderBy("ID desc");
        TagTypeRuleEntity typeRuleEntity = new TagTypeRuleEntity();
        if (tagTypeRuleQueryVo.getTagType() != null && tagTypeRuleQueryVo.getTagType() != 0) {
            typeRuleEntity.setTagType(tagTypeRuleQueryVo.getTagType());
        }
        List list = this.tagTypeRuleMapper.getList(typeRuleEntity);
        List result = list.stream().map(typeRule -> {
            TagTypeRuleVo tagTypeRuleVo = new TagTypeRuleVo();
            BeanUtils.copyProperties((Object)typeRule, (Object)tagTypeRuleVo);
            tagTypeRuleVo.setTagTypeName(TagTypeEnum.getName(typeRule.getTagType()));
            return tagTypeRuleVo;
        }).collect(Collectors.toList());
        PageInfo pg = page.toPageInfo();
        pg.setList(result);
        return pg;
    }

    @Override
    @ReadThroughSingleCache(namespace="TagTypeRuleService.getTagTypeRuleList", expiration=80)
    public List<TagTypeRuleEntity> getTagTypeRuleList(@ParameterValueKeyProvider Integer tagType) {
        TagTypeRuleEntity tagTypeRuleEntity = new TagTypeRuleEntity();
        tagTypeRuleEntity.setTagType(tagType);
        return this.tagTypeRuleMapper.getList(tagTypeRuleEntity);
    }

    @Override
    @ReadThroughAssignCache(assignedKey="List", namespace="TagTypeRuleService.getTagTypeRuleList", expiration=600)
    public List<TagTypeRuleEntity> getTagTypeRuleList() {
        TagTypeRuleEntity tagTypeRuleEntity = new TagTypeRuleEntity();
        return this.tagTypeRuleMapper.getList(tagTypeRuleEntity);
    }

    @Override
    public BaseJsonVo saveTypeRule(TagTypeRuleEntity typeRuleEntity) {
        if (typeRuleEntity.getId() == null || typeRuleEntity.getId() == 0) {
            typeRuleEntity.setId(null);
            this.tagTypeRuleMapper.insert(typeRuleEntity);
        } else {
            this.tagTypeRuleMapper.updateByPrimaryKey(typeRuleEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo delete(Integer id) {
        this.tagTypeRuleMapper.deleteByPrimaryKey(id);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }
}

