/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.cache.RedisService;
import cc.lechun.baseservice.constant.GroupDetailPushStatusEnum;
import cc.lechun.baseservice.constant.GroupTypeEnum;
import cc.lechun.baseservice.constant.MessageTypeEnum;
import cc.lechun.baseservice.constant.PeriodTypeEnum;
import cc.lechun.baseservice.constant.TaskPushTypeEnum;
import cc.lechun.baseservice.constant.TaskStatusEnum;
import cc.lechun.baseservice.dao.TagRuleMapper;
import cc.lechun.baseservice.dao.TaskContentMapper;
import cc.lechun.baseservice.dao.TaskContentSMSMapper;
import cc.lechun.baseservice.dao.TaskContentWxActionMapper;
import cc.lechun.baseservice.dao.TaskMapper;
import cc.lechun.baseservice.entity.GroupDetailEntity;
import cc.lechun.baseservice.entity.GroupDetailQuery;
import cc.lechun.baseservice.entity.MessageLimitEntity;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.baseservice.entity.TaskContentEntity;
import cc.lechun.baseservice.entity.TaskContentSMSEntity;
import cc.lechun.baseservice.entity.TaskContentWxActionEntity;
import cc.lechun.baseservice.entity.TaskEntity;
import cc.lechun.baseservice.entity.TaskPushLogEntity;
import cc.lechun.baseservice.entity.TaskPushRecordEntity;
import cc.lechun.baseservice.entity.TaskVo;
import cc.lechun.baseservice.entity.TemplateEntity;
import cc.lechun.baseservice.entity.UserGroupEntity;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.model.sms.TaskQueryVo;
import cc.lechun.baseservice.service.IAiCallService;
import cc.lechun.baseservice.service.ITemplateService;
import cc.lechun.baseservice.service.MessageLimitInterface;
import cc.lechun.baseservice.service.TaskInterface;
import cc.lechun.baseservice.service.TaskPushLogInterface;
import cc.lechun.baseservice.service.TaskPushRecordInterface;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.apiinvoke.active.ActiveInvoke;
import cc.lechun.baseservice.service.apiinvoke.csms.CsmsInvoke;
import cc.lechun.baseservice.service.apiinvoke.customer.CustomerInfoInvoke;
import cc.lechun.baseservice.service.apiinvoke.mall.MallCashInvoke;
import cc.lechun.baseservice.service.apiinvoke.tmall.TmallInvoke;
import cc.lechun.baseservice.service.apiinvoke.wechat.KeyworldInvoke;
import cc.lechun.baseservice.service.channel.MessageContext;
import cc.lechun.baseservice.service.channel.SmsMessage;
import cc.lechun.cms.dto.ActiveDTO;
import cc.lechun.cms.dto.CustomerDetailDTO;
import cc.lechun.csmsapi.dto.refund.PlatformDTO;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.sms.aicall.commons.in.TaskContact;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class TaskService
extends BaseService
implements TaskInterface {
    @Autowired
    private RedisService redisService;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private UserInterface userService;
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Lazy
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private MessageContext messageContext;
    @Autowired
    private ActiveInvoke activeInvoke;
    @Autowired
    private KeyworldInvoke keyworldInvoke;
    @Value(value="${lechun.environment}")
    private String environment;
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private MessageLimitInterface messageLimitInterface;
    @Autowired
    private CustomerInfoInvoke customerInfoInvoke;
    @Autowired
    private TaskPushRecordInterface taskPushRecordInterface;
    @Autowired
    private TaskPushLogInterface taskPushLogInterface;
    @Autowired
    SmsMessage smsMessage;
    @Autowired
    MallCashInvoke mallCashInvoke;
    @Autowired
    private TagRuleMapper tagRuleMapper;
    @Autowired
    private TaskContentMapper taskContentMapper;
    @Autowired
    private TaskContentSMSMapper taskContentSMSMapper;
    @Autowired
    private TaskContentWxActionMapper taskContentWxActionMapper;
    @Autowired
    private TmallInvoke tmallInvoke;
    @Autowired
    private CsmsInvoke csmsInvoke;
    @Autowired
    private IAiCallService iAiCallService;
    private final String MESSAGE_REDIS_KEY = "MESSAGE_REDIS_KEY";
    private final String UNSEND_MESSAGE_REDIS_KEY = "UNSEND_MESSAGE_REDIS_KEY";

    @Override
    public void removeCache() {
        Set sets = this.redisCacheUtil.getKeysPattern("MESSAGE_REDIS_KEY");
        sets.addAll(this.redisCacheUtil.getKeysPattern("UNSEND_MESSAGE_REDIS_KEY"));
        if (sets != null & sets.size() > 0) {
            for (String s : sets) {
                Set keys = this.redisCacheUtil.getCacheSet(s);
                if (!(keys != null & keys.size() > 0)) continue;
                for (String key : keys) {
                    Object o;
                    if (key == null || (o = this.redisCacheUtil.get(key)) != null) continue;
                    this.redisCacheUtil.remove(s);
                }
            }
        }
        this.logger.info("\u91ca\u653eredis cache\u5b8c\u6bd5 {}", (Object)"\u5b8c\u6210");
    }

    @Override
    public void stopTask() {
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setTaskStatus(TaskStatusEnum.SENDING.getValue());
        List list = this.taskMapper.getList(taskEntity);
        if (list.size() > 0) {
            list.forEach(task -> this.setTaskFinish((TaskEntity)task));
        }
    }

    @Override
    public BaseJsonVo deleteTask(int taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(Integer.valueOf(taskId));
        if (task == null) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        if (task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue() || task.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            return BaseJsonVo.success((Object)("\u4efb\u52a1:" + TaskStatusEnum.getName(task.getTaskStatus()) + "\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        this.taskMapper.deleteByPrimaryKey(Integer.valueOf(taskId));
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo preview(Integer taskId, String account) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            BaseJsonVo<ActiveDTO> result;
            UserMessageVo userMessageVo = new UserMessageVo();
            BeanUtils.copyProperties((Object)task, (Object)userMessageVo);
            userMessageVo.setCustomerId(account);
            userMessageVo.setMobile(account);
            userMessageVo.setTaskId(task.getId());
            userMessageVo.setId(null);
            userMessageVo.setTemplateId(String.valueOf(task.getTemplateId()));
            if (account.length() == 11) {
                userMessageVo.setType(MessageTypeEnum.SMS.getValue());
            } else if (account.contains("@")) {
                userMessageVo.setType(MessageTypeEnum.EMAIL.getValue());
            } else if (account.length() >= 24) {
                result = this.customerInfoInvoke.getCustomerByOpenId(account);
                if (result.isSuccess()) {
                    userMessageVo.setCustomerId(((CustomerDetailDTO)result.getValue()).getCustomerId());
                    userMessageVo.setType(task.getMessageType());
                    userMessageVo.setOpenId(((CustomerDetailDTO)result.getValue()).getOpenId());
                }
            } else {
                userMessageVo.setType(task.getMessageType());
            }
            if (!StringUtils.isNotEmpty((String)task.getActiveNo())) return this.messageContext.pushMessage(userMessageVo, 1);
            result = this.activeInvoke.getActiveByActiveNo(task.getActiveNo());
            if (!result.isSuccess()) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u9884\u89c8\u5931\u8d25");
            ActiveDTO activeDTO = (ActiveDTO)result.getValue();
            if (!task.getActiveNo().equals(activeDTO.getActiveNo())) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u9884\u89c8\u5931\u8d25");
            if (activeDTO.getStatus() == 0) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u542f\u7528\uff0c\u9884\u89c8\u5931\u8d25");
            }
            if (activeDTO.getBeginTime().after(DateUtils.now())) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u5f00\u59cb\uff0c\u9884\u89c8\u5931\u8d25");
            }
            if (!activeDTO.getEndTime().before(DateUtils.now())) return this.messageContext.pushMessage(userMessageVo, 1);
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u9884\u89c8\u5931\u8d25");
        }
        this.logger.error("\u65e0\u6548\u7684\u4efb\u52a1:{}", (Object)taskId);
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4efb\u52a1");
    }

    @Override
    public BaseJsonVo pushOneMessage(Integer taskId, String account) {
        return this.preview(taskId, account);
    }

    @Override
    public BaseJsonVo saveTask(TaskEntity taskEntity, Integer platformId) {
        TaskEntity taskItem;
        TaskEntity temp;
        if (taskEntity.getId() == null || taskEntity.getId() == 0) {
            TaskEntity query = new TaskEntity();
            query.setTaskName(taskEntity.getTaskName());
            TaskEntity temp2 = (TaskEntity)this.taskMapper.getSingle(query);
            if (temp2 != null) {
                return BaseJsonVo.error((String)"\u540d\u79f0\u91cd\u590d,\u4fdd\u5b58\u5931\u8d25");
            }
            if (StringUtils.isNotEmpty((String)taskEntity.getActiveNo())) {
                query = new TaskEntity();
                query.setActiveNo(taskEntity.getActiveNo());
                temp2 = (TaskEntity)this.taskMapper.getSingle(query);
                if (temp2 != null) {
                    return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed1\u5b9a\u5176\u4ed6\u4efb\u52a1,\u8bf7\u6362\u4e00\u4e2a\u6d3b\u52a8\u518d\u8bd5,\u4fdd\u5b58\u5931\u8d25");
                }
            }
            taskEntity.setCreateTime(DateUtils.now());
            taskEntity.setTaskStatus(TaskStatusEnum.WAIT_DELIVERY.getValue());
            if (taskEntity.getPeriodType() > 0) {
                taskEntity.setNextTime(DateUtils.getAddDateByDay((Date)taskEntity.getExecTime(), (int)taskEntity.getPeriodType()));
            } else {
                taskEntity.setBeginTime(DateUtils.getAddDateBySecond((Date)taskEntity.getExecTime(), (int)-600));
                taskEntity.setEndTime(DateUtils.getAddDateBySecond((Date)taskEntity.getExecTime(), (int)600));
            }
            this.saveUserGroup(taskEntity, platformId);
            return this.taskMapper.insert(taskEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        TaskEntity query = new TaskEntity();
        if (StringUtils.isNotEmpty((String)taskEntity.getTaskName())) {
            query.setTaskName(taskEntity.getTaskName());
            temp = (TaskEntity)this.taskMapper.getSingle(query);
            if (temp != null && temp.getId().intValue() != taskEntity.getId().intValue()) {
                return BaseJsonVo.error((String)"\u540d\u79f0\u91cd\u590d,\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if (StringUtils.isNotEmpty((String)taskEntity.getActiveNo())) {
            query = new TaskEntity();
            query.setActiveNo(taskEntity.getActiveNo());
            temp = (TaskEntity)this.taskMapper.getSingle(query);
            if (temp != null && temp.getId().intValue() != taskEntity.getId().intValue()) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed1\u5b9a\u5176\u4ed6\u4efb\u52a1,\u8bf7\u6362\u4e00\u4e2a\u6d3b\u52a8\u518d\u8bd5,\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if ((taskItem = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskEntity.getId())).getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            return BaseJsonVo.error((String)("\u4efb\u52a1" + TaskStatusEnum.getName(taskItem.getTaskStatus()) + "\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        if (taskEntity.getPeriodType() > 0) {
            taskEntity.setNextTime(DateUtils.getAddDateByDay((Date)taskEntity.getExecTime(), (int)taskEntity.getPeriodType()));
        } else {
            taskEntity.setBeginTime(DateUtils.getAddDateBySecond((Date)taskEntity.getExecTime(), (int)-600));
            taskEntity.setEndTime(DateUtils.getAddDateBySecond((Date)taskEntity.getExecTime(), (int)600));
        }
        taskEntity.setTaskStatus(TaskStatusEnum.WAIT_DELIVERY.getValue());
        if (taskEntity.getPeriodType() > 0) {
            taskEntity.setNextTime(DateUtils.getAddDateByDay((Date)taskEntity.getExecTime(), (int)taskEntity.getPeriodType()));
        }
        this.saveUserGroup(taskEntity, platformId);
        this.taskMapper.updateByPrimaryKeySelective(taskEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    @Override
    @Transactional
    public BaseJsonVo saveWholeTask(Integer taskId, String taskName, String taskDesc, String activeNo, String taskPushType, String taskType, String theSql, String channelTemplateNo, String shortLink, String smsContent, String wxAction, String chanId, String firstExecTime, Integer execPeriod, String firstFetchUserTime, Integer fetchUserPeriod) {
        TagRuleEntity tagRuleEntity;
        List list;
        UserGroupEntity userGroupEntity;
        TaskEntity taskEntity = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (taskEntity == null) {
            taskEntity = new TaskEntity();
        }
        if (taskEntity.getGroupId() != null) {
            userGroupEntity = this.userGroupInterface.getGroup(taskEntity.getGroupId());
            TagRuleEntity tagRuleParam = new TagRuleEntity();
            tagRuleParam.setGroupId(taskEntity.getGroupId());
            list = this.tagRuleMapper.getList(tagRuleParam);
            tagRuleEntity = list.size() == 1 ? (TagRuleEntity)list.get(0) : new TagRuleEntity();
        } else {
            userGroupEntity = new UserGroupEntity();
            tagRuleEntity = new TagRuleEntity();
        }
        if (TaskPushTypeEnum.REGULAR.getValue().equals(taskPushType) || TaskPushTypeEnum.MANUAL.getValue().equals(taskPushType)) {
            userGroupEntity.setUserGroupName(taskName);
            userGroupEntity.setGroupDesc(taskDesc);
            userGroupEntity.setStatus(0);
            userGroupEntity.setGroupType(3);
            userGroupEntity.setCreateTime(DateUtils.now());
            userGroupEntity.setPlatformId(PlatFormEnum.LECHUN_MINI.getValue());
            BaseJsonVo userGroupRst = this.userGroupInterface.saveGroup(userGroupEntity);
            if (!userGroupRst.isSuccess()) {
                return userGroupRst;
            }
            if (StringUtils.isNotEmpty((String)theSql)) {
                tagRuleEntity.setTagId(0);
                tagRuleEntity.setTagName(taskName);
                tagRuleEntity.setStatus(1);
                tagRuleEntity.setCreateTime(DateUtils.now());
                tagRuleEntity.setGroupId(userGroupEntity.getId());
                tagRuleEntity.setResultSql(theSql);
                tagRuleEntity.setExecStatus(3);
                if (tagRuleEntity.getId() == null) {
                    this.tagRuleMapper.insert(tagRuleEntity);
                } else {
                    this.tagRuleMapper.updateByPrimaryKeySelective(tagRuleEntity);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)wxAction)) {
            taskEntity.setActionId(wxAction);
        } else if (StringUtils.isNotEmpty((String)smsContent)) {
            TemplateEntity templateEntity = taskEntity.getTemplateId() != null ? this.templateService.getTemplateEntity(taskEntity.getTemplateId()) : new TemplateEntity();
            if (StringUtils.isNotEmpty((String)channelTemplateNo)) {
                templateEntity.setChannelTemplateNo(channelTemplateNo);
            }
            templateEntity.setName(taskName);
            templateEntity.setType(1);
            templateEntity.setTemplate(smsContent);
            templateEntity.setChanId(chanId);
            templateEntity.setAppId(1);
            templateEntity.setCreateDate(DateUtils.currentDate());
            this.templateService.saveTemplate(templateEntity);
            taskEntity.setTemplateId(templateEntity.getId().intValue());
        }
        taskEntity.setTaskName(taskName);
        taskEntity.setTaskDesc(taskDesc);
        taskEntity.setTaskPushType(taskPushType);
        taskEntity.setBeginTime(DateUtils.now());
        taskEntity.setEndTime(DateUtils.getDateFromString((String)"2099-01-01 00:00:00"));
        taskEntity.setCreateTime(DateUtils.now());
        taskEntity.setActiveNo(activeNo);
        taskEntity.setTaskStatus(0);
        taskEntity.setGroupId(userGroupEntity.getId());
        taskEntity.setExecTime(DateUtils.getDateFromString((String)firstExecTime));
        taskEntity.setNextTime(taskEntity.getNextTime());
        taskEntity.setExecPeriod(execPeriod);
        taskEntity.setMessageType(StringUtils.isNotEmpty((String)wxAction) ? 5 : (StringUtils.isNotEmpty((String)smsContent) ? 1 : 0));
        taskEntity.setTaskType(Integer.valueOf(taskType));
        taskEntity.setFetchTime(DateUtils.getDateFromString((String)firstFetchUserTime));
        taskEntity.setNextFetchTime(taskEntity.getFetchTime());
        taskEntity.setFetchPeriod(fetchUserPeriod);
        if (taskEntity.getId() == null) {
            this.taskMapper.insert(taskEntity);
        } else {
            this.taskMapper.updateByPrimaryKeySelective(taskEntity);
        }
        if (taskEntity.getId() != null) {
            TaskContentEntity taskContentParam = new TaskContentEntity();
            taskContentParam.setTaskId(taskId);
            list = this.taskContentMapper.getList(taskContentParam);
            list.forEach(l -> this.taskContentMapper.deleteByPrimaryKey(l.getId()));
            TaskContentSMSEntity taskContentSMSParam = new TaskContentSMSEntity();
            taskContentSMSParam.setTaskId(taskId);
            List list2 = this.taskContentSMSMapper.getList(taskContentSMSParam);
            list2.forEach(l -> this.taskContentSMSMapper.deleteByPrimaryKey(l.getId()));
            TaskContentWxActionEntity taskContentWxActionParam = new TaskContentWxActionEntity();
            taskContentWxActionParam.setTaskId(taskId);
            List list3 = this.taskContentWxActionMapper.getList(taskContentWxActionParam);
            list3.forEach(l -> this.taskContentWxActionMapper.deleteByPrimaryKey(l.getId()));
        }
        TaskContentEntity taskContentEntity = new TaskContentEntity();
        taskContentEntity.setTaskId(taskEntity.getId());
        taskContentEntity.setContentType(1);
        taskContentEntity.setContentStatus(1);
        taskContentEntity.setDelaySecond(0);
        taskContentEntity.setCreateTime(DateUtils.now());
        this.taskContentMapper.insert(taskContentEntity);
        if (StringUtils.isNotEmpty((String)smsContent)) {
            TaskContentSMSEntity taskContentSMSEntity = new TaskContentSMSEntity();
            taskContentSMSEntity.setContentId(taskContentEntity.getId());
            taskContentSMSEntity.setTaskId(taskEntity.getId());
            taskContentSMSEntity.setMessageType("SMS");
            taskContentSMSEntity.setContent(smsContent);
            taskContentSMSEntity.setChanId(chanId);
            taskContentSMSEntity.setContentDetailStatus(1);
            taskContentSMSEntity.setCreateTime(DateUtils.now());
            this.taskContentSMSMapper.insert(taskContentSMSEntity);
        }
        if (StringUtils.isNotEmpty((String)wxAction)) {
            TaskContentWxActionEntity taskContentWxActionEntity = new TaskContentWxActionEntity();
            taskContentWxActionEntity.setContentId(taskContentEntity.getId());
            taskContentWxActionEntity.setTaskId(taskEntity.getId());
            taskContentWxActionEntity.setMessageType("MALL_ACTION");
            taskContentWxActionEntity.setContent(wxAction);
            taskContentWxActionEntity.setContentDetailStatus(1);
            taskContentWxActionEntity.setCreateTime(DateUtils.now());
            this.taskContentWxActionMapper.insert(taskContentWxActionEntity);
        }
        return BaseJsonVo.success(null);
    }

    private void saveUserGroup(TaskEntity taskEntity, Integer platformId) {
        if (taskEntity.getMessageType().intValue() == MessageTypeEnum.WECHAT_CUSTOMER_MESSAGE.getValue() || taskEntity.getMessageType().intValue() == MessageTypeEnum.WECHAT_TEMPLATES_MESSAGE.getValue()) {
            UserGroupEntity userGroupEntity = new UserGroupEntity();
            userGroupEntity.setId(taskEntity.getGroupId());
            userGroupEntity.setPlatformId(platformId);
            this.userGroupInterface.saveGroup(userGroupEntity);
        }
    }

    public PageInfo<TaskVo> getTaskList(TaskQueryVo taskQueryVo) {
        Page page = PageHelper.startPage((int)taskQueryVo.getCurrentPage(), (int)taskQueryVo.getPageSize());
        page.setOrderBy("ID desc");
        TaskEntity query = new TaskEntity();
        query.setBeginTime(DateUtils.getDateFromString((String)taskQueryVo.getBeginTime(), (String)"yyyy-MM-dd"));
        query.setEndTime(DateUtils.getDateFromString((String)taskQueryVo.getEndTime(), (String)"yyyy-MM-dd"));
        query.setTaskName(taskQueryVo.getTaskName());
        List<TaskEntity> list = this.taskMapper.getTaskList(query);
        ArrayList<TaskVo> taskVos = new ArrayList<TaskVo>();
        for (TaskEntity task : list) {
            TaskVo taskVo = new TaskVo();
            BeanUtils.copyProperties((Object)task, (Object)taskVo);
            taskVo.setActiveName("");
            if (task.getMessageType().intValue() == MessageTypeEnum.SMS.getValue()) {
                TemplateEntity templateEntity = this.templateService.getTemplateEntity(task.getTemplateId());
                taskVo.setContent(templateEntity == null ? "" : templateEntity.getTemplate());
            } else if (task.getMessageType().intValue() == MessageTypeEnum.WECHAT_CUSTOMER_MESSAGE.getValue()) {
                if (task.getTemplateId() != null) {
                    try {
                        BaseJsonVo tempResult = this.keyworldInvoke.getKeyworldContent(task.getTemplateId());
                        taskVo.setContent(tempResult.isSuccess() ? tempResult.getValue().toString() : "");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (task.getMessageType().intValue() == MessageTypeEnum.WECHAT_TEMPLATES_MESSAGE.getValue()) {
                taskVo.setContent("\u6a21\u677f\u6d88\u606f\u5185\u5bb9\u8bf7\u53bb\u6a21\u677f\u4e2d\u67e5\u770b");
            }
            UserGroupEntity groupEntity = this.userGroupInterface.getGroup(task.getGroupId());
            if (groupEntity != null) {
                taskVo.setGroupName(groupEntity == null ? "" : groupEntity.getUserGroupName());
                taskVo.setPlatformId(groupEntity.getPlatformId() == null ? 1 : groupEntity.getPlatformId());
            }
            taskVo.setMessageTypeName(MessageTypeEnum.getName(task.getMessageType()));
            taskVo.setPeriodTypeName(task.getPeriodType() == null ? PeriodTypeEnum.EVERY_DAY.getName() : PeriodTypeEnum.getName(task.getPeriodType()));
            taskVo.setTaskStatusName(TaskStatusEnum.getName(task.getTaskStatus()));
            if (StringUtils.isNotEmpty((String)taskVo.getActiveNo())) {
                try {
                    BaseJsonVo<ActiveDTO> baseJsonVo = this.activeInvoke.getActiveByActiveNo(taskVo.getActiveNo());
                    taskVo.setActiveName(baseJsonVo.isSuccess() ? ((ActiveDTO)baseJsonVo.getValue()).getActiveName() : "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            taskVos.add(taskVo);
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(taskVos);
        return pg;
    }

    @Override
    public void pullUserToRedis() {
        TaskEntity task = new TaskEntity();
        task.setTaskStatus(TaskStatusEnum.SENDING.getValue());
        task.setBeginTime(DateUtils.now());
        task.setEndTime(DateUtils.now());
        List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
        if (list != null && list.size() > 0) {
            list.forEach(taskItem -> {
                this.logger.info("\u5df2\u5ba1\u6838\u7684\u4efb\u52a1\u8bb0\u5f55:{}", (Object)taskItem.toString());
                UserGroupEntity groupEntity = this.userGroupInterface.getGroup(taskItem.getGroupId());
                this.logger.info("\u5468\u671f\u6267\u884c\u4efb\u52a1\u8bbe\u7f6e\u4f18\u60e0\u5238\u6b21\u6570\u589e\u52a0\u5f00\u59cb:{}", (Object)taskItem.toString());
                this.setSendCashNum((TaskEntity)taskItem, groupEntity);
                this.logger.info("\u5f00\u59cb\u7528\u6237\u5199\u5165redis:{}", (Object)taskItem.toString());
                this.pullUserToRedis((TaskEntity)taskItem);
            });
        }
    }

    @Override
    public void setTaskSending() {
        TaskEntity task = new TaskEntity();
        task.setTaskStatus(TaskStatusEnum.APPROVE.getValue());
        task.setBeginTime(DateUtils.now());
        task.setEndTime(DateUtils.now());
        List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
        if (list != null && list.size() > 0) {
            list.forEach(taskItem -> {
                this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4efb\u52a1\u53d1\u9001\u4e2d:{}", (Object)task.toString());
                this.setTaskSending(task.getId());
                this.logger.info("\u8bbe\u7f6e\u4efb\u52a1{}\u53d1\u9001\u4e2d\u5b8c\u6210", (Object)task.toString());
            });
        }
    }

    private void setSendCashNum(TaskEntity task, UserGroupEntity groupEntity) {
        try {
            if (StringUtils.isNotEmpty((String)task.getActiveNo())) {
                if (groupEntity == null) {
                    this.logger.error("\u65e0\u6548\u7684\u7528\u6237{}", (Object)task.toString());
                    return;
                }
                if (groupEntity.getGroupType().intValue() == GroupTypeEnum.TEMPLATE.getValue() && groupEntity.getSendNum() != null && groupEntity.getSendNum() > 0) {
                    BaseJsonVo baseJsonVo = this.activeInvoke.setCashSendNum(task.getActiveNo(), groupEntity.getSendNum());
                    this.logger.info("\u8bbe\u7f6e\u4f18\u60e0\u5238\u63a8\u9001\u6b21\u6570:{}", (Object)baseJsonVo.isSuccess());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTaskSending(Integer taskId) {
        TaskEntity update = new TaskEntity();
        update.setId(taskId);
        update.setTaskStatus(TaskStatusEnum.SENDING.getValue());
        this.taskMapper.updateByPrimaryKeySelective(update);
        this.logger.info("\u5df2\u8bbe\u7f6e\u4efb\u52a1{}\u53d1\u9001\u4e2d", (Object)taskId);
    }

    @Override
    public void pullUserToRedis(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            this.logger.info("1:{}", (Object)task.getBeginTime().before(DateUtils.now()));
            this.logger.info("2:{}", (Object)task.getEndTime().after(DateUtils.now()));
            this.logger.info("3:{}", (Object)(task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue() ? 1 : 0));
            this.logger.info("4:{}", (Object)(task.getBeginTime().before(DateUtils.now()) && task.getEndTime().after(DateUtils.now()) && task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue() ? 1 : 0));
            if (task.getBeginTime().before(DateUtils.now()) && task.getEndTime().after(DateUtils.now()) && (task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue() || task.getTaskStatus().intValue() == TaskStatusEnum.WAIT_FETCH.getValue())) {
                this.setTaskSending(task.getId());
                task.setTaskStatus(TaskStatusEnum.SENDING.getValue());
                this.pullUserToRedis(task);
            } else {
                this.logger.info("\u4e0d\u7b26\u5408\u63a8\u9001\u6761\u4ef6:{}", (Object)task.toString());
            }
        } else {
            this.logger.error("\u65e0\u6548\u7684\u4efb\u52a1:{}", (Object)taskId);
        }
    }

    @Override
    public void pullUserToRedis(TaskEntity task) {
        this.logger.info("\u5c06\u4efb\u52a1\u5173\u8054\u7528\u6237\u63a8\u9001\u5230redis\u4e2d....{}", (Object)task.toString());
        if (task.getBeginTime().before(DateUtils.now()) && task.getEndTime().after(DateUtils.now()) && task.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            try {
                List<MessageLimitEntity> list = this.messageLimitInterface.getMessageLimitList();
                Optional<MessageLimitEntity> messageLimit = list.stream().filter(messageLimitEntity -> messageLimitEntity.getLimitType().intValue() == task.getMessageType().intValue() && task.getTaskType().intValue() == messageLimitEntity.getTaskType().intValue()).findFirst();
                this.logger.info("\u73af\u5883:{}", (Object)this.environment);
                int pageSize = 2000;
                for (int i = 0; i < 25; ++i) {
                    GroupDetailQuery groupDetailQuery = new GroupDetailQuery();
                    groupDetailQuery.setCurrentPage(1);
                    groupDetailQuery.setPageSize(pageSize);
                    groupDetailQuery.setGroupId(task.getGroupId());
                    groupDetailQuery.setPushStatus(GroupDetailPushStatusEnum.UNPUSH_REDIS.getValue());
                    if (task.getId() == 112) {
                        groupDetailQuery.setPushStatus(GroupDetailPushStatusEnum.PUSHED_REDIS.getValue());
                    }
                    List userList = this.userService.getUserByGroupId(groupDetailQuery).getList();
                    userList.forEach(userItem -> {
                        if (task.getId() == 112) {
                            this.userService.savePushStatus(userItem.getId(), GroupDetailPushStatusEnum.SMS_AI_CALL_PUSHED_REDIS.getValue());
                        } else {
                            this.userService.savePushStatus(userItem.getId(), GroupDetailPushStatusEnum.PUSHED_REDIS.getValue());
                        }
                        String account = "";
                        if (task.getMessageType().intValue() == MessageTypeEnum.SMS.getValue() || task.getMessageType().intValue() == MessageTypeEnum.AI_CALL.getValue()) {
                            account = userItem.getMobile();
                        } else if (task.getMessageType().intValue() == MessageTypeEnum.WECHAT_TEMPLATES_MESSAGE.getValue() || task.getMessageType().intValue() == MessageTypeEnum.WECHAT_CUSTOMER_MESSAGE.getValue() || task.getMessageType().intValue() == MessageTypeEnum.MALL_ACTION.getValue()) {
                            account = userItem.getCustomerId();
                        }
                        if (StringUtils.isEmpty((String)account)) {
                            this.logger.info("\u8bb0\u5f55{}\u5e10\u53f7\u4e3a\u7a7a\u4e0d\u63a8\u9001", (Object)userItem.toString());
                            return;
                        }
                        boolean messageLimitEnable = true;
                        if (!messageLimit.isPresent()) {
                            messageLimitEnable = false;
                        }
                        this.logger.info("\u4efb\u52a1\u662f\u5426\u63a8\u9001\u9650\u5236[{}]:{}", (Object)messageLimitEnable, (Object)JsonUtils.toJson((Object)messageLimit, (boolean)false));
                        if (userItem != null && StringUtils.isNotEmpty((String)userItem.getMobile())) {
                            BaseJsonVo<String> filter = this.mallCashInvoke.filter(1, userItem.getMobile(), null, null, null);
                            this.logger.info("\u5224\u65ad\u9ed1\u540d\u5355[{}][{}]", (Object)userItem.getMobile(), (Object)JsonUtils.toJson(filter, (boolean)false));
                            if (!filter.isSuccess()) {
                                return;
                            }
                        }
                        this.logger.info("\u4e0d\u662f\u9ed1\u540d\u5355");
                        if (this.redisService.sadd("MESSAGE_REDIS_KEY:" + task.getId().toString(), userItem)) {
                            if (messageLimitEnable) {
                                String key = account + ":NUM:" + task.getTaskType() + ":" + task.getMessageType();
                                this.logger.info("\u6d88\u606f\u9650\u5236key:{}", (Object)key);
                                long num = this.redisService.increment(key, 1L);
                                if (num == 1L) {
                                    this.redisService.setExpire(key, ((MessageLimitEntity)messageLimit.get()).getLimitTime().intValue(), TimeUnit.MINUTES);
                                    this.logger.info("\u8bbe\u7f6e\u8fc7\u671f\u7f13\u5b58{}\u8fc7\u671f\u65f6\u95f4:{}", (Object)(account + ":NUM"), (Object)((MessageLimitEntity)messageLimit.get()).getLimitTime());
                                }
                                this.logger.info("\u5e10\u53f7{}\u5df2\u63a8\u9001\u6b21\u6570:{}", (Object)account, (Object)num);
                                if (num > (long)((MessageLimitEntity)messageLimit.get()).getLimitNum().intValue()) {
                                    this.logger.info("\u5e10\u53f7\u5df2\u63a8\u9001:{}\u6b21\uff0c\u9650\u5236\u6b21\u6570:{}", (Object)num, (Object)((MessageLimitEntity)messageLimit.get()).getLimitNum());
                                    return;
                                }
                            }
                            this.redisService.sadd("UNSEND_MESSAGE_REDIS_KEY:" + task.getId().toString(), userItem);
                            this.logger.info("\u4efb\u52a1:{}\u7528\u6237\u5e10\u53f7:{},\u5df2\u88ab\u6dfb\u52a0", (Object)task.getId(), userItem);
                        } else {
                            this.logger.info("\u4efb\u52a1:{}\u7528\u6237\u5e10\u53f7:{},\u5df2\u88ab\u6dfb\u52a0,\u4e0d\u91cd\u590d\u6dfb\u52a0", (Object)task.getId(), (Object)userItem.toString());
                        }
                    });
                    if (userList != null && userList.size() >= pageSize) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setTaskFinish(TaskEntity task) {
        TaskEntity update = new TaskEntity();
        this.logger.info("setTaskFinish.task:{}", (Object)JsonUtils.toJson((Object)task, (boolean)false));
        if ("REGULAR".equals(task.getTaskPushType()) && task.getPeriodType() == null) {
            update.setTaskStatus(TaskStatusEnum.WAIT_FETCH.getValue());
        } else {
            update.setTaskStatus(TaskStatusEnum.FINISH.getValue());
        }
        update.setId(task.getId());
        if (task.getPeriodType() == null) {
            TagRuleEntity param = new TagRuleEntity();
            param.setGroupId(task.getGroupId());
            List list = this.tagRuleMapper.getList(param);
            list.forEach(tagRuleEntity -> {
                tagRuleEntity.setExecStatus(0);
                if (task.getId() == 112) {
                    tagRuleEntity.setExecStatus(3);
                }
                this.tagRuleMapper.updateByPrimaryKeySelective(tagRuleEntity);
            });
        }
        if (this.taskMapper.updateByPrimaryKeySelective(update) > 0) {
            this.logger.info("\u4efb\u52a1:{},{},\u6d88\u606f\u63a8\u9001\u5b8c\u6210...", (Object)task.getTaskName(), (Object)task.getId());
        }
    }

    private void setUserGroupStatus(TaskEntity task) {
        this.logger.info("\u4efb\u52a1{}\u53d1\u9001\u5b8c\u6210\u8bbe\u7f6e\u7528\u6237\u7ec4\u672a\u66f4\u65b0", (Object)task);
        this.userGroupInterface.updateStatus(task.getGroupId(), 0, null);
    }

    @Override
    public void pullUserToMq() {
        Integer perSize = 100;
        TaskEntity task = new TaskEntity();
        task.setTaskStatus(TaskStatusEnum.SENDING.getValue());
        List<TaskEntity> list = this.taskMapper.getEnableTaskList(task);
        if (list != null && list.size() > 0) {
            TaskEntity taskItem = list.get(0);
            this.pullUserToMq(taskItem, perSize);
        }
    }

    @Override
    public void pullUserToMq(Integer taskId) {
        Integer perSize = 100;
        TaskEntity taskItem = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        this.pullUserToMq(taskItem, perSize);
    }

    @Override
    public void pullUserToMq(TaskEntity taskItem, Integer perSize) {
        if (taskItem.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            Integer popNumPage = 250;
            for (int i = 0; i < popNumPage; ++i) {
                ArrayList<UserMessageVo> messageList = new ArrayList<UserMessageVo>();
                for (int j = 0; j < perSize; ++j) {
                    GroupDetailEntity user = (GroupDetailEntity)this.redisService.spop("UNSEND_MESSAGE_REDIS_KEY:" + taskItem.getId().toString());
                    if (user == null) {
                        i = popNumPage;
                        this.setTaskFinish(taskItem);
                        this.setUserGroupStatus(taskItem);
                        break;
                    }
                    UserMessageVo messageVo = new UserMessageVo();
                    BeanUtils.copyProperties((Object)user, (Object)messageVo);
                    messageVo.setTaskId(taskItem.getId());
                    messageVo.setType(taskItem.getMessageType());
                    messageVo.setActiveNo(taskItem.getActiveNo());
                    messageVo.setTemplateId(taskItem.getTemplateId().toString());
                    UserGroupEntity userGroupEntity = this.userGroupInterface.getGroup(user.getGroupId());
                    messageVo.setGroupType(userGroupEntity != null ? userGroupEntity.getGroupType() : 0);
                    messageVo.setPlatformId(userGroupEntity.getPlatformId());
                    messageList.add(messageVo);
                }
                this.logger.info("\u8981\u63a8\u9001\u6d88\u606f\u4e86[" + i + "]\uff1a" + JsonUtils.toJson(messageList, (boolean)false));
                if (messageList.size() <= 0) continue;
                this.pushNoticeMQ("AllSubscribes", "all", messageList, i, 1);
            }
        }
    }

    private void pushNoticeMQ(String customerType, String action, List<UserMessageVo> taskList, int pageNum, Integer platformId) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("action", action);
        messageMap.put("list", taskList);
        messageMap.put("platformId", platformId);
        this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6d88\u606f\uff1a" + JsonUtils.toJson(messageMap, (boolean)true));
        MessageResult mr = this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.templeteMessageSend, new MessageParam(String.valueOf(IDGenerate.getUniqueIdStr()), messageMap));
        this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c\uff1a" + mr.isStatus() + "  " + mr.getMsg().toString());
    }

    private BaseJsonVo pushToDelayedMQ(String actionId, List<UserMessageVo> taskList, Integer delaySecond, Integer platformId) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("action", actionId);
        ArrayList users = new ArrayList();
        taskList.forEach(user -> {
            Map stringObjectMap = ObjectConvert.beanToMap((Object)user);
            HashMap stringMap = new HashMap();
            stringObjectMap.keySet().forEach(key -> stringMap.put(key, stringObjectMap.get(key) == null ? "" : stringObjectMap.get(key).toString()));
            users.add(stringMap);
        });
        messageMap.put("list", users);
        messageMap.put("platformId", platformId);
        this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6d88\u606f\uff0c\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JsonUtils.toJson(messageMap, (boolean)true));
        MessageResult mr = this.messageQueueService.sendTaskMessage(MessageQueueTagEnum.pushTaskAction, new MessageParam(null, messageMap), (long)delaySecond.intValue());
        this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c[{}]\uff1a{}", (Object)mr.isStatus(), (Object)JsonUtils.toJson((Object)mr, (boolean)false));
        return mr.isStatus() ? BaseJsonVo.success((Object)mr.getSendResult().getMessageId()) : BaseJsonVo.error((String)"\u63a8\u9001\u6d88\u606f\u961f\u5217\u5f02\u5e38");
    }

    @Override
    public TaskEntity getTaskEntityById(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task == null) {
            return new TaskEntity();
        }
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo approveTask(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task == null) return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4efb\u52a1");
        UserGroupEntity userGroupEntity = this.userGroupInterface.getGroup(task.getGroupId());
        if (userGroupEntity == null || userGroupEntity.getId() == 0) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u7528\u6237\u7ec4\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25");
        }
        if (StringUtils.isNotEmpty((String)task.getActiveNo())) {
            BaseJsonVo<ActiveDTO> result = this.activeInvoke.getActiveByActiveNo(task.getActiveNo());
            if (!result.isSuccess()) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25");
            ActiveDTO activeDTO = (ActiveDTO)result.getValue();
            if (!task.getActiveNo().equals(activeDTO.getActiveNo())) return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25");
            if (activeDTO.getStatus() == 0) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u542f\u7528\uff0c\u5ba1\u6838\u5931\u8d25");
            }
            if (activeDTO.getBeginTime().after(DateUtils.now())) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u672a\u5f00\u59cb\uff0c\u5ba1\u6838\u5931\u8d25");
            }
            if (activeDTO.getEndTime().before(DateUtils.now())) {
                return BaseJsonVo.error((String)"\u4efb\u52a1\u5173\u8054\u7684\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u5ba1\u6838\u5931\u8d25");
            }
        }
        if (task.getTaskStatus().intValue() != TaskStatusEnum.WAIT_DELIVERY.getValue()) return BaseJsonVo.error((String)"\u4efb\u52a1\u5df2\u5ba1\u6838\u8fc7");
        TaskEntity update = new TaskEntity();
        update.setId(taskId);
        update.setTaskStatus(TaskStatusEnum.APPROVE.getValue());
        this.taskMapper.updateByPrimaryKeySelective(update);
        return BaseJsonVo.success((Object)"\u5ba1\u6838\u6210\u529f");
    }

    @Override
    public BaseJsonVo cancelTask(Integer taskId) {
        TaskEntity task = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (task != null) {
            if (task.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue() || task.getTaskStatus().intValue() == TaskStatusEnum.APPROVE.getValue()) {
                TaskEntity update = new TaskEntity();
                update.setId(taskId);
                update.setTaskStatus(TaskStatusEnum.WAIT_DELIVERY.getValue());
                this.taskMapper.updateByPrimaryKeySelective(update);
                return BaseJsonVo.success((Object)"\u64a4\u9500\u6210\u529f");
            }
            return BaseJsonVo.error((String)("\u4efb\u52a1" + TaskStatusEnum.getName(task.getTaskStatus()) + ",\u65e0\u6cd5\u64a4\u9500"));
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4efb\u52a1");
    }

    @Override
    @Transactional
    public BaseJsonVo pushDirect(Integer taskId, String customerId, String openId, String mobile, Integer delaySecond, Integer platformId) {
        TaskEntity taskEntity = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        if (!TaskPushTypeEnum.MALL_TRIGGER.getValue().equals(taskEntity.getTaskPushType())) {
            return BaseJsonVo.error((String)"\u8be5\u4efb\u52a1\u4e0d\u662f\u52a8\u4f5c\u7c7b\uff0c\u4e0d\u80fd\u76f4\u63a5\u89e6\u53d1");
        }
        final UserMessageVo messageVo = new UserMessageVo();
        messageVo.setTaskId(taskId);
        messageVo.setCustomerId(customerId);
        messageVo.setOpenId(openId);
        messageVo.setMobile(mobile);
        messageVo.setType(taskEntity.getMessageType());
        TaskPushRecordEntity currentPushRecord = this.taskPushRecordInterface.getCurrentRecord(taskId);
        if (currentPushRecord == null) {
            currentPushRecord = new TaskPushRecordEntity();
            currentPushRecord.setTaskId(taskId);
            currentPushRecord.setRecordName(DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"));
            currentPushRecord.setCreateTime(DateUtils.now());
            this.taskPushRecordInterface.save(currentPushRecord);
        }
        TaskPushLogEntity log = new TaskPushLogEntity();
        log.setCustomerId(customerId);
        log.setOpenId(openId);
        log.setMobile(mobile);
        log.setTaskId(taskId);
        log.setTaskRecordId(currentPushRecord.getId());
        log.setPushContentType(String.valueOf(taskEntity.getMessageType()));
        log.setActionId(taskEntity.getActionId());
        log.setCreateTime(DateUtils.now());
        BaseJsonVo saveLogRst = this.taskPushLogInterface.savePushLog(log);
        messageVo.setTaskPushLogId(log.getId());
        BaseJsonVo pushMQRst = this.pushToDelayedMQ(taskEntity.getActionId(), (List<UserMessageVo>)new ArrayList<UserMessageVo>(){
            {
                this.add(messageVo);
            }
        }, delaySecond, platformId);
        if (!pushMQRst.isSuccess()) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u63a8\u9001\u5230\u6d88\u606f\u961f\u5217\u5931\u8d25");
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo pushTask(Integer taskId) {
        TaskEntity taskEntity = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        TaskPushRecordEntity currentPushRecord = this.taskPushRecordInterface.getCurrentRecord(taskId);
        this.logger.info("111111111:{}", (Object)JsonUtils.toJson((Object)taskEntity, (boolean)false));
        if (currentPushRecord == null) {
            currentPushRecord = new TaskPushRecordEntity();
            currentPushRecord.setTaskId(taskId);
            currentPushRecord.setRecordName(DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"));
            currentPushRecord.setCreateTime(DateUtils.now());
            this.taskPushRecordInterface.save(currentPushRecord);
        }
        this.logger.info("22222222:{}", (Object)JsonUtils.toJson((Object)currentPushRecord, (boolean)false));
        if (taskEntity.getTaskStatus().intValue() == TaskStatusEnum.SENDING.getValue()) {
            Integer popNumPage = 250;
            Integer perSize = 100;
            Boolean noMore = false;
            for (int i = 0; i < popNumPage && !noMore.booleanValue(); ++i) {
                ArrayList<UserMessageVo> messageList = new ArrayList<UserMessageVo>();
                ArrayList<TaskPushLogEntity> logList = new ArrayList<TaskPushLogEntity>();
                for (int j = 0; j < perSize; ++j) {
                    GroupDetailEntity user = (GroupDetailEntity)this.redisService.spop("MESSAGE_REDIS_KEY:" + taskEntity.getId().toString());
                    this.logger.info("\u7b2c[{}]\u9875\u7b2c[{}]\u884c\u83b7\u53d6\u7684user:{}", new Object[]{i, j, JsonUtils.toJson((Object)user, (boolean)false)});
                    if (user != null) {
                        try {
                            UserMessageVo messageVo = new UserMessageVo();
                            BeanUtils.copyProperties((Object)user, (Object)messageVo);
                            messageVo.setTmallOaid(user.getTmallOrderOaid());
                            messageVo.setTmallOrderNo(user.getTmallOrderNo());
                            messageVo.setTaskId(taskEntity.getId());
                            messageVo.setType(taskEntity.getMessageType());
                            messageVo.setActiveNo(taskEntity.getActiveNo());
                            messageVo.setTemplateId(taskEntity.getTemplateId() == null ? null : taskEntity.getTemplateId().toString());
                            UserGroupEntity userGroupEntity = this.userGroupInterface.getGroup(user.getGroupId());
                            messageVo.setGroupType(userGroupEntity != null ? userGroupEntity.getGroupType() : 0);
                            messageVo.setPlatformId(userGroupEntity.getPlatformId());
                            TaskPushLogEntity log = new TaskPushLogEntity();
                            log.setCustomerId(messageVo.getCustomerId());
                            log.setOpenId(messageVo.getOpenId());
                            log.setMobile(messageVo.getMobile());
                            log.setTaskId(taskId);
                            log.setTaskRecordId(currentPushRecord.getId());
                            log.setPushContentType(String.valueOf(taskEntity.getMessageType()));
                            log.setActionId(taskEntity.getActionId());
                            log.setCreateTime(DateUtils.now());
                            logList.add(log);
                            BaseJsonVo saveLogRst = this.taskPushLogInterface.savePushLog(log);
                            messageVo.setTaskPushLogId(log.getId());
                            messageList.add(messageVo);
                            continue;
                        }
                        catch (Exception e) {
                            this.logger.error("\u53d1\u9001\u6d88\u606f\u65f6\u62a5\u9519", (Throwable)e);
                            throw e;
                        }
                    }
                    noMore = true;
                    i = popNumPage;
                    this.setTaskFinish(taskEntity);
                    this.setUserGroupStatus(taskEntity);
                    break;
                }
                this.logger.info("\u63a8\u9001\u4efb\u52a1[{}][\u7b2c{}\u9875]\uff1a{}", new Object[]{taskEntity.getTaskName(), i, JsonUtils.toJson(messageList, (boolean)false)});
                if (messageList.size() <= 0) continue;
                if (MessageTypeEnum.MALL_ACTION.getValue() == taskEntity.getMessageType().intValue()) {
                    BaseJsonVo j = this.pushToDelayedMQ(taskEntity.getActionId(), messageList, 0, 1);
                    continue;
                }
                if (MessageTypeEnum.SMS.getValue() == taskEntity.getMessageType().intValue()) {
                    messageList.forEach(userMessageVo -> {
                        if (userMessageVo != null && StringUtils.isNotEmpty((String)userMessageVo.getMobile())) {
                            BaseJsonVo<String> filter = this.mallCashInvoke.filter(1, userMessageVo.getMobile(), null, null, null);
                            this.logger.info("\u53d1\u9001\u524d\u5224\u65ad\u9ed1\u540d\u5355[{}][{}]", (Object)userMessageVo.getMobile(), (Object)JsonUtils.toJson(filter, (boolean)false));
                            if (!filter.isSuccess()) {
                                return;
                            }
                        }
                        this.logger.info("\u53d1\u9001\u524d\u5224\u65ad\u4e0d\u662f\u9ed1\u540d\u5355{}", (Object)userMessageVo.getMobile());
                        if (StringUtils.isNotEmpty((String)userMessageVo.getTmallOaid()) && StringUtils.isNotEmpty((String)userMessageVo.getTmallOrderNo())) {
                            PlatformDTO platformDTO = new PlatformDTO();
                            platformDTO.setStatus("Y");
                            BaseJsonVo<List<PlatformDTO>> platformInfoJson = this.csmsInvoke.listPlatformInfo(platformDTO);
                            this.logger.info("\u53d1\u9001\u5929\u732b\u8ba2\u5355D45\u77ed\u4fe1\uff0c\u67e5\u8be2\u5929\u732b\u5e73\u53f0\u7ed3\u679c\uff1a{}", (Object)JsonUtils.toJson(platformInfoJson, (boolean)false));
                            List platformDTOList = (List)platformInfoJson.getValue();
                            if (platformDTOList != null && platformDTOList.size() > 0) {
                                for (PlatformDTO platformDTOParam : platformDTOList) {
                                    if (!StringUtil.isNotEmpty((String)platformDTOParam.getShopToken()) || !"16".equals(platformDTOParam.getShopCode())) continue;
                                    String signName = "[\"\u4e50\u7eaf\"]";
                                    TemplateEntity templateEntity = this.templateService.getTemplateEntity(Integer.valueOf(userMessageVo.getTemplateId()));
                                    String smsTemplateCode = "SMS_234406317";
                                    String orderIds = "[\"" + userMessageVo.getTmallOrderNo() + "\"]";
                                    String oaids = "[\"" + userMessageVo.getTmallOaid() + "\"]";
                                    String smsContent = "";
                                    String taskSign = RandomUtils.generateId();
                                    BaseJsonVo v = this.tmallInvoke.batchSend(signName, smsTemplateCode, orderIds, oaids, platformDTOParam.getShopSecret(), platformDTOParam.getShopToken(), platformDTOParam.getShopKey(), platformDTOParam.getShopId(), DateUtils.formatDate((Date)platformDTOParam.getLastUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), platformDTOParam.getPlatformName(), smsContent, taskSign);
                                    this.logger.info("\u53d1\u9001\u5929\u732b\u8ba2\u5355D45\u77ed\u4fe1\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)v, (boolean)false));
                                    TaskPushLogEntity log = new TaskPushLogEntity();
                                    log.setId(userMessageVo.getTaskPushLogId());
                                    log.setPushText(userMessageVo.getTmallOrderNo());
                                    log.setIsSuccess(v.isSuccess() ? 1 : 0);
                                    log.setErrMsg(v.getMessage());
                                    log.setPushThirdTime(DateUtils.now());
                                    this.logger.info("\u53d1\u9001\u5929\u732b\u8ba2\u5355D45\u77ed\u4fe1\uff0c\u4fdd\u5b58\u65e5\u5fd7:{}", (Object)JsonUtils.toJson((Object)log, (boolean)false));
                                    this.taskPushLogInterface.savePushLogSelect(log);
                                }
                            }
                        } else {
                            this.smsMessage.pushMessage((UserMessageVo)userMessageVo);
                        }
                    });
                    continue;
                }
                if (MessageTypeEnum.AI_CALL.getValue() != taskEntity.getMessageType().intValue()) continue;
                ArrayList<TaskContact> contacts = new ArrayList<TaskContact>();
                messageList.forEach(userMessageVo -> {
                    if (userMessageVo != null && StringUtils.isNotEmpty((String)userMessageVo.getMobile())) {
                        BaseJsonVo<String> filter = this.mallCashInvoke.filter(1, userMessageVo.getMobile(), null, null, null);
                        this.logger.info("\u6253\u7535\u8bdd\u524d\u524d\u5224\u65ad\u9ed1\u540d\u5355[{}][{}]", (Object)userMessageVo.getMobile(), (Object)JsonUtils.toJson(filter, (boolean)false));
                        if (!filter.isSuccess()) {
                            return;
                        }
                    }
                    this.logger.info("\u6253\u7535\u8bdd\u524d\u5224\u65ad\u4e0d\u662f\u9ed1\u540d\u5355{}", (Object)userMessageVo.getMobile());
                    if (StringUtils.isEmpty((String)userMessageVo.getTmallOaid()) && StringUtils.isEmpty((String)userMessageVo.getTmallOrderNo())) {
                        TaskContact contact = new TaskContact();
                        contact.setOutId(String.valueOf(userMessageVo.getTaskPushLogId()));
                        contact.setTelephone(userMessageVo.getMobile());
                        contact.setVariable(null);
                        contacts.add(contact);
                    }
                });
                if (contacts.size() <= 0) continue;
                this.logger.info("\u53d1\u9001AI\u7535\u8bdd\uff1a{}", (Object)JsonUtils.toJson(contacts, (boolean)false));
                this.iAiCallService.addMobileToTask(contacts);
            }
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo prepare45push() {
        this.taskMapper.prepare45push();
        return BaseJsonVo.success(null);
    }

    @Override
    public Map<String, Object> getWholeTask(Integer taskId) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        TaskEntity taskEntity = (TaskEntity)this.taskMapper.selectByPrimaryKey(taskId);
        rtnMap.put("taskName", taskEntity.getTaskName());
        rtnMap.put("taskDesc", taskEntity.getTaskDesc());
        rtnMap.put("taskPushType", taskEntity.getTaskPushType());
        rtnMap.put("taskType", taskEntity.getTaskType());
        TagRuleEntity param = new TagRuleEntity();
        param.setGroupId(taskEntity.getGroupId());
        List tagRuleList = this.tagRuleMapper.getList(param);
        if (tagRuleList.size() > 1) {
            return null;
        }
        if (tagRuleList.size() == 1) {
            rtnMap.put("theSql", ((TagRuleEntity)tagRuleList.get(0)).getResultSql());
        } else {
            rtnMap.put("theSql", null);
        }
        TaskContentEntity param2 = new TaskContentEntity();
        param2.setTaskId(taskId);
        List taskContentEntityList = this.taskContentMapper.getList(param2);
        if (taskContentEntityList == null || taskContentEntityList.size() == 0) {
            return null;
        }
        TaskContentSMSEntity param3 = new TaskContentSMSEntity();
        param3.setContentId(((TaskContentEntity)taskContentEntityList.get(0)).getId());
        List list = this.taskContentSMSMapper.getList(param3);
        if (list != null && list.size() > 0) {
            rtnMap.put("smsContent", ((TaskContentSMSEntity)list.get(0)).getContent());
            rtnMap.put("chanId", ((TaskContentSMSEntity)list.get(0)).getChanId());
        } else {
            rtnMap.put("smsContent", null);
            rtnMap.put("chanId", null);
        }
        TaskContentWxActionEntity param4 = new TaskContentWxActionEntity();
        param4.setContentId(((TaskContentEntity)taskContentEntityList.get(0)).getId());
        List list1 = this.taskContentWxActionMapper.getList(param4);
        if (list1 != null && list1.size() > 0) {
            rtnMap.put("wxAction", ((TaskContentWxActionEntity)list1.get(0)).getContent());
        } else {
            rtnMap.put("wxAction", null);
        }
        rtnMap.put("firstExecTime", DateUtils.formatDate((Date)taskEntity.getExecTime(), (String)""));
        rtnMap.put("execPeriod", taskEntity.getExecPeriod());
        rtnMap.put("firstFetchUserTime", DateUtils.formatDate((Date)taskEntity.getFetchTime(), (String)""));
        rtnMap.put("fetchUserPeriod", taskEntity.getFetchPeriod());
        return rtnMap;
    }

    @Override
    public BaseJsonVo trigger() {
        this.logger.info("trigger\u88ab\u8c03\u7528");
        List<TaskEntity> taskEntities = this.taskMapper.getUnFetchedTasks();
        this.logger.info("trigger\u88ab\u8c03\u7528\uff1a\u5f85\u66f4\u65b0\u7528\u6237\u5217\u8868\uff1a{}", (Object)JsonUtils.toJson(taskEntities, (boolean)false));
        taskEntities.forEach(task -> {
            if (DateUtils.now().compareTo(task.getNextFetchTime()) >= 0) {
                task.setFetchTime(DateUtils.now());
                task.setNextFetchTime(DateUtils.getAddDateBySecond((Date)task.getNextFetchTime(), (int)task.getFetchPeriod()));
                this.taskMapper.updateByPrimaryKeySelective(task);
                TagRuleEntity param = new TagRuleEntity();
                param.setGroupId(task.getGroupId());
                TagRuleEntity single = (TagRuleEntity)this.tagRuleMapper.getSingle(param);
                single.setExecStatus(3);
                this.tagRuleMapper.updateByPrimaryKeySelective(single);
            }
        });
        this.logger.info("trigger\u88ab\u8c03\u7528\uff1a2");
        List<TaskEntity> taskUnPushedTasks = this.taskMapper.getUnPushedTasks();
        this.logger.info("trigger\u88ab\u8c03\u7528\uff1a\u5f85\u63a8\u9001\u5217\u8868\uff1a{}", (Object)JsonUtils.toJson(taskUnPushedTasks, (boolean)false));
        taskUnPushedTasks.forEach(task -> {
            if (DateUtils.now().compareTo(task.getNextTime()) >= 0) {
                new Thread(() -> {
                    this.logger.info("trigger\u88ab\u8c03\u7528\uff1a\u8981\u63a8\u9001\u8fd9\u4e2a\u4efb\u52a1:{}", (Object)JsonUtils.toJson((Object)task, (boolean)false));
                    this.pullUserToRedis(task.getId());
                    this.logger.info("trigger\u88ab\u8c03\u7528\uff1a\u585e\u5b8c\u4e86:{}", (Object)JsonUtils.toJson((Object)task, (boolean)false));
                    this.pushTask(task.getId());
                    this.logger.info("trigger\u88ab\u8c03\u7528\uff1apush\u5b8c\u4e86:{}", (Object)JsonUtils.toJson((Object)task, (boolean)false));
                }).start();
            }
        });
        return BaseJsonVo.success(null);
    }
}

