/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.ExecStatusEnum;
import cc.lechun.baseservice.constant.RuleTypeEnum;
import cc.lechun.baseservice.dao.TagRuleMapper;
import cc.lechun.baseservice.entity.TagEntity;
import cc.lechun.baseservice.entity.TagOptionEntity;
import cc.lechun.baseservice.entity.TagRuleDo;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.baseservice.model.sms.TagRuleVo;
import cc.lechun.baseservice.service.TagInterface;
import cc.lechun.baseservice.service.TagOptionInterface;
import cc.lechun.baseservice.service.UserGroupRuleInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.ruleUser.RuleUserContext;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserGroupRuleService
extends BaseService
implements UserGroupRuleInterface {
    @Autowired
    private TagRuleMapper tagRuleMapper;
    @Autowired
    protected MemcachedService memcachedService;
    @Autowired
    private TagInterface tagInterface;
    @Autowired
    private RuleUserContext ruleUserContext;
    @Autowired
    private TagOptionInterface tagOptionInterface;
    @Autowired
    private UserInterface userInterface;

    @Override
    public List<TagRuleDo> getTagRuleDoListByGroupId(Integer groupId) {
        TagRuleEntity query = new TagRuleEntity();
        query.setGroupId(groupId);
        ArrayList result = new ArrayList();
        List list = this.tagRuleMapper.getList(query);
        return list.stream().map(tagRuleEntity -> {
            TagOptionEntity tagOptionEntity;
            TagRuleDo tagRuleDo = new TagRuleDo();
            BeanUtils.copyProperties((Object)tagRuleEntity, (Object)tagRuleDo);
            TagEntity tagEntity = this.tagInterface.getTagEntityByTagId(tagRuleEntity.getTagId());
            if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.EQUAL.getValue()) {
                tagOptionEntity = this.tagOptionInterface.getTagOption(tagRuleEntity.getTagId(), tagRuleEntity.getRuleValue());
                if (tagRuleDo.getTagOptionList() != null && tagOptionEntity != null) {
                    ArrayList<TagOptionEntity> tagOptionEntityList = new ArrayList<TagOptionEntity>();
                    tagOptionEntityList.add(tagOptionEntity);
                    tagRuleDo.setTagOptionList(tagOptionEntityList);
                }
            }
            tagRuleDo.setTagType(tagEntity == null ? 0 : tagEntity.getType());
            tagOptionEntity = this.tagOptionInterface.getTagOption(tagRuleEntity.getTagId(), tagRuleEntity.getRuleValue());
            tagRuleDo.setRuleValueName(tagOptionEntity == null ? "" : tagOptionEntity.getTagValue());
            return tagRuleDo;
        }).collect(Collectors.toList());
    }

    @Override
    @ReadThroughSingleCache(namespace="UserGroupRuleService.getTagRuleListByGroupId", expiration=80)
    public BaseJsonVo<List<TagRuleEntity>> getTagRuleListByGroupId(@ParameterValueKeyProvider Integer groupId) {
        TagRuleEntity query = new TagRuleEntity();
        query.setGroupId(groupId);
        return BaseJsonVo.success((Object)this.tagRuleMapper.getList(query));
    }

    @Override
    public BaseJsonVo updateRuleStatus(Integer ruleId) {
        TagRuleEntity tagRuleEntity = (TagRuleEntity)this.tagRuleMapper.selectByPrimaryKey(ruleId);
        if (tagRuleEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u89c4\u5219.");
        }
        TagRuleEntity update = new TagRuleEntity();
        update.setId(ruleId);
        update.setStatus(tagRuleEntity.getStatus() == 1 ? 0 : 1);
        this.tagRuleMapper.updateByPrimaryKeySelective(update);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteRule(Integer ruleId) {
        this.tagRuleMapper.deleteByPrimaryKey(ruleId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteRuleByGroupId(Integer groupId) {
        TagRuleEntity query = new TagRuleEntity();
        query.setGroupId(groupId);
        List list = this.tagRuleMapper.getList(query);
        if (list.size() > 0) {
            list.forEach(rule -> this.tagRuleMapper.deleteByPrimaryKey(rule.getId()));
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    @ReadThroughSingleCache(namespace="UserGroupRuleService.getRuleVoList", expiration=80)
    public BaseJsonVo<List<TagRuleVo>> getRuleVoList(@ParameterValueKeyProvider Integer groupId) {
        Page page = PageHelper.startPage((int)1, (int)999);
        page.setOrderBy("ID desc");
        TagRuleEntity query = new TagRuleEntity();
        query.setGroupId(groupId);
        List list = this.tagRuleMapper.getList(query);
        ArrayList<TagRuleVo> tagRuleVos = new ArrayList<TagRuleVo>();
        for (TagRuleEntity tagRuleEntity : list) {
            TagRuleVo tagRuleVo = new TagRuleVo();
            BeanUtils.copyProperties((Object)tagRuleEntity, (Object)tagRuleVo);
            tagRuleVo.setConditionName(RuleTypeEnum.getName(tagRuleEntity.getRuleType()));
            tagRuleVo.setStatusName(tagRuleEntity.getStatus() == 1 ? "\u5df2\u542f\u7528" : "\u672a\u542f\u7528");
            tagRuleVos.add(tagRuleVo);
        }
        return BaseJsonVo.success(tagRuleVos);
    }

    @Override
    public BaseJsonVo saveRule(TagRuleEntity tagRuleEntity) {
        if (tagRuleEntity.getId() == null || tagRuleEntity.getId() == 0) {
            tagRuleEntity.setCreateTime(DateUtils.now());
            tagRuleEntity.setStatus(1);
            return this.tagRuleMapper.insert(tagRuleEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        this.tagRuleMapper.updateByPrimaryKeySelective(tagRuleEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }

    @Override
    public BaseJsonVo saveRule(List<TagRuleEntity> list) {
        if (list != null && list.size() >= 1) {
            this.userInterface.deleteUser(list.get(0).getGroupId());
            HashSet tagSet = new HashSet(list.stream().map(TagRuleEntity::getTagId).collect(Collectors.toList()));
            for (Integer tagId : tagSet) {
                List<TagRuleEntity> tempList = list.stream().filter(tagRuleEntity -> tagRuleEntity.getTagId().equals(tagId)).collect(Collectors.toList());
                TagEntity tagEntity = this.tagInterface.getTagEntityByTagId(tagId);
                tempList.forEach(tagRuleEntity -> {
                    tagRuleEntity.setExecStatus(ExecStatusEnum.DONE.getValue());
                    this.logger.info(tagRuleEntity.toString());
                });
                if (StringUtils.isNotEmpty((String)tagEntity.getTempSql())) {
                    ((TagRuleEntity)tempList.get(0)).setResultSql(this.ruleUserContext.getExexSQL(tempList, tagEntity));
                    tempList.get(0).setExecStatus(ExecStatusEnum.UNDO.getValue());
                    this.logger.info("\u89e3\u6790\u540e\u7684sql:{}", (Object)tempList.get(0).getResultSql());
                    if (tempList.size() > 1) {
                        for (int i = 1; i < tempList.size(); ++i) {
                            tempList.get(i).setExecStatus(ExecStatusEnum.DONE.getValue());
                            tempList.get(i).setResultSql("");
                        }
                    }
                }
                for (TagRuleEntity tagRuleEntity2 : tempList) {
                    this.logger.info(tagRuleEntity2.toString());
                    tagRuleEntity2.setCreateTime(DateUtils.now());
                    tagRuleEntity2.setStatus(1);
                    this.tagRuleMapper.insert(tagRuleEntity2);
                }
            }
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f!");
    }
}

