/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.impl;

import cc.lechun.baseservice.constant.GroupTypeEnum;
import cc.lechun.baseservice.dao.GroupDetailMapper;
import cc.lechun.baseservice.entity.GroupDetailEntity;
import cc.lechun.baseservice.entity.GroupDetailExportVo;
import cc.lechun.baseservice.entity.GroupDetailQuery;
import cc.lechun.baseservice.entity.TagEntity;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.baseservice.entity.UserGroupEntity;
import cc.lechun.baseservice.entity.UserGroupVo;
import cc.lechun.baseservice.entity.UserMessageVo;
import cc.lechun.baseservice.model.sms.UserGroupQueryVo;
import cc.lechun.baseservice.service.TagInterface;
import cc.lechun.baseservice.service.UserGroupInterface;
import cc.lechun.baseservice.service.UserGroupRuleInterface;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.apiinvoke.customer.CustomerInfoInvoke;
import cc.lechun.cms.dto.CashticketRemarkVo;
import cc.lechun.cms.dto.CustomerInfoDTO;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserService
extends BaseService
implements UserInterface {
    @Autowired
    private GroupDetailMapper groupDetailMapper;
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Autowired
    private CustomerInfoInvoke customerInfoInvoke;
    @Autowired
    private UserGroupRuleInterface groupRuleInterface;
    @Autowired
    private TagInterface tagInterface;

    @Override
    public void savePushStatus(Integer id, int pushStatus) {
        GroupDetailEntity groupDetailEntity = new GroupDetailEntity();
        groupDetailEntity.setId(id);
        groupDetailEntity.setPushStatus(pushStatus);
        boolean result = this.groupDetailMapper.updateByPrimaryKeySelective(groupDetailEntity) > 0;
        this.logger.info("\u8bbe\u7f6e\u63a8\u9001\u72b6\u6001\uff1a{}\u4e3a{},id={}", new Object[]{pushStatus, result, id});
    }

    @Override
    public BaseJsonVo<LinkedHashMap<String, String>> getContentParaMap(UserMessageVo messageVo) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (messageVo.getId() != null) {
            BaseJsonVo<List<TagRuleEntity>> baseJsonVo;
            if (messageVo.getGroupId() != null && (baseJsonVo = this.groupRuleInterface.getTagRuleListByGroupId(messageVo.getGroupId())).isSuccess()) {
                for (TagRuleEntity tagRuleEntity : (List)baseJsonVo.getValue()) {
                    GroupDetailEntity groupDetailEntity;
                    TagEntity tagEntity = this.tagInterface.getTagEntityByTagId(tagRuleEntity.getTagId());
                    if (tagEntity.getId() != 3 && tagEntity.getPid() != 3 || (groupDetailEntity = (GroupDetailEntity)this.groupDetailMapper.selectByPrimaryKey(messageVo.getId())) == null || !StringUtils.isNotEmpty((String)groupDetailEntity.getRemark())) continue;
                    CashticketRemarkVo cashticketRemarkVo = (CashticketRemarkVo)JSON.parseObject((String)groupDetailEntity.getRemark(), CashticketRemarkVo.class);
                    if (cashticketRemarkVo == null) break;
                    if (StringUtils.isNotEmpty((String)cashticketRemarkVo.getTicketBatchName())) {
                        map.put("ticketBatchName", cashticketRemarkVo.getTicketBatchName());
                    }
                    if (cashticketRemarkVo.getEndTime() != null) {
                        map.put("endTime", DateUtils.formatDate((Date)cashticketRemarkVo.getEndTime(), (String)""));
                    }
                    String pre = "";
                    pre = cashticketRemarkVo.getMinUseamount().doubleValue() == 0.0 ? "\u65e0\u95e8\u69db" : "\u6ee1" + cashticketRemarkVo.getMinUseamount().doubleValue();
                    if (cashticketRemarkVo.getDiscountMode() == 0) {
                        pre = pre + "\u51cf" + cashticketRemarkVo.getAmount();
                    } else if (cashticketRemarkVo.getDiscountMode() == 1) {
                        pre = pre + "\u4eab" + MathUtils.divBigDecimal((Number)cashticketRemarkVo.getDiscountAmount(), (Number)10, (Integer)2) + "\u6298";
                    }
                    if (cashticketRemarkVo.getEndTime() == null) break;
                    map.put("pre", pre);
                    break;
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.logger.info("key:" + key + ";value:" + value);
            }
        }
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo deleteUser(Integer groupId) {
        this.groupDetailMapper.deleteByGroupId(groupId);
        this.updateGroupNum(groupId);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateAllGroupNum() {
        UserGroupQueryVo userGroupQueryVo = new UserGroupQueryVo();
        userGroupQueryVo.setPageSize(Integer.valueOf(999999));
        userGroupQueryVo.setCurrentPage(Integer.valueOf(0));
        PageInfo<UserGroupVo> pageInfo = this.userGroupInterface.getUserGroupList(userGroupQueryVo);
        if (pageInfo != null && pageInfo.getList() != null && pageInfo.getList().size() > 0) {
            for (UserGroupVo groupEntity : pageInfo.getList()) {
                if (groupEntity.getGroupType().intValue() != GroupTypeEnum.TEMPLATE.getValue()) continue;
                this.updateGroupNum(groupEntity.getId());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateGroupNum(int groupId) {
        UserGroupEntity update = new UserGroupEntity();
        update.setId(groupId);
        update.setNum(this.groupDetailMapper.getGroupUserNumber(groupId));
        update.setStatus(1);
        update.setUpdateTime(DateUtils.now());
        this.userGroupInterface.saveGroup(update);
        this.logger.info("\u7528\u6237\u7ec4\u7528\u6237\u6570\u66f4\u65b0\u6210\u529f:{}", (Object)update.getNum());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateGroupNum(int groupId, int num) {
        this.logger.info("\u67e5\u8be2\u7528\u6237\u7ec4\u7528\u6237\u6570:{}", (Object)num);
        UserGroupEntity update = new UserGroupEntity();
        update.setId(groupId);
        update.setNum(num);
        this.userGroupInterface.saveGroup(update);
        this.logger.info("\u7528\u6237\u7ec4\u7528\u6237\u6570\u66f4\u65b0\u6210\u529f:{}", (Object)num);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo<GroupDetailEntity> getUserByGroupId(GroupDetailQuery user) {
        Page page = PageHelper.startPage((int)user.getCurrentPage(), (int)user.getPageSize());
        GroupDetailEntity groupDetailEntity = new GroupDetailEntity();
        if (user.getGroupId() != null) {
            groupDetailEntity.setGroupId(user.getGroupId());
        }
        if (user.getPushStatus() != null) {
            groupDetailEntity.setPushStatus(user.getPushStatus());
        }
        List list = this.groupDetailMapper.getList(groupDetailEntity);
        return page.toPageInfo();
    }

    @Override
    public BaseJsonVo saveUserList(List<GroupDetailEntity> list) {
        if (list != null && list.size() > 0) {
            list.forEach(user -> {
                BaseJsonVo baseJsonVo;
                if (StringUtils.isEmpty((String)user.getCustomerId())) {
                    user.setCustomerId("");
                }
                if (StringUtils.isEmpty((String)user.getEmail())) {
                    user.setEmail("");
                }
                if (StringUtils.isEmpty((String)user.getMobile())) {
                    if (StringUtils.isNotEmpty((String)user.getCustomerId())) {
                        baseJsonVo = this.customerInfoInvoke.getCustomerInfo(user.getCustomerId(), 1);
                        if (baseJsonVo.isSuccess()) {
                            user.setMobile(((CustomerInfoDTO)baseJsonVo.getValue()).getMobile());
                        }
                    } else {
                        user.setOpenId("");
                    }
                }
                if (StringUtils.isEmpty((String)user.getOpenId())) {
                    if (StringUtils.isNotEmpty((String)user.getCustomerId())) {
                        baseJsonVo = this.customerInfoInvoke.getCustomerInfo(user.getCustomerId(), 1);
                        if (baseJsonVo.isSuccess()) {
                            user.setOpenId(((CustomerInfoDTO)baseJsonVo.getValue()).getOpenId());
                        }
                    } else {
                        user.setOpenId("");
                    }
                }
                user.setCreateTime(DateUtils.now());
                this.logger.info("\u7528\u6237\u7ec4\u7528\u6237:{}", (Object)user.toString());
            });
        }
        Integer groupId = list.get(0).getGroupId();
        BaseJsonVo baseJsonVo = this.groupDetailMapper.batchInsert(list) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        this.updateGroupNum(groupId);
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo saveUserList4Import(List<GroupDetailExportVo> list) {
        ArrayList<GroupDetailEntity> result = new ArrayList<GroupDetailEntity>();
        result.addAll(list.stream().map(item -> {
            GroupDetailEntity groupDetailEntity = new GroupDetailEntity();
            BeanUtils.copyProperties((Object)item, (Object)groupDetailEntity);
            return groupDetailEntity;
        }).collect(Collectors.toList()));
        return this.saveUserList(result);
    }
}

