/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.ruleUser;

import cc.lechun.baseservice.constant.RuleTypeEnum;
import cc.lechun.baseservice.entity.GroupDetailEntity;
import cc.lechun.baseservice.entity.TagEntity;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.apiinvoke.customer.InteractionInvoke;
import cc.lechun.baseservice.service.ruleUser.IRuleCustomer;
import cc.lechun.baseservice.service.ruleUser.RuleBase;
import cc.lechun.cms.dto.GroupUserlDTO;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_11")
public class InteractionCustomerService
extends RuleBase
implements IRuleCustomer {
    @Autowired
    private InteractionInvoke interactionInvoke;
    @Autowired
    private UserInterface userInterface;

    @Override
    public String getExexSQL(List<TagRuleEntity> list, TagEntity tagEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        list.forEach(tagRuleEntity -> this.logger.info(tagRuleEntity.toString()));
        for (TagRuleEntity tagRuleEntity2 : list) {
            if (!StringUtils.isNotEmpty((String)tagEntity.getTempSql())) continue;
            if (tagRuleEntity2.getRuleType().intValue() == RuleTypeEnum.GREATER.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} > greater ");
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity2.getRuleValue())));
            } else if (tagRuleEntity2.getRuleType().intValue() == RuleTypeEnum.IS_GREATER.getValue()) {
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity2.getRuleValue())));
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} >= greater ");
            }
            if (tagRuleEntity2.getRuleType().intValue() == RuleTypeEnum.LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} < less ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity2.getRuleValue())));
            } else if (tagRuleEntity2.getRuleType().intValue() == RuleTypeEnum.IS_LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} <= less ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity2.getRuleValue())));
            }
            map.put("filterField", tagEntity.getFilterField());
            map.put("source", tagEntity.getSource());
            map.put("platformGroupId", "1000");
            map.put("platformId", "1");
        }
        this.saveData(list, tagEntity);
        return "";
    }

    private void saveData(final List<TagRuleEntity> list, final TagEntity tagEntity) {
        ThreadPool.services.execute(new Runnable(){

            @Override
            public void run() {
                String start = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-2), (String)"");
                String end = DateUtils.formatDate((Date)DateUtils.now(), (String)"");
                for (TagRuleEntity tagRuleEntity : list) {
                    if (!StringUtils.isNotEmpty((String)tagEntity.getTempSql())) continue;
                    if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.GREATER.getValue()) {
                        tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} > greater ");
                        if (DateUtils.getDateFromString((String)tagRuleEntity.getRuleValue()).after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-2))) {
                            start = tagRuleEntity.getRuleValue();
                        }
                    } else if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.IS_GREATER.getValue()) {
                        tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} >= greater ");
                        start = tagRuleEntity.getRuleValue();
                    }
                    if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.LESS.getValue()) {
                        tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} < less ");
                        end = tagRuleEntity.getRuleValue();
                        continue;
                    }
                    if (tagRuleEntity.getRuleType().intValue() != RuleTypeEnum.IS_LESS.getValue()) continue;
                    tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} <= less ");
                    end = tagRuleEntity.getRuleValue();
                }
                BaseJsonVo result = InteractionCustomerService.this.interactionInvoke.getCustomerInteractionList(0, 0, end, start);
                if (result.isSuccess()) {
                    List userList = (List)result.getValue();
                    ArrayList<GroupDetailEntity> tempList = new ArrayList<GroupDetailEntity>();
                    int i = 0;
                    for (GroupUserlDTO groupUserlDTO : userList) {
                        ++i;
                        GroupDetailEntity userGroupDetail = new GroupDetailEntity();
                        userGroupDetail.setCreateTime(DateUtils.now());
                        userGroupDetail.setCustomerId(groupUserlDTO.getCustomerId());
                        userGroupDetail.setEmail("");
                        userGroupDetail.setGroupId(((TagRuleEntity)list.get(0)).getGroupId());
                        userGroupDetail.setMobile(groupUserlDTO.getMobile());
                        userGroupDetail.setOpenId(groupUserlDTO.getOpenId());
                        userGroupDetail.setRemark("");
                        tempList.add(userGroupDetail);
                        if (i % 2000 != 0) continue;
                        InteractionCustomerService.this.userInterface.saveUserList(tempList);
                        tempList = new ArrayList();
                    }
                    if (tempList.size() > 0) {
                        InteractionCustomerService.this.userInterface.saveUserList(tempList);
                    }
                }
            }
        });
    }
}

