/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.ruleUser;

import cc.lechun.baseservice.constant.RuleTypeEnum;
import cc.lechun.baseservice.entity.TagEntity;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBase {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected String renderString(String content, Map<String, String> map) {
        Set<Map.Entry<String, String>> sets = map.entrySet();
        for (Map.Entry<String, String> entry : sets) {
            if (!content.contains("{" + entry.getKey() + "}")) continue;
            content = content.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return content;
    }

    protected String getTimeTypeExexSQL(TagRuleEntity tagRuleEntity, TagEntity tagEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)tagEntity.getTempSql())) {
            if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.GREATER.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} > ADDDATE(now(), INTERVAL -{greater} DAY)");
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            } else if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.IS_GREATER.getValue()) {
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} >= ADDDATE(now(), INTERVAL -{greater} DAY)");
            }
            if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} < ADDDATE(now(), INTERVAL -{less} DAY) ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            } else if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.IS_LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} <= ADDDATE(now(), INTERVAL -{less} DAY) ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            }
            map.put("filterField", tagEntity.getFilterField());
            map.put("source", tagEntity.getSource());
            map.put("platformGroupId", "1000");
            tagRuleEntity.setResultSql(this.renderString(tagEntity.getTempSql(), map));
            return this.renderString(tagEntity.getTempSql(), map);
        }
        return "";
    }

    protected String getTimeTypeExexSQL(List<TagRuleEntity> list, TagEntity tagEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (TagRuleEntity tagRuleEntity : list) {
            if (!StringUtils.isNotEmpty((String)tagEntity.getTempSql())) continue;
            if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.GREATER.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} > ADDDATE(now(), INTERVAL -{greater} DAY)");
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            } else if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.IS_GREATER.getValue()) {
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} >= ADDDATE(now(), INTERVAL -{greater} DAY)");
            }
            if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} < ADDDATE(now(), INTERVAL -{less} DAY) ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            } else if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.IS_LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} <= ADDDATE(now(), INTERVAL -{less} DAY) ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            }
            map.put("filterField", tagEntity.getFilterField());
            map.put("source", tagEntity.getSource());
            map.put("platformGroupId", "1000");
        }
        return this.renderString(tagEntity.getTempSql(), map);
    }

    protected String getEqualsExexSQL(List<TagRuleEntity> list, TagEntity tagEntity) {
        String sql = "";
        list.forEach(tagRuleEntity -> this.logger.info(tagRuleEntity.toString()));
        for (TagRuleEntity tagRuleEntity2 : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            String tempSQL = tagEntity.getTempSql();
            if (StringUtils.isNotEmpty((String)tagEntity.getTempSql())) {
                if (tagRuleEntity2.getRuleType().intValue() == RuleTypeEnum.EQUAL.getValue()) {
                    tempSQL = tagEntity.getTempSql() + " and {filterField} ='" + tagRuleEntity2.getRuleValue() + "'";
                }
                map.put("filterField", tagEntity.getFilterField());
                map.put("source", tagEntity.getSource());
            }
            sql = sql + this.renderString(tempSQL, map);
            sql = sql + " UNION ";
        }
        if (sql.endsWith(" UNION ")) {
            sql = sql.substring(0, sql.length() - 7);
        }
        return sql;
    }
}

