/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.baseservice.service.ruleUser;

import cc.lechun.baseservice.constant.RuleTypeEnum;
import cc.lechun.baseservice.entity.TagEntity;
import cc.lechun.baseservice.entity.TagRuleEntity;
import cc.lechun.baseservice.service.UserInterface;
import cc.lechun.baseservice.service.apiinvoke.customer.ShopCarInvoke;
import cc.lechun.baseservice.service.ruleUser.IRuleCustomer;
import cc.lechun.baseservice.service.ruleUser.RuleBase;
import cc.lechun.framework.common.utils.string.StringUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_7")
public class ShopCarService
extends RuleBase
implements IRuleCustomer {
    @Autowired
    private ShopCarInvoke shopCarInvoke;
    @Autowired
    private UserInterface userInterface;

    @Override
    public String getExexSQL(List<TagRuleEntity> list, TagEntity tagEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (TagRuleEntity tagRuleEntity : list) {
            if (!StringUtils.isNotEmpty((String)tagEntity.getTempSql())) continue;
            if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.GREATER.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} > ADDDATE(now(), INTERVAL -{greater} DAY)");
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            } else if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.IS_GREATER.getValue()) {
                map.put("greater", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} >= ADDDATE(now(), INTERVAL -{greater} DAY)");
            }
            if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} < ADDDATE(now(), INTERVAL -{less} DAY) ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            } else if (tagRuleEntity.getRuleType().intValue() == RuleTypeEnum.IS_LESS.getValue()) {
                tagEntity.setTempSql(tagEntity.getTempSql() + " and {filterField} <= ADDDATE(now(), INTERVAL -{less} DAY) ");
                map.put("less", String.valueOf(Integer.valueOf(tagRuleEntity.getRuleValue())));
            }
            map.put("filterField", tagEntity.getFilterField());
            map.put("source", tagEntity.getSource());
            map.put("platformGroupId", "1000");
        }
        return this.renderString(tagEntity.getTempSql(), map);
    }
}

