/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sms.health;

import cc.lechun.baseservice.model.sms.MessageEntity;
import cc.lechun.sms.config.SMSHealthConfig;
import cc.lechun.sms.constant.Columns;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class SMSHealthIndicator
implements HealthIndicator {
    private final boolean[] samples;
    private long count = 0L;
    private final float threshold;
    private String lastFailCode = null;

    public SMSHealthIndicator(SMSHealthConfig config) {
        this.samples = new boolean[config.getSamples()];
        this.threshold = config.getThreshold();
    }

    public synchronized Health health() {
        if (this.count < (long)this.samples.length) {
            return Health.unknown().withDetail("count", (Object)this.count).build();
        }
        int success = 0;
        for (boolean sample : this.samples) {
            if (!sample) continue;
            ++success;
        }
        float ratio = (float)(success * 100 / this.samples.length) / 100.0f;
        if (ratio < this.threshold) {
            return Health.down().withDetail("count", (Object)this.count).withDetail("ratio", (Object)Float.valueOf(ratio)).withDetail("lastFailCode", (Object)this.lastFailCode).build();
        }
        return Health.up().withDetail("count", (Object)this.count).withDetail("ratio", (Object)Float.valueOf(ratio)).build();
    }

    public synchronized void addSample(MessageEntity message) {
        if (message.getSendStatus() == Columns.SendStatus.SUCCESS) {
            int index = (int)(this.count++ % (long)this.samples.length);
            this.samples[index] = true;
        } else if (message.getSendStatus() == Columns.SendStatus.FAILURE) {
            this.lastFailCode = message.getFailCode();
            int index = (int)(this.count++ % (long)this.samples.length);
            this.samples[index] = false;
        }
    }
}

