/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sms.service.impl;

import cc.lechun.baseservice.model.sms.MessageContentDTO;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.framework.common.utils.http.HttpComponentUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.sms.config.MWSMSConfig;
import cc.lechun.sms.exception.ChannelException;
import cc.lechun.sms.service.IChannelSMSService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mw")
public class MWSmsSServiceImpl
implements IChannelSMSService {
    private static final Logger logger = LoggerFactory.getLogger(MWSmsSServiceImpl.class);
    @Autowired
    private MWSMSConfig mwSMSConfig;

    @Override
    public BaseJsonVo send(MessageContentDTO message) throws ChannelException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", this.mwSMSConfig.getUserId());
        params.put("password", this.mwSMSConfig.getPassword());
        params.put("pszMobis", message.getMobile());
        params.put("pszMsg", message.getContent());
        params.put("iMobiCount", "1");
        params.put("pszSubPort", "*");
        params.put("MsgId", RandomUtils.generateStrId());
        logger.info("\u68a6\u7f51\u77ed\u4fe1\u53d1\u9001\u5185\u5bb9:[{}],\u624b\u673a\u53f7:[{}]", (Object)message.getContent(), (Object)message.getMobile());
        String flag = this.sendSms(message.getMobile(), params);
        return BaseJsonVo.success((Object)flag);
    }

    @Override
    public BaseJsonVo send(SendMessageVo message) throws ChannelException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", this.mwSMSConfig.getUserId());
        params.put("password", this.mwSMSConfig.getPassword());
        params.put("pszMobis", message.getAccount());
        params.put("pszMsg", message.getContent());
        params.put("iMobiCount", "1");
        params.put("pszSubPort", "*");
        params.put("MsgId", RandomUtils.generateStrId());
        logger.info("\u68a6\u7f51\u77ed\u4fe1\u53d1\u9001\u5185\u5bb9:[{}],\u624b\u673a\u53f7:[{}]", (Object)message.getContent(), (Object)message.getAccount());
        String flag = this.sendSms(message.getAccount(), params);
        return BaseJsonVo.success((Object)flag);
    }

    private String sendSms(String mobile, Map params) {
        HttpRequest httpRequest = new HttpRequest(this.mwSMSConfig.getBaseUrl() + "MongateSendSubmit", params);
        httpRequest.setMethod("POST");
        String str = HttpComponentUtil.execute((HttpRequest)httpRequest);
        String result = "";
        if (!StringUtils.isEmpty((String)str)) {
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)str);
                Element el = doc.getRootElement();
                result = el.getText();
                logger.info("\u68a6\u7f51\u77ed\u4fe1\u53d1\u9001\u7ed3\u679c:[{}],\u624b\u673a\u53f7:[{}]", (Object)str, (Object)mobile);
            }
            catch (DocumentException e) {
                logger.error("", (Throwable)e);
            }
        }
        return StringUtils.isEmpty((String)result) ? str : result;
    }

    private void checkChannelException(int intBody) throws ChannelException {
    }

    private String renderString(String content, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> sets = map.entrySet();
        for (Map.Entry<String, Object> entry : sets) {
            String regex = "\\$\\{" + entry.getKey() + "}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(content);
            content = matcher.replaceAll(String.valueOf(entry.getValue()));
        }
        return content;
    }

    @Override
    public String getChannel() {
        return "mw";
    }

    @Override
    public BaseJsonVo getMongateBalance() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", this.mwSMSConfig.getUserId());
        params.put("password", this.mwSMSConfig.getPassword());
        HttpRequest httpRequest = new HttpRequest(this.mwSMSConfig.getBaseUrl() + "MongateQueryBalance", params);
        httpRequest.setMethod("POST");
        String str = HttpComponentUtil.execute((HttpRequest)httpRequest);
        String result = "";
        if (!StringUtils.isEmpty((String)str)) {
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)str);
                Element el = doc.getRootElement();
                result = el.getText();
                logger.info("\u68a6\u7f51\u4f59\u989d:[{}]", (Object)result);
            }
            catch (DocumentException e) {
                logger.error("", (Throwable)e);
            }
        }
        return BaseJsonVo.success((Object)result);
    }
}

