/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sms.aicall.util;

import cc.lechun.sms.aicall.contract.EncryRequest;
import cc.lechun.sms.aicall.util.DigestUtils;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    public static final String ENCRYPT_MODE_ECB = "ECB";
    private static final String _ENCRYPT_MODE = "CBC";

    public static String encrypt(String plaintext, String key) {
        return AESUtil.encrypt(plaintext, key, _ENCRYPT_MODE);
    }

    public static String encrypt(String plainText, String key, String encryptMode) {
        if (AESUtil.isEmpty(key) || AESUtil.isEmpty(plainText)) {
            return null;
        }
        try {
            key = AESUtil.getMD5(key);
            byte[] raw = key.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/" + encryptMode + "/PKCS5Padding");
            if (encryptMode == ENCRYPT_MODE_ECB) {
                cipher.init(1, skeySpec);
            } else {
                IvParameterSpec iv = new IvParameterSpec(key.getBytes(StandardCharsets.UTF_8));
                cipher.init(1, (Key)skeySpec, iv);
            }
            byte[] encrypted = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
            String encryptedStr = new String(Base64.getEncoder().encode(encrypted));
            return encryptedStr;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getMD5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str).substring(8, 24);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.isEmpty();
    }

    public static void main(String[] args) {
        String path = args[0];
        String aesKey = args[1];
        String time = String.valueOf(System.currentTimeMillis());
        String raw = AESUtil.encrypt(AESUtil.getJsonStr(path), aesKey);
        StringBuffer buffer = new StringBuffer();
        buffer.append(time + raw);
        String hash = DigestUtils.md5DigestAsHex(buffer.toString().getBytes());
        EncryRequest encryRequest = new EncryRequest();
        encryRequest.setHash(hash);
        encryRequest.setRaw(raw);
        encryRequest.setTime(time);
        System.out.println(JSON.toJSONString((Object)encryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJsonStr(String path) {
        StringBuffer stringBuffer = new StringBuffer();
        File jsonFile = new File(path);
        FileInputStream fileInputStream = null;
        Reader reader = null;
        try {
            fileInputStream = new FileInputStream(jsonFile);
            reader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            int ch = 0;
            while ((ch = reader.read()) != -1) {
                stringBuffer.append((char)ch);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return stringBuffer.toString();
    }
}

