/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sms.service.impl.MW;

import cc.lechun.sms.service.impl.MW.ConfigManager;
import cc.lechun.sms.service.impl.MW.Message;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONValue;

public class CheckAddress {
    public static int ERROR_310099 = -310099;
    public static int CHECK_HTTP_REQUEST_TIMEOUT = 3000;
    public static int CHECK_HTTP_RESPONSE_TIMEOUT = 30000;
    private Gson gson = new Gson();

    public String getAddressByUserID(String userid, String password, String timestamp) {
        try {
            String availableAddress;
            String address;
            if (ConfigManager.masterIPState == 0) {
                if (!ConfigManager.masterIpAndPort.equals(ConfigManager.availableIpAndPort)) {
                    ConfigManager.availableIpAndPort = ConfigManager.masterIpAndPort;
                }
                return ConfigManager.availableIpAndPort;
            }
            if (Calendar.getInstance().getTimeInMillis() - ConfigManager.LAST_CHECK_TIME > ConfigManager.CHECK_TIME_INTERVAL && (address = this.checkMasterAddress(userid, password, timestamp)) != null && !"".equals(address)) {
                return address;
            }
            if (ConfigManager.ipAndPortBak != null && ConfigManager.ipAndPortBak.size() > 0) {
                for (int i = 0; i < ConfigManager.ipAndPortBak.size(); ++i) {
                    if (!ConfigManager.ipAndPortBak.get(i).equals(ConfigManager.availableIpAndPort)) continue;
                    return ConfigManager.ipAndPortBak.get(i);
                }
            }
            if ((availableAddress = this.checkAddress(userid, password, timestamp)) != null) {
                ConfigManager.availableIpAndPort = availableAddress;
                return availableAddress;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String checkAddress(String userid, String password, String timestamp) {
        String address = null;
        try {
            int result = ERROR_310099;
            boolean isDomainGet = false;
            List<String> ipAndPortBakList = ConfigManager.ipAndPortBak;
            String ipAddressBak = null;
            if (ipAndPortBakList != null && ipAndPortBakList.size() > 0) {
                for (int i = 0; i < ipAndPortBakList.size(); ++i) {
                    String newIpAndPort;
                    String ip;
                    ipAddressBak = ipAndPortBakList.get(i);
                    result = this.checkAddressAvailable(userid, password, timestamp, ipAddressBak);
                    if (result == 0) {
                        address = ipAddressBak;
                        break;
                    }
                    String domainBak = ConfigManager.ipAndDomainBakMap.get(ipAddressBak);
                    if (domainBak == null || "".equals(domainBak) || (ip = this.getIpByDomain(domainBak.split(":")[0])) == null || "".equals(ip.trim()) || (result = this.checkAddressAvailable(userid, password, timestamp, newIpAndPort = ip + ":" + ipAddressBak.split(":")[1])) != 0) continue;
                    isDomainGet = true;
                    ConfigManager.ipAndDomainBakMap.remove(ipAddressBak);
                    ConfigManager.ipAndDomainBakMap.put(newIpAndPort, domainBak);
                    address = newIpAndPort;
                    break;
                }
                if (address != null && !"".equals(address) && isDomainGet) {
                    ConfigManager.ipAndPortBak.remove(ipAddressBak);
                    ConfigManager.ipAndPortBak.add(address);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            address = null;
        }
        return address;
    }

    private int checkAddressAvailable(String userId, String password, String timestamp, String ipAddress) {
        int result = ERROR_310099;
        try {
            Message message = new Message();
            message.setUserid(userId.toUpperCase());
            message.setPwd(password);
            message.setTimestamp(timestamp);
            String Message2 = null;
            String balanceHost = "http://" + ipAddress;
            Message2 = this.executeNotKeepAlivePost(message, balanceHost + ConfigManager.REQUEST_PATH + "get_balance");
            if (String.valueOf(ERROR_310099).equals(Message2)) {
                return ERROR_310099;
            }
            if (Message2 == null || "".equals(Message2.trim())) {
                return ERROR_310099;
            }
            JSONObject parseObject = (JSONObject)JSONValue.parse((String)Message2);
            result = Integer.parseInt(String.valueOf(parseObject.get((Object)"result")));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = ERROR_310099;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeNotKeepAlivePost(Object obj, String httpUrl) throws Exception {
        String result;
        block19: {
            result = String.valueOf(ERROR_310099);
            DefaultHttpClient httpclient = null;
            try {
                String entityValue = this.gson.toJson(obj);
                HttpPost httppost = new HttpPost(httpUrl);
                httppost.setHeader("Content-Type", "text/json");
                StringEntity stringEntity = new StringEntity(entityValue, "UTF-8");
                httppost.setEntity((HttpEntity)stringEntity);
                httpclient = new DefaultHttpClient();
                httpclient.getParams().setParameter("http.connection.timeout", (Object)CHECK_HTTP_REQUEST_TIMEOUT);
                httpclient.getParams().setParameter("http.socket.timeout", (Object)CHECK_HTTP_RESPONSE_TIMEOUT);
                HttpEntity entity = null;
                HttpResponse httpResponse = null;
                try {
                    httpResponse = httpclient.execute((HttpUriRequest)httppost);
                    if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                        entity = httpResponse.getEntity();
                        if (entity != null && entity.getContentLength() > 0L) {
                            try {
                                result = EntityUtils.toString((HttpEntity)entity);
                            }
                            catch (Exception e) {
                                result = "";
                            }
                        } else {
                            result = "";
                        }
                        break block19;
                    }
                    result = String.valueOf(ERROR_310099);
                }
                catch (Exception e) {
                    result = String.valueOf(ERROR_310099);
                }
            }
            catch (Exception e) {
                result = String.valueOf(ERROR_310099);
            }
            finally {
                if (httpclient != null) {
                    try {
                        httpclient.getConnectionManager().shutdown();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private String checkMasterAddress(String userid, String password, String timestamp) {
        try {
            String newIpAndPort;
            String ip;
            ConfigManager.LAST_CHECK_TIME = Calendar.getInstance().getTimeInMillis();
            int result = this.checkAddressAvailable(userid, password, timestamp, ConfigManager.masterIpAndPort);
            if (result == 0) {
                ConfigManager.availableIpAndPort = ConfigManager.masterIpAndPort;
                ConfigManager.masterIPState = 0;
                System.out.println("\u4e3bipAddress[" + ConfigManager.masterIpAndPort + "]\u6062\u590d\u6b63\u5e38\u3002");
                return ConfigManager.availableIpAndPort;
            }
            if (ConfigManager.masterDomainAndPort != null && !"".equals(ConfigManager.masterDomainAndPort.trim()) && (ip = this.getIpByDomain(ConfigManager.masterDomainAndPort.split(":")[0])) != null && !"".equals(ip.trim()) && (result = this.checkAddressAvailable(userid, password, timestamp, newIpAndPort = ip + ":" + ConfigManager.masterDomainAndPort.split(":")[1])) == 0) {
                if (ConfigManager.masterIpAndPort.equals(newIpAndPort)) {
                    System.out.println("\u4e3bipAddress[" + ConfigManager.masterIpAndPort + "]\u6062\u590d\u6b63\u5e38\u3002");
                } else {
                    System.out.println("\u4e3bipAddress\u7531[" + ConfigManager.masterIpAndPort + "]\u5207\u6362\u4e3a[" + newIpAndPort + "]\u3002");
                }
                ConfigManager.availableIpAndPort = newIpAndPort;
                ConfigManager.masterIPState = 0;
                ConfigManager.masterIpAndPort = newIpAndPort;
                System.out.println("\u901a\u8fc7\u57df\u540d\u83b7\u53d6\u7684\u4e3bIP\u6b63\u5e38,\u4e3bIP\u548c\u7aef\u53e3\uff1a" + newIpAndPort);
                return ConfigManager.availableIpAndPort;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getIpByDomain(String domain) {
        String ip = null;
        try {
            ip = InetAddress.getByName(domain).getHostAddress();
        }
        catch (Exception e) {
            ip = null;
        }
        return ip;
    }
}

