/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sms.service.impl;

import cc.lechun.baseservice.model.sms.MessageContentDTO;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.framework.common.utils.http.HttpComponentUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.sms.config.MWSMSConfig;
import cc.lechun.sms.exception.ChannelException;
import cc.lechun.sms.service.IChannelSMSService;
import cc.lechun.sms.service.impl.MW.CHttpPost;
import cc.lechun.sms.service.impl.MW.Message;
import cc.lechun.sms.service.impl.MW.MultiMt;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mw")
public class MWSmsSServiceImpl
implements IChannelSMSService {
    private static final Logger logger = LoggerFactory.getLogger(MWSmsSServiceImpl.class);
    @Autowired
    private MWSMSConfig mwSMSConfig;
    private static int ERROR_310099 = -310099;
    private static SimpleDateFormat sdf = new SimpleDateFormat("MMddHHmmss");

    @Override
    @Deprecated
    public BaseJsonVo send(MessageContentDTO message) throws ChannelException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", this.mwSMSConfig.getUserId());
        params.put("password", this.mwSMSConfig.getPassword());
        params.put("pszMobis", message.getMobile());
        params.put("pszMsg", message.getContent());
        params.put("iMobiCount", "1");
        params.put("pszSubPort", "*");
        params.put("MsgId", RandomUtils.generateStrId());
        logger.info("\u68a6\u7f51\u77ed\u4fe1\u53d1\u9001\u5185\u5bb9:[{}],\u624b\u673a\u53f7:[{}]", (Object)message.getContent(), (Object)message.getMobile());
        String flag = this.sendSms(message.getMobile(), params);
        return BaseJsonVo.success((Object)flag);
    }

    @Override
    @Deprecated
    public BaseJsonVo send(SendMessageVo message) throws ChannelException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", this.mwSMSConfig.getUserId());
        params.put("password", this.mwSMSConfig.getPassword());
        params.put("pszMobis", message.getAccount());
        params.put("pszMsg", message.getContent());
        params.put("iMobiCount", "1");
        params.put("pszSubPort", "*");
        params.put("MsgId", RandomUtils.generateStrId());
        logger.info("\u68a6\u7f51\u77ed\u4fe1\u53d1\u9001\u5185\u5bb9:[{}],\u624b\u673a\u53f7:[{}]", (Object)message.getContent(), (Object)message.getAccount());
        String flag = this.sendSms(message.getAccount(), params);
        return BaseJsonVo.success((Object)flag);
    }

    @Override
    public BaseJsonVo send(String content, String mobile, String custid) throws ChannelException {
        try {
            Message message = new Message();
            CHttpPost cHttpPost = new CHttpPost();
            String userid = this.mwSMSConfig.getUserId();
            String pwd = this.mwSMSConfig.getPassword();
            logger.info("\u7528\u6237\u5e10\u53f7:{},\u5bc6\u7801:{}", (Object)userid, (Object)pwd);
            boolean isEncryptPwd = true;
            message.setUserid(userid.toUpperCase());
            if (isEncryptPwd) {
                String timestamp = sdf.format(Calendar.getInstance().getTime());
                message.setTimestamp(timestamp);
                String encryptPwd = cHttpPost.encryptPwd(message.getUserid(), pwd, message.getTimestamp());
                message.setPwd(encryptPwd);
            } else {
                message.setPwd(pwd);
            }
            message.setMobile(mobile);
            message.setContent(content);
            message.setCustid(StringUtils.isEmpty((String)custid) ? RandomUtils.generateId() : custid);
            StringBuffer msgId = new StringBuffer();
            int result = -310099;
            result = cHttpPost.singleSend(message, msgId);
            if (result == 0) {
                System.out.println("\u5355\u6761\u53d1\u9001\u63d0\u4ea4\u6210\u529f\uff01");
                System.out.println(msgId.toString());
                return BaseJsonVo.success((Object)message.getCustid());
            }
            System.out.println("\u5355\u6761\u53d1\u9001\u63d0\u4ea4\u5931\u8d25,\u9519\u8bef\u7801\uff1a" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    public int getBalance() {
        int result = -310099;
        try {
            CHttpPost cHttpPost = new CHttpPost();
            String userid = this.mwSMSConfig.getUserId();
            String pwd = this.mwSMSConfig.getPassword();
            boolean isEncryptPwd = true;
            userid = userid.toUpperCase();
            String timestamp = null;
            if (isEncryptPwd) {
                timestamp = sdf.format(Calendar.getInstance().getTime());
                pwd = cHttpPost.encryptPwd(userid, pwd, timestamp);
            } else {
                timestamp = null;
            }
            result = cHttpPost.getBalance(userid, pwd, timestamp);
            if (result >= 0) {
                System.out.println("\u67e5\u8be2\u4f59\u989d\u6210\u529f\uff0c\u4f59\u989d\u4e3a\uff1a" + result);
            } else {
                System.out.println("\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a" + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public BaseJsonVo batchSend(String content, String mobileList, String custid) throws ChannelException {
        if (!mobileList.contains(",")) {
            return this.send(content, mobileList, custid);
        }
        Message message = new Message();
        message.setContent(content);
        message.setMobile(mobileList.replace("\uff0c", ","));
        message.setUserid(this.mwSMSConfig.getUserId());
        message.setPwd(this.mwSMSConfig.getPassword());
        BaseJsonVo result = this.send2(message, true, custid);
        logger.info("\u8c03\u7528\u6279\u91cf\u63a8\u9001\u77ed\u4fe1\u63a5\u53e3:{}", (Object)result.isSuccess());
        return result;
    }

    private String sendSms(String mobile, Map params) {
        HttpRequest httpRequest = new HttpRequest(this.mwSMSConfig.getBaseUrl() + "MongateSendSubmit", params);
        httpRequest.setMethod("POST");
        String str = HttpComponentUtil.execute((HttpRequest)httpRequest);
        String result = "";
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)str)) {
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)str);
                Element el = doc.getRootElement();
                result = el.getText();
                logger.info("\u68a6\u7f51\u77ed\u4fe1\u53d1\u9001\u7ed3\u679c:[{}],\u624b\u673a\u53f7:[{}]", (Object)str, (Object)mobile);
            }
            catch (DocumentException e) {
                logger.error("", (Throwable)e);
            }
        }
        return org.apache.commons.lang.StringUtils.isEmpty((String)result) ? str : result;
    }

    private String renderString(String content, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> sets = map.entrySet();
        for (Map.Entry<String, Object> entry : sets) {
            String regex = "\\$\\{" + entry.getKey() + "}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(content);
            content = matcher.replaceAll(String.valueOf(entry.getValue()));
        }
        return content;
    }

    @Override
    public String getChannel() {
        return "mw";
    }

    @Override
    public BaseJsonVo getMongateBalance() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", this.mwSMSConfig.getUserId());
        params.put("password", this.mwSMSConfig.getPassword());
        HttpRequest httpRequest = new HttpRequest(this.mwSMSConfig.getBaseUrl() + "MongateQueryBalance", params);
        httpRequest.setMethod("POST");
        String str = HttpComponentUtil.execute((HttpRequest)httpRequest);
        String result = "";
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)str)) {
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)str);
                Element el = doc.getRootElement();
                result = el.getText();
                logger.info("\u68a6\u7f51\u4f59\u989d:[{}]", (Object)result);
            }
            catch (DocumentException e) {
                logger.error("", (Throwable)e);
            }
        }
        return BaseJsonVo.success((Object)result);
    }

    public int multiSend(List<MultiMt> multiMtList) {
        int returnInt;
        block6: {
            returnInt = ERROR_310099;
            try {
                StringBuffer msgId = new StringBuffer();
                int result = -310099;
                CHttpPost cHttpPost = new CHttpPost();
                String userid = this.mwSMSConfig.getUserId();
                String pwd = this.mwSMSConfig.getPassword();
                boolean isEncryptPwd = true;
                userid = userid.toUpperCase();
                String timestamp = null;
                if (isEncryptPwd) {
                    timestamp = sdf.format(Calendar.getInstance().getTime());
                    pwd = cHttpPost.encryptPwd(userid, pwd, timestamp);
                } else {
                    timestamp = null;
                }
                result = cHttpPost.multiSend(userid, pwd, timestamp, multiMtList, msgId);
                if (result == 0) {
                    System.out.println("\u4e2a\u6027\u5316\u7fa4\u53d1\u63d0\u4ea4\u6210\u529f\uff01");
                    System.out.println(msgId.toString());
                } else {
                    System.out.println("\u4e2a\u6027\u5316\u7fa4\u53d1\u63d0\u4ea4\u5931\u8d25,\u9519\u8bef\u7801\uff1a" + result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (returnInt == 0) break block6;
                returnInt = ERROR_310099;
            }
        }
        return returnInt;
    }

    public String encryptPwd(String userid, String pwd, String timestamp) {
        String encryptPwd = null;
        try {
            String passwordStr = userid.toUpperCase() + "00000000" + pwd + timestamp;
            encryptPwd = MWSmsSServiceImpl.getMD5Str(passwordStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptPwd;
    }

    private static String getMD5Str(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return md5StrBuff.toString();
    }

    private BaseJsonVo send2(Message message, boolean isEncryptPwd, String custid) {
        try {
            CHttpPost cHttpPost = new CHttpPost();
            message.setUserid(this.mwSMSConfig.getUserId().toUpperCase());
            if (isEncryptPwd) {
                String timestamp = sdf.format(Calendar.getInstance().getTime());
                message.setTimestamp(timestamp);
                String encryptPwd = cHttpPost.encryptPwd(message.getUserid().toUpperCase(), this.mwSMSConfig.getPassword(), message.getTimestamp());
                message.setPwd(encryptPwd);
            }
            logger.info("\u8981\u63a8\u9001\u7684\u5185\u5bb9:{}", (Object)message.getContent());
            message.setCustid(StringUtils.isEmpty((String)custid) ? RandomUtils.generateId() : custid);
            StringBuffer msgId = new StringBuffer();
            int result = -310099;
            result = cHttpPost.batchSend(message, msgId);
            if (result == 0) {
                logger.info("\u624b\u673a\u53f7:{}\u76f8\u540c\u5185\u5bb9\u53d1\u9001\u63d0\u4ea4\u6210\u529f", (Object)message.getMobile());
                return BaseJsonVo.success((Object)custid);
            }
            logger.error("\u76f8\u540c\u5185\u5bb9\u53d1\u9001\u63d0\u4ea4\u5931\u8d25,\u9519\u8bef\u7801\uff1a{}", (Object)result);
            return BaseJsonVo.error((String)("\u63a8\u9001\u5931\u8d25:" + result));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)("\u63a8\u9001\u5931\u8d25:" + ERROR_310099));
        }
    }
}

