/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sms.service.impl;

import cc.lechun.baseservice.model.sms.MessageContentDTO;
import cc.lechun.baseservice.model.sms.SendMessageVo;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.sms.exception.ChannelException;
import cc.lechun.sms.service.IChannelSMSService;
import cc.lechun.sms.service.IMessageService;
import cc.lechun.sms.service.impl.ChannelSMSServices;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements IMessageService {
    private static final Logger logger = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private ChannelSMSServices channelSMSServices;

    @Override
    public BaseJsonVo send(MessageContentDTO messageDto) {
        BaseJsonVo result;
        logger.info("\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1:{}", (Object)messageDto.toString());
        Iterator<IChannelSMSService> iterator = this.channelSMSServices.iterator();
        Integer retry = 0;
        while (true) {
            IChannelSMSService channelSMSService = iterator.next();
            String channel = channelSMSService.getChannel();
            try {
                result = channelSMSService.send(messageDto);
            }
            catch (ChannelException e) {
                logger.error("\u6e20\u9053\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                result = BaseJsonVo.error((String)e.getMessage());
                if (!iterator.hasNext()) continue;
                Integer n = retry;
                Integer n2 = retry = Integer.valueOf(retry + 1);
                if (iterator.hasNext()) continue;
            }
            break;
        }
        return result;
    }

    @Override
    public BaseJsonVo send(SendMessageVo message) {
        BaseJsonVo result;
        logger.info("\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1:{}", (Object)message.toString());
        Iterator<IChannelSMSService> iterator = this.channelSMSServices.iterator();
        Integer retry = 0;
        while (true) {
            IChannelSMSService channelSMSService = iterator.next();
            String channel = channelSMSService.getChannel();
            try {
                result = channelSMSService.send(message);
            }
            catch (ChannelException e) {
                logger.error("\u6e20\u9053\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                result = BaseJsonVo.error((String)e.getMessage());
                if (!iterator.hasNext()) continue;
                Integer n = retry;
                Integer n2 = retry = Integer.valueOf(retry + 1);
                if (iterator.hasNext()) continue;
            }
            break;
        }
        return result;
    }

    @Override
    public BaseJsonVo getMongateBalance() {
        BaseJsonVo result;
        logger.info("\u5f00\u59cb\u67e5\u8be2\u4f59\u989d:{}");
        Iterator<IChannelSMSService> iterator = this.channelSMSServices.iterator();
        Integer retry = 0;
        while (true) {
            IChannelSMSService channelSMSService = iterator.next();
            String channel = channelSMSService.getChannel();
            try {
                result = channelSMSService.getMongateBalance();
                logger.info("\u6e20\u9053:{},\u67e5\u8be2\u7ed3\u679c:{}", (Object)channel, (Object)result.toString());
            }
            catch (Exception e) {
                logger.error("\u6e20\u9053\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                result = BaseJsonVo.error((String)e.getMessage());
                if (!iterator.hasNext()) continue;
                Integer n = retry;
                Integer n2 = retry = Integer.valueOf(retry + 1);
                if (iterator.hasNext()) continue;
            }
            break;
        }
        return result;
    }

    @Override
    public BaseJsonVo send(String content, String mobile, String custid) {
        BaseJsonVo result;
        logger.info("\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1\u5185\u5bb9:{},\u624b\u673a\u53f7:{}", (Object)content, (Object)mobile);
        Iterator<IChannelSMSService> iterator = this.channelSMSServices.iterator();
        Integer retry = 0;
        while (true) {
            IChannelSMSService channelSMSService = iterator.next();
            String channel = channelSMSService.getChannel();
            try {
                result = channelSMSService.send(content, mobile, custid);
            }
            catch (ChannelException e) {
                logger.error("\u6e20\u9053\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                result = BaseJsonVo.error((String)e.getMessage());
                if (!iterator.hasNext()) continue;
                Integer n = retry;
                Integer n2 = retry = Integer.valueOf(retry + 1);
                if (iterator.hasNext()) continue;
            }
            break;
        }
        return result;
    }

    @Override
    public BaseJsonVo batchSend(String content, String mobileList, String custid) {
        BaseJsonVo result;
        logger.info("\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1\u5185\u5bb9:{},\u624b\u673a\u53f7:{}", (Object)content, (Object)mobileList);
        Iterator<IChannelSMSService> iterator = this.channelSMSServices.iterator();
        Integer retry = 0;
        while (true) {
            IChannelSMSService channelSMSService = iterator.next();
            String channel = channelSMSService.getChannel();
            try {
                result = channelSMSService.batchSend(content, mobileList, custid);
            }
            catch (ChannelException e) {
                logger.error("\u6e20\u9053\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                result = BaseJsonVo.error((String)e.getMessage());
                if (!iterator.hasNext()) continue;
                Integer n = retry;
                Integer n2 = retry = Integer.valueOf(retry + 1);
                if (iterator.hasNext()) continue;
            }
            break;
        }
        return result;
    }
}

