/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.bp.entity.spu.vo;

import cc.lechun.bp.entity.spu.SpuEntity;
import cc.lechun.bp.entity.spu.vo.SpuDetailVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpuVO
extends SpuEntity
implements Serializable {
    private Integer canExit;
    private List<SpuDetailVO> list;

    public SpuEntity copy() {
        SpuEntity target = new SpuEntity();
        BeanUtils.copyProperties((Object)this, (Object)target);
        return target;
    }

    public Integer getCanExit() {
        return this.canExit;
    }

    public void setCanExit(Integer canExit) {
        this.canExit = canExit;
    }

    public List<SpuDetailVO> getList() {
        return this.list;
    }

    public void setList(List<SpuDetailVO> list) {
        this.list = list;
    }

    public void sum() {
        if (null != this.list && !this.list.isEmpty()) {
            for (SpuDetailVO s : this.list) {
                if (null != s.getIsGift()) continue;
                s.setIsGift(1);
            }
            BigDecimal totalIamt = new BigDecimal(this.getPrice().doubleValue());
            BigDecimal totalPercent = new BigDecimal(1);
            for (int i = 0; i < this.list.size(); ++i) {
                SpuDetailVO d = this.list.get(i);
                if (null != d.getIsGift() && d.getIsGift() == 0) {
                    d.setPercent(new BigDecimal(0));
                    continue;
                }
                if (i < this.list.size() - 1) {
                    d.setPercent(d.getIamt().divide(totalIamt, 3, 4));
                    totalPercent = totalPercent.subtract(d.getPercent());
                    continue;
                }
                if (i != this.list.size() - 1) continue;
                d.setPercent(totalPercent);
                totalPercent = totalPercent.subtract(d.getPercent());
            }
        }
    }
}

