/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCashticketMapper;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.redpackage.RedpackageConfigDetailVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.vo.ActiveCashticketMessageVo;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.apiinvoke.active.CashInvoke;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveCashticketService
extends ActiveBaseService
implements ActiveCashticketInterface {
    @Autowired
    private ActiveCashticketMapper activeCashticketMapper;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private AccountBalanceInterface balanceService;
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    CashInvoke cashInvoke;

    @Override
    public Integer getCashticketTicketId(String bindCode, String customerId) {
        return this.cashticketCustomerService.getCashticketTicketId(bindCode, customerId);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=300)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType) {
        return this.activeCashticketMapper.getRedpackageConfigVoList(activeNo, activeType);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=300)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType, @ParameterValueKeyProvider(order=2) Integer shareCount) {
        List<RedpackageConfigDetailVo> list = this.getRedpackageConfigVoList(activeNo, activeType);
        if (list != null) {
            return list.stream().filter(c -> c.getUserType().intValue() == shareCount.intValue()).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getCashticketByBindCode")
    public List<ActiveCashticketVo> getSelectCashticketByBindCode(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getCashticketByBindCode(bindCode);
    }

    @Override
    public BaseJsonVo getCashticketListByBindCode(String bindCode) {
        return BaseJsonVo.success(this.activeCashticketMapper.getCashticketListByBindCode(bindCode));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getActiveCashticketList", expiration=300)
    public List<ActiveCashticketVo> getActiveCashticketList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer platFormId) {
        List<ActiveCashticketVo> list;
        Integer groupFormId = this.platFormService.getPlatFormGroupId(platFormId);
        if (StringUtils.isEmpty((String)bindCode) || "null".equals(bindCode)) {
            list = this.activeCashticketMapper.getActiveCashticketList4New(groupFormId);
        } else {
            list = this.activeCashticketMapper.getActiveCashticketList(bindCode, groupFormId);
            if (list.size() >= 1) {
                list.sort((v1, v2) -> {
                    if (v1.getCount() != null && v2.getCount() != null) {
                        return v2.getCount().compareTo(v1.getCount());
                    }
                    return 0;
                });
            }
        }
        return list;
    }

    @Override
    @Deprecated
    public BaseJsonVo sendTicket4CustomerType(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        CashticketBatchEntity cashticketBatchEntity;
        String tempBindCode;
        block7: {
            ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
            if (activeEntity == null || activeEntity.getActiveType() != 15) {
                return BaseJsonVo.error((String)"\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u65e0\u6548\u7684\u6d3b\u52a8");
            }
            List<ActiveQrcodeEntity> list = this.activeQrcodeService.getQrcodeList(bindCode);
            tempBindCode = "";
            if (list != null && list.size() >= 2) {
                int num = this.orderMainInterface.getOrderNum(customerId);
                try {
                    if (num == 0) {
                        tempBindCode = list.stream().filter(q -> q.getActiveType() == 1).findFirst().get().getBindCode();
                        break block7;
                    }
                    tempBindCode = list.stream().filter(q -> q.getActiveType() == 2).findFirst().get().getBindCode();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                tempBindCode = bindCode;
            }
        }
        BaseJsonVo vo = this.sendTicket4Base(customerId, tempBindCode, versionDetailId, platFormId, isSendMessage);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<ActiveCashticketVo> cashticketVoList = this.getSelectCashticketByBindCode(tempBindCode);
        if (cashticketVoList != null && cashticketVoList.size() > 0 && (cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(cashticketVoList.get(0).getTicketBatchId())) != null) {
            result.put("AMOUNT", cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() ? cashticketBatchEntity.getAmount() : cashticketBatchEntity.getDiscountAmount());
            result.put("REMARK", cashticketBatchEntity.getRemark());
            result.put("discountMode", cashticketBatchEntity.getDiscountMode());
        }
        vo.setValue(result);
        return vo;
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        return this.cashInvoke.sendCashticket(customerId, bindCode, 0.0, versionDetailId, platFormId, isSendMessage, isSendMessage);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog) {
        return this.cashInvoke.sendCashticket(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog, boolean checkActive) {
        return this.cashInvoke.sendCashticket(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog, checkActive);
    }

    @Override
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        this.cashInvoke.sendCashticketMq(customerId, bindCode, versionDetailId, platFormId, isSendMessage, isSendMessage);
    }

    @Override
    @Deprecated
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean checkActive) {
        ActiveCashticketMessageVo activeCashticketMessageVo = new ActiveCashticketMessageVo();
        activeCashticketMessageVo.setBindCode(bindCode);
        activeCashticketMessageVo.setOpenId("");
        activeCashticketMessageVo.setUserId(customerId);
        activeCashticketMessageVo.setVersionDetailId("");
        activeCashticketMessageVo.setSendMessage(isSendMessage);
        activeCashticketMessageVo.setPlatFormId(platFormId);
        activeCashticketMessageVo.setCheckActive(checkActive);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendActiveCashTicket, MessageParam.messageParam((String)customerId, (Object)activeCashticketMessageVo));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getBindCodeActiveCashticketList", expiration=300)
    public List<ActiveCashticketEntity> getBindCodeActiveCashticketList(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getBindCodeActiveCashticketList(bindCode);
    }

    @Override
    public BaseJsonVo deleteCouponConfig(Integer id) {
        ActiveCashticketEntity activeCashticketEntity = (ActiveCashticketEntity)this.activeCashticketMapper.selectByPrimaryKey(id);
        this.removeCache(activeCashticketEntity.getBindCode());
        int k = this.activeCashticketMapper.deleteByPrimaryKey(id);
        return k >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveCoupon(String listCashticket, String bindCode) {
        try {
            String items = URLDecoder.decode(listCashticket, "UTF-8");
            if (!items.startsWith("[")) {
                items = "[" + items + "]";
            }
            List list = JsonUtils.getListByArray(ActiveCashticketEntity.class, (String)items);
            this.removeCache(bindCode);
            this.activeCashticketMapper.deleteCashticketByBindCode(bindCode);
            list.forEach(c -> {
                c.setBindCode(bindCode);
                c.setTackType(2);
                this.logger.info(c.toString());
            });
            this.activeCashticketMapper.insertActiveCashticketBatch(list);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.logger.error("\u4fdd\u5b58\u7ed1\u5b9a\u4f18\u60e0\u5238\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteCouponConfigByBindCode(String bindCode) {
        this.removeCache(bindCode);
        this.activeCashticketMapper.deleteCashticketByBindCode(bindCode);
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(String bindCode) {
        this.memcachedService.delete("ActiveCashticketService.getBindCodeActiveCashticketList", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketByBindCode", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketListByBindCode", bindCode);
    }
}

