/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.check;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.service.check.ActiveOnLineCheckHandle;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActiveCheckOnlineContext {
    private final Map<String, ActiveOnLineCheckHandle> activeOnLineCheckHandle = new ConcurrentHashMap<String, ActiveOnLineCheckHandle>();
    @Autowired
    private ActiveInterface activeInterface;

    @Autowired
    public ActiveCheckOnlineContext(Map<String, ActiveOnLineCheckHandle> activeOnLineCheck) {
        this.activeOnLineCheckHandle.clear();
        activeOnLineCheck.forEach((k, v) -> this.activeOnLineCheckHandle.put((String)k, (ActiveOnLineCheckHandle)v));
    }

    public BaseJsonVo checkOnLine(String activeNo, Integer status) {
        ActiveOnLineCheckHandle activeOnLineCheck;
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(activeNo);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        if ((status == null || status == 0) && (activeOnLineCheck = this.activeOnLineCheckHandle.get("activeOnLineCheck_" + activeEntity.getActiveType())) != null) {
            BaseJsonVo baseJsonVo = activeOnLineCheck.checkOnLine(activeEntity);
            if (baseJsonVo.isSuccess()) {
                return this.setActiveOnline(activeNo, status);
            }
            return baseJsonVo;
        }
        return this.setActiveOnline(activeNo, status);
    }

    private BaseJsonVo setActiveOnline(String activeNo, Integer status) {
        ActiveEntity update = new ActiveEntity();
        update.setActiveNo(activeNo);
        update.setStatus(status == null || status == 0 ? 1 : 0);
        return this.activeInterface.setOnline(update);
    }
}

