/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.refund;

import cc.lechun.active.entity.groupon.GrouponRefundOrderVo;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.active.service.groupon.GrouponMessageContext;
import cc.lechun.active.service.groupon.GrouponMessageHandle;
import cc.lechun.active.service.refund.ActiveRefundBase;
import cc.lechun.active.service.refund.ActiveRefundHandle;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="refund_23")
public class TeamBuyRefundHandle
extends ActiveRefundBase
implements ActiveRefundHandle {
    @Autowired
    private GrouponInterface grouponInterface;
    @Autowired
    private GrouponMessageContext grouponMessageContext;

    @Override
    public BaseJsonVo refund(Date date) {
        List<GrouponRefundOrderVo> list = this.grouponInterface.getUnRefundApplyOrders(date);
        if (list != null && list.size() >= 1) {
            list.forEach(c -> {
                MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(c.getOrderMainNo());
                if (orderMainEntity != null && orderMainEntity.getStatus() == 2) {
                    BaseJsonVo baseJsonVo = this.refundApply(c.getOrderMainNo(), "\u56e2\u8d2d\u62fc\u56e2\u8d85\u65f6\u9000");
                    if (baseJsonVo.isSuccess()) {
                        this.logger.info("\u7533\u8bf7\u9000\u6b3e\u6210\u529f: orderNo:{}", (Object)c.getOrderMainNo());
                        MallRefundEntity refundEntity = (MallRefundEntity)baseJsonVo.getValue();
                        baseJsonVo = this.payRefundCheck(refundEntity.getRefundId());
                        if (baseJsonVo.isSuccess()) {
                            this.grouponInterface.updateGrouponOrderStatus((GrouponRefundOrderVo)c);
                            this.logger.info("\u9000\u6b3e\u5ba1\u6838\u6210\u529f: orderNo:{}", (Object)c.getOrderMainNo());
                            GrouponMessageHandle grouponMessageHandle = this.grouponMessageContext.getGrouponMessageHanle(orderMainEntity.getPlatformId());
                            if (grouponMessageHandle != null) {
                                grouponMessageHandle.joinGrouponNoticeFail((GrouponRefundOrderVo)c);
                            }
                        } else {
                            this.logger.info("\u9000\u6b3e\u5931\u8d25: orderNo:{},message={}", (Object)c.getOrderMainNo(), (Object)baseJsonVo.getMessage());
                        }
                    } else {
                        this.logger.info("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25: orderNo:{},message={}", (Object)c.getOrderMainNo(), (Object)baseJsonVo.getMessage());
                    }
                } else {
                    this.logger.info("\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u8ba2\u5355\u4e0d\u80fd\u9000\u6b3e: orderNo:{},status:{}", (Object)c.getOrderMainNo(), (Object)orderMainEntity.getStatus());
                }
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo refund(String orderMainNo, String refundReason) {
        return BaseJsonVo.error((String)("\u56e2\u8d2d\u4e0d\u652f\u6301\u6839\u636e\u8ba2\u5355\u53f7\u9000\u6b3e[" + orderMainNo + "]"));
    }
}

