/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.common.tree.TreeBuilder;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.item.IndexNavMapper;
import cc.lechun.mall.entity.common.MallTreeVo;
import cc.lechun.mall.entity.item.IndexNavEntity;
import cc.lechun.mall.entity.item.IndexNavVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.item.MallIndexNavInterface;
import cc.lechun.mall.iservice.item.MallPageConfigInterface;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallIndexNavService
extends BaseService
implements MallIndexNavInterface {
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private IndexNavMapper indexNavMapper;
    @Autowired
    private PlatFormGroupInterface platFormGroupInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallIndexItemInterface indexItemInterface;
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MallPageConfigInterface pageConfigInterface;

    @Override
    @ReadThroughSingleCache(namespace="IndexNavtree", expiration=300)
    public List<MallTreeVo> getIndexNavTree(@ParameterValueKeyProvider Integer platformGroupId) {
        List<PlatFormEntity> platFormEntities;
        List<Object> platFormGroupEntities = new ArrayList();
        ArrayList<MallTreeVo> mallTreeVos = new ArrayList<MallTreeVo>();
        if (platformGroupId == 0) {
            platFormGroupEntities = this.platFormGroupInterface.getValidPlatFormGroupList();
            platFormEntities = this.platFormInterface.getValidPlatFormList4All();
        } else {
            platFormEntities = this.platFormInterface.getValidPlatFormList(platformGroupId);
            platFormGroupEntities.add(this.platFormGroupInterface.getPlatFormGroup(platformGroupId));
        }
        if (platFormGroupEntities != null && platFormGroupEntities.size() > 0 && platFormEntities != null && platFormEntities.size() > 0) {
            for (PlatFormGroupEntity platFormGroupEntity : platFormGroupEntities) {
                MallTreeVo treeVo = new MallTreeVo();
                treeVo.setId(String.valueOf(platFormGroupEntity.getPlatformGroupId()));
                treeVo.setName(platFormGroupEntity.getPlatformGroupName());
                treeVo.setRemark(platFormGroupEntity.getPlatformGroupDesc());
                treeVo.setpId("");
                mallTreeVos.add(treeVo);
                for (PlatFormEntity p : platFormEntities) {
                    treeVo = new MallTreeVo();
                    treeVo.setId(String.valueOf(p.getPlatformId()));
                    treeVo.setName(p.getPlatformName());
                    treeVo.setRemark(p.getPlatformDesc());
                    treeVo.setpId(String.valueOf(platFormGroupEntity.getPlatformGroupId()));
                    treeVo.setLeaf(1);
                    mallTreeVos.add(treeVo);
                }
            }
        }
        return TreeBuilder.builder(mallTreeVos);
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavList", expiration=3600)
    public List<IndexNavEntity> getIndexNavList(@ParameterValueKeyProvider Integer platformId) {
        IndexNavEntity indexNavEntity = new IndexNavEntity();
        indexNavEntity.setPlatformId(platformId);
        List indexNavEntities = this.indexNavMapper.getList(indexNavEntity);
        if (indexNavEntities != null && indexNavEntities.size() > 0) {
            indexNavEntities.sort((f1, f2) -> f1.getNavSn().compareTo(f2.getNavSn()));
        }
        return indexNavEntities;
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavEntity", expiration=3600)
    public IndexNavEntity getIndexNav(@ParameterValueKeyProvider String navId) {
        return (IndexNavEntity)this.indexNavMapper.selectByPrimaryKey((Serializable)((Object)navId));
    }

    @Override
    public BaseJsonVo saveIndexNav(IndexNavEntity indexNavEntity) {
        int count = 0;
        indexNavEntity.setNavTerminal(String.valueOf(indexNavEntity.getPlatformId()));
        if (indexNavEntity.getIndexNavId() == null || indexNavEntity.getIndexNavId().isEmpty()) {
            indexNavEntity.setIndexNavId(IDGenerate.getUniqueIdStr());
            count = this.indexNavMapper.insertSelective(indexNavEntity);
        } else {
            count = this.indexNavMapper.updateByPrimaryKeySelective(indexNavEntity);
        }
        if (count > 0) {
            this.removeCache(indexNavEntity.getIndexNavId(), indexNavEntity.getPlatformId());
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo deleteIndexNav(String indexNavId) {
        IndexNavEntity indexNavEntity = (IndexNavEntity)this.indexNavMapper.selectByPrimaryKey((Serializable)((Object)indexNavId));
        if (indexNavId != null) {
            this.removeCache(indexNavId, indexNavEntity.getPlatformId());
        }
        if (this.indexNavMapper.deleteByPrimaryKey((Serializable)((Object)indexNavId)) == 1) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo buildModulePage(Integer platformId, String ruleJson) {
        List navVos;
        BaseJsonVo baseJsonVo = this.indexItemInterface.getIndexNavProductList(platformId, "", 0);
        int platformGroupId = this.platFormInterface.getPlatFormGroupId(platformId);
        StringBuilder indexNavModule = new StringBuilder();
        StringBuilder navModule = new StringBuilder();
        HashMap<String, StringBuilder> itemModule = new HashMap<String, StringBuilder>();
        HashMap<Integer, StringBuilder> detailListMap = new HashMap<Integer, StringBuilder>();
        if (baseJsonVo.isSuccess() && (navVos = (List)baseJsonVo.getValue()) != null && navVos.size() > 0) {
            baseJsonVo = this.pageConfigInterface.buildIndexPage(platformId);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            for (IndexNavVo navVo : navVos) {
                baseJsonVo = this.pageConfigInterface.buildIndexNavModule(navVo);
                if (!baseJsonVo.isSuccess()) {
                    this.logger.error(baseJsonVo.getMessage());
                    return baseJsonVo;
                }
                indexNavModule.append(baseJsonVo.getValue().toString());
                indexNavModule.append("\r\n");
                baseJsonVo = this.pageConfigInterface.buildNavModule(navVo);
                if (!baseJsonVo.isSuccess()) {
                    this.logger.error(baseJsonVo.getMessage());
                    return baseJsonVo;
                }
                navModule.append(baseJsonVo.getValue().toString());
                navModule.append("\r\n");
                baseJsonVo = this.pageConfigInterface.buildItemModule(navVo, detailListMap);
                if (!baseJsonVo.isSuccess()) {
                    this.logger.error(baseJsonVo.getMessage());
                    return baseJsonVo;
                }
                itemModule.put(navVo.getIndexNavId(), (StringBuilder)baseJsonVo.getValue());
                baseJsonVo = this.pageConfigInterface.buildItemDetailModule(navVo);
                if (baseJsonVo.isSuccess()) continue;
                this.logger.error(baseJsonVo.getMessage());
                return baseJsonVo;
            }
            String indexNavModuleFile = "indexnav_" + platformId + ".html";
            String navModuleFile = "nav_" + platformId + ".html";
            baseJsonVo = this.pageConfigInterface.savePageFile(platformId, indexNavModule.toString(), indexNavModuleFile, 0);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            baseJsonVo = this.pageConfigInterface.savePageFile(platformId, navModule.toString(), navModuleFile, 0);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            for (String indexNavId : itemModule.keySet()) {
                String itemModuleFile = "item_" + platformId + "_" + indexNavId + ".html";
                baseJsonVo = this.pageConfigInterface.savePageFile(platformId, ((StringBuilder)itemModule.get(indexNavId)).toString(), itemModuleFile, 0);
                if (baseJsonVo.isSuccess()) continue;
                return baseJsonVo;
            }
            for (Integer itemType : detailListMap.keySet()) {
                String detailListItemFile = "detailList_" + platformId + "_" + itemType + ".html";
                baseJsonVo = this.pageConfigInterface.savePageFile(platformId, ((StringBuilder)detailListMap.get(itemType)).toString(), detailListItemFile, 0);
                if (baseJsonVo.isSuccess()) continue;
                return baseJsonVo;
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexEnableNavList", expiration=3600)
    public List<IndexNavEntity> getEnableIndexNavList(@ParameterValueKeyProvider Integer platformId) {
        List<IndexNavEntity> indexItemEntities = this.getIndexNavList(platformId);
        if (indexItemEntities != null && indexItemEntities.size() > 0) {
            return indexItemEntities.stream().filter(c -> c.getIsShow() == 1).collect(Collectors.toList());
        }
        indexItemEntities.sort((c1, c2) -> c1.getNavSn().compareTo(c2.getNavSn()));
        return indexItemEntities;
    }

    @Override
    public void removeCache(String indexNavId, int platformId) {
        this.memcachedService.delete("IndexNavEntity", String.valueOf(indexNavId));
        this.memcachedService.delete("IndexNavList", String.valueOf(platformId));
        this.memcachedService.delete("IndexEnableNavList", String.valueOf(platformId));
    }
}

