/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.user;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.user.MallResourceGroupMapper;
import cc.lechun.mall.dao.user.MallResourceGroupRelationMapper;
import cc.lechun.mall.dao.user.MallResourceGroupUserMapper;
import cc.lechun.mall.dao.user.MallResourceMapper;
import cc.lechun.mall.entity.user.MallResourceEntity;
import cc.lechun.mall.entity.user.MallResourceGroupEntity;
import cc.lechun.mall.entity.user.MallResourceGroupRelationEntity;
import cc.lechun.mall.entity.user.MallResourceGroupUserEntity;
import cc.lechun.mall.iservice.user.SysResourceInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysResourceService
implements SysResourceInterface {
    @Autowired
    private MallResourceMapper mallResourceMapper;
    @Autowired
    private MallResourceGroupMapper mallResourceGroupMapper;
    @Autowired
    private MallResourceGroupUserMapper mallResourceGroupUserMapper;
    @Autowired
    private MallResourceGroupRelationMapper mallResourceGroupRelationMapper;

    @Override
    public BaseJsonVo saveMallResource(MallResourceEntity mallResourceEntity) {
        BaseJsonVo rs = this.valid(mallResourceEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        this.mallResourceMapper.insertSelective(mallResourceEntity);
        return rs;
    }

    @Override
    public BaseJsonVo updateMallResource(MallResourceEntity mallResourceEntity) {
        BaseJsonVo rs = this.valid(mallResourceEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        this.mallResourceMapper.updateByPrimaryKeySelective(mallResourceEntity);
        return rs;
    }

    @Override
    public PageInfo getMallParentResourceList(int pageNum, int pageSize, String resourceName, Integer resourceType, Integer roleId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallResourceMapper.getMallParentResourceList(resourceName, resourceType, roleId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public PageInfo getMallleafResourceList(int pageNum, int pageSize, int resourceParentId, Integer roleId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallResourceMapper.getMallleafResourceList(resourceParentId, roleId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    private BaseJsonVo valid(MallResourceEntity mallResourceEntity) {
        if (StringUtil.isEmpty((String)mallResourceEntity.getResourceName())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u8d44\u6e90\u540d\u79f0");
        }
        if (mallResourceEntity.getResourceType() == null || mallResourceEntity.getResourceType() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u8d44\u6e90\u7c7b\u578b");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getResourceGroupList(Integer pageNum, Integer pageSize, Integer resourceId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallResourceGroupMapper.getPageList(resourceId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public BaseJsonVo getResourceGroupUsers(Integer groupId) {
        MallResourceGroupUserEntity param = new MallResourceGroupUserEntity();
        param.setGroupId(groupId);
        return BaseJsonVo.success((Object)this.mallResourceGroupUserMapper.getList(param));
    }

    @Override
    public BaseJsonVo saveResourceGroup(MallResourceGroupEntity mallResourceGroupEntity) {
        if (mallResourceGroupEntity.getGroupId() != null) {
            MallResourceGroupEntity origin = (MallResourceGroupEntity)this.mallResourceGroupMapper.selectByPrimaryKey(mallResourceGroupEntity.getGroupId());
            if (mallResourceGroupEntity.getGroupType() != origin.getGroupType()) {
                this.mallResourceGroupUserMapper.deleteByGroupId(mallResourceGroupEntity.getGroupId());
            }
            return BaseJsonVo.success((Object)this.mallResourceGroupMapper.updateByPrimaryKey(mallResourceGroupEntity));
        }
        return BaseJsonVo.success((Object)this.mallResourceGroupMapper.insert(mallResourceGroupEntity));
    }

    @Override
    @Transactional
    public BaseJsonVo saveResourceGroupUser(Integer groupId, String[] userIds) {
        this.mallResourceGroupUserMapper.deleteByGroupId(groupId);
        for (String userId : userIds) {
            MallResourceGroupUserEntity entity = new MallResourceGroupUserEntity();
            entity.setGroupId(groupId);
            entity.setUserId(userId);
            this.mallResourceGroupUserMapper.insert(entity);
        }
        return BaseJsonVo.success(null);
    }

    @Override
    @Transactional
    public BaseJsonVo saveResourceGroupRelations(Integer groupId, String[] relations) {
        this.mallResourceGroupRelationMapper.deleteByGroupId(groupId);
        for (String visibleGroupId : relations) {
            if (StringUtils.isEmpty((String)visibleGroupId)) continue;
            MallResourceGroupRelationEntity entity = new MallResourceGroupRelationEntity();
            entity.setGroupId(groupId);
            entity.setVisibleGroupId(Integer.valueOf(visibleGroupId));
            this.mallResourceGroupRelationMapper.insert(entity);
        }
        return BaseJsonVo.success(null);
    }

    @Override
    @Transactional
    public BaseJsonVo delResourceGroup(Integer groupId) {
        this.mallResourceGroupMapper.deleteByPrimaryKey(groupId);
        this.mallResourceGroupUserMapper.deleteByGroupId(groupId);
        this.mallResourceGroupRelationMapper.deleteByGroupId(groupId);
        return BaseJsonVo.success(null);
    }

    @Override
    public Set<String> findAssociateUsers(String userId, Integer resourceId) {
        return this.mallResourceGroupUserMapper.findAssociateUsers(userId, resourceId);
    }

    @Override
    public Set<String> findAssociateGroupUsers(String userId, Integer resourceId) {
        return this.mallResourceGroupUserMapper.findAssociateGroupUsers(userId, resourceId);
    }

    @Override
    public MallResourceEntity getResourceWithPath(String resourcePath) {
        MallResourceEntity param = new MallResourceEntity();
        param.setResourceHtmlUrl(resourcePath);
        List list = this.mallResourceMapper.getList(param);
        if (list != null && list.size() > 0) {
            return (MallResourceEntity)list.get(0);
        }
        return null;
    }

    @Override
    public List<MallResourceGroupEntity> getAllResourceGroups(Integer resourceId) {
        MallResourceGroupEntity param = new MallResourceGroupEntity();
        param.setResourceId(resourceId);
        return this.mallResourceGroupMapper.getList(param);
    }

    @Override
    public List<MallResourceGroupRelationEntity> getResourceVisibleGroups(Integer resourceId, Integer groupId) {
        MallResourceGroupRelationEntity param = new MallResourceGroupRelationEntity();
        param.setGroupId(groupId);
        return this.mallResourceGroupRelationMapper.getList(param);
    }
}

