/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.groupon.GrouponOrderVo;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="activeType_23")
public class TeamBuyHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Autowired
    @Lazy
    private GrouponInterface grouponService;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        List tt;
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setCustomerId(customerId);
        orderMainEntity.setBindCode(bindCode);
        List<MallOrderMainEntity> list = this.orderMainInterface.getOrderMainList(orderMainEntity);
        if (list != null && list.size() >= 1 && (tt = list.stream().filter(c -> c.getStatus() == 1).collect(Collectors.toList())) != null && tt.size() >= 1) {
            return BaseJsonVo.error((String)"\u5b58\u5728\u5f85\u652f\u4ed8\u8ba2\u5355");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        String orderMainNo = mainOrderVo.getMainOrderNo();
        GrouponOrderVo grouponOrderVo = new GrouponOrderVo();
        grouponOrderVo.setOrderMainNo(mainOrderVo.getMainOrderNo());
        grouponOrderVo.setCustomerId(mainOrderVo.getCustomerId());
        grouponOrderVo.setPlatFormId(mainOrderVo.getPlatFormId());
        grouponOrderVo.setStatus(OrderStatusEnum.UNPAY.getValue());
        grouponOrderVo.setBindCode(orderCacheVo.getBindCode());
        try {
            Integer type = this.grouponService.getGrouponType(orderCacheVo.getBindCode());
            if (type == 2) {
                MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
                orderMainEntity.setOrderClass(18);
                orderMainEntity.setOrderMainNo(mainOrderVo.getMainOrderNo());
                boolean temp = this.orderMainInterface.updateOrderMain(orderMainEntity);
                this.logger.info("\u4fee\u6539\u8ba2\u5355{}\u975e\u5b9e\u7269\u7c7b\u578b{}", (Object)mainOrderVo.getMainOrderNo(), (Object)temp);
            }
            if (StringUtils.isNotEmpty((String)mainOrderVo.getMallOrderVos().get(0).getDefineField())) {
                this.logger.info("\u63a5\u53d7:json:{}", (Object)mainOrderVo.getMallOrderVos().get(0).getDefineField());
                String inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId").toString();
                if (StringUtils.isNotEmpty((String)inviteId)) {
                    grouponOrderVo.setInviteId(inviteId);
                    grouponOrderVo.setGrouponRoleType(2);
                    String startOrderKey = mainOrderVo.getMainOrderNo() + ":StartGroupon";
                    this.memcachedService.set("", startOrderKey, (Object)inviteId, 86400);
                    this.grouponService.saveGrouponOrder(grouponOrderVo);
                }
            } else {
                this.logger.info("mainOrderVo.getMallOrderVos().get(0).getDefineField() \u4e3a\u7a7a, \u8ba2\u5355\u53f7{}", (Object)mainOrderVo.getMainOrderNo());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain) {
        this.logger.info("\u56e2\u8d2d\u8ba2\u5355:{}", (Object)orderMain.getOrderMainNo());
        this.grouponService.saveGrouponOrder(orderMain);
        return BaseJsonVo.success((Object)"");
    }
}

