/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.file;

import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.ids.UuidUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.config.AliOssVo;
import cc.lechun.mall.entity.image.ImageTypeEntity;
import cc.lechun.mall.iservice.config.ConfigInterface;
import cc.lechun.mall.iservice.image.ImageInterface;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.github.pagehelper.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OssService {
    private static final Logger log = LoggerFactory.getLogger(OssService.class);
    @Autowired
    private ConfigInterface configInterface;
    @Autowired
    private ImageInterface imageInterface;

    public BaseJsonVo uploadFileNew(int platformGroupId, int typeId, String fileName, String content) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
            BaseJsonVo.paramError((String)"\u65e0\u6548\u6587\u4ef6");
        }
        return this.uploadFileNew(platformGroupId, typeId, fileName, inputStream);
    }

    public BaseJsonVo uploadFileNew(int platformGroupId, int typeId, String fileName, InputStream is) {
        ImageTypeEntity imageTypeEntity;
        String path;
        if (is == null) {
            BaseJsonVo.paramError((String)"\u65e0\u6548\u6587\u4ef6");
        }
        if (platformGroupId == 0) {
            BaseJsonVo.paramError((String)"\u65e0\u6548\u5206\u7ec4");
        }
        if (StringUtils.isEmpty((String)fileName)) {
            BaseJsonVo.paramError((String)"\u65e0\u6548\u6587\u4ef6\u540d\u79f0");
        }
        if ((path = (imageTypeEntity = this.imageInterface.getImageType(typeId)).getTypePath()).contains("$date")) {
            path = path.replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd"));
        }
        String key = platformGroupId + "/" + path + "/";
        if (fileName.toLowerCase().endsWith("html")) {
            key = key + fileName;
        } else {
            String suffix = fileName.substring(fileName.indexOf("."));
            key = key + UuidUtil.get32UUID() + suffix;
        }
        AliOssVo aliOssVo = this.configInterface.getAliOssVo();
        OSSClient ossClient = new OSSClient(aliOssVo.getEndpoint(), aliOssVo.getAccessKeyId(), aliOssVo.getAccessKeySecret());
        ossClient.putObject(aliOssVo.getBucketName(), key, is);
        ossClient.shutdown();
        return BaseJsonVo.success((Object)key);
    }

    public void uploadFile(String key, InputStream is) {
        AliOssVo aliOssVo = this.configInterface.getAliOssVo();
        OSSClient ossClient = new OSSClient(aliOssVo.getEndpoint(), aliOssVo.getAccessKeyId(), aliOssVo.getAccessKeySecret());
        ossClient.putObject(aliOssVo.getBucketName(), key, is);
        ossClient.shutdown();
    }

    public String uploadFile(AliyunOSSDir dir, String fileName, String content) {
        String url = "";
        try {
            ByteArrayInputStream in_withcode = new ByteArrayInputStream(content.getBytes("UTF-8"));
            return this.uploadFile(dir, fileName, in_withcode);
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
            return url;
        }
    }

    public String uploadFile(AliyunOSSDir dir, String fileName, InputStream is) {
        if (StringUtils.isEmpty((String)fileName) || is == null) {
            return "";
        }
        String path = dir.getPath();
        if (path.contains("$date")) {
            path = path.replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd"));
        }
        this.uploadFile(path + fileName, is);
        return path + fileName;
    }

    public Map<String, Object> getFile(String key) {
        HashMap<String, Object> fileRecord = new HashMap<String, Object>();
        AliOssVo aliOssVo = this.configInterface.getAliOssVo();
        try {
            OSSClient ossClient = new OSSClient(aliOssVo.getEndpoint(), aliOssVo.getAccessKeyId(), aliOssVo.getAccessKeySecret());
            OSSObject ossObject = ossClient.getObject(aliOssVo.getBucketName(), key);
            fileRecord.put("ContentType", ossObject.getObjectMetadata().getContentType());
            fileRecord.put("ContentLength", ossObject.getObjectMetadata().getContentLength());
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int rc = 0;
            InputStream in = ossObject.getObjectContent();
            while ((rc = in.read(buf, 0, buf.length)) > 0) {
                swapStream.write(buf, 0, rc);
            }
            byte[] fileBytes = swapStream.toByteArray();
            fileRecord.put("FileBytes", fileBytes);
            in.close();
            ossObject.getObjectContent().close();
            ossClient.shutdown();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            e.printStackTrace();
        }
        return fileRecord;
    }

    public String getImageResoure() {
        try {
            String temp = this.configInterface.getAliOssVo().getOssPrefix();
            String[] arr = temp.split(",");
            int result = Math.abs(RandomUtils.generateStrId().hashCode()) % arr.length;
            return arr[result];
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "http://resource.lechun.cc/";
        }
    }

    public String getImageResoure(String path) {
        if (path == null) {
            return "";
        }
        try {
            String temp = this.configInterface.getAliOssVo().getOssPrefix();
            String[] arr = temp.split(",");
            int result = Math.abs(path.hashCode()) % arr.length;
            String url = arr[result];
            url = url.endsWith("/") && path.startsWith("/") ? url.substring(0, url.length() - 1) + path : (!url.endsWith("/") && !path.startsWith("/") ? url + "/" + path : url + path);
            return url;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "http://resource.lechun.cc/" + path;
        }
    }

    public String removeUrlDomain(String url) {
        try {
            URL u = new URL(url);
            return u.getPath();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return url;
        }
    }

    public String getDefaultImage() {
        return this.getImageResoure("1000/imgStorage/dfd118058b4847d3b93f08ff15dd2738.png");
    }

    public String getImageResoure(String path, Integer useDefaultImage) {
        if (StringUtil.isEmpty((String)path) && Integer.valueOf(1).equals(useDefaultImage)) {
            return this.getDefaultImage();
        }
        return this.getImageResoure(path);
    }
}

