/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.config;

import cc.lechun.framework.core.common.SecurityFilter;
import javax.sql.DataSource;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@EnableAspectJAutoProxy(exposeProxy=true)
@ComponentScan(basePackages={"cc.lechun"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value={SecurityFilter.class})})
public class ServiceConfig {
    @Autowired
    @Qualifier(value="writeDataSource")
    private DataSource writeDataSource;
    @Autowired
    private cc.lechun.framework.core.quartz.JobFactory jobFactory;
    @Value(value="${quartz.SchedulerName}")
    private String schedulerName;
    @Value(value="${quartz.isEnable}")
    private String quartzEnable;

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        if (this.quartzEnable.equals("1")) {
            schedulerFactoryBean.setDataSource(this.writeDataSource);
            schedulerFactoryBean.setSchedulerName(this.schedulerName);
            schedulerFactoryBean.setApplicationContextSchedulerContextKey("applicationContextKey");
            schedulerFactoryBean.setConfigLocation((Resource)new ClassPathResource("/quartz.properties"));
            schedulerFactoryBean.setJobFactory((JobFactory)this.jobFactory);
        }
        return schedulerFactoryBean;
    }
}

