/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.wechatpay;

import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.service.pay.wechatpay.entity.H5Info;
import cc.lechun.mall.service.pay.wechatpay.entity.PayInfo;
import cc.lechun.mall.service.pay.wechatpay.entity.SceneInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;

public class WechatPayCommon {
    public static PayInfo createPayInfo(PayInputEntity inputEntity) {
        PayInfo payInfo = new PayInfo();
        payInfo.setPay_type_sub_id(inputEntity.getPaySubType());
        payInfo.setPayKey(inputEntity.getPayKey());
        payInfo.setAppid(inputEntity.getAppId());
        payInfo.setMch_id(inputEntity.getMchId());
        payInfo.setDevice_info("WEB");
        payInfo.setNonce_str(WechatPayCommon.createNonceStr());
        payInfo.setBody(inputEntity.getBody());
        payInfo.setTrade_type(inputEntity.getTradeType());
        SceneInfo sceneInfo = new SceneInfo();
        H5Info h5_info = new H5Info();
        h5_info.setType("");
        sceneInfo.setH5_info(h5_info);
        h5_info.setWap_name(inputEntity.getAppName());
        h5_info.setWap_url(inputEntity.getDomain());
        payInfo.setScene_info(sceneInfo);
        payInfo.setAttach(inputEntity.getOrderMainNo());
        payInfo.setOut_trade_no(inputEntity.getTradeNo());
        payInfo.setTotal_fee(PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).intValue());
        payInfo.setSpbill_create_ip(inputEntity.getIp());
        payInfo.setNotify_url(inputEntity.getNotifyUrl());
        payInfo.setOpenid(inputEntity.getOpenId());
        payInfo.setTime_start(DateUtils.formatDate((Date)inputEntity.getOrderCreateTime(), (String)"yyyyMMddHHmmss"));
        payInfo.setTime_expire(DateUtils.formatDate((Date)inputEntity.getOrderCancelTime(), (String)"yyyyMMddHHmmss"));
        return payInfo;
    }

    public static String createNonceStr() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getCreateOrderSign(PayInfo payInfo) {
        SortedMap map = ObjectConvert.objectConvertToSortedMap((Object)payInfo);
        if (payInfo.getPay_type_sub_id() != PaySubTypeEnum.WECHAT_SUB_PAY.getValue() && payInfo.getPay_type_sub_id() != PaySubTypeEnum.WECHAT_SUB_MINI_PAY.getValue()) {
            map.remove("openid");
        }
        if (payInfo.getPay_type_sub_id() != PaySubTypeEnum.WECHAT_SUB_WAP_PAY.getValue()) {
            map.remove("scene_info");
        }
        return WechatPayCommon.createSign(map, payInfo.getPayKey());
    }

    public static String createSign(SortedMap<String, String> packageParams, String payKey) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (v == null) {
                v = "";
            }
            if (null == v || "sign".equals(k) || "".equals(v) || "key".equals(k) || "pay_type_sub_id".equals(k) || "payKey".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + payKey);
        String sign = MD5.sign((String)sb.toString()).toUpperCase();
        return sign;
    }

    public static String getCreateOrderRequestBody(PayInfo payInfo) {
        String sign = WechatPayCommon.getCreateOrderSign(payInfo);
        String openId = payInfo.getPay_type_sub_id() == PaySubTypeEnum.WECHAT_SUB_PAY.getValue() || payInfo.getPay_type_sub_id() == PaySubTypeEnum.WECHAT_SUB_MINI_PAY.getValue() ? "<openid>" + payInfo.getOpenid() + "</openid>" : "";
        String sceneInfo = payInfo.getPay_type_sub_id() == PaySubTypeEnum.WECHAT_SUB_WAP_PAY.getValue() ? "<scene_info>" + JsonUtils.toJson((Object)payInfo.getScene_info(), (boolean)false) + "</scene_info>" : "";
        String xml = "<xml><appid>" + payInfo.getAppid() + "</appid><mch_id>" + payInfo.getMch_id() + "</mch_id><nonce_str>" + payInfo.getNonce_str() + "</nonce_str><sign>" + sign + "</sign><body><![CDATA[" + payInfo.getBody() + "]]></body><attach>" + payInfo.getAttach() + "</attach><out_trade_no>" + payInfo.getOut_trade_no() + "</out_trade_no><total_fee>" + payInfo.getTotal_fee() + "</total_fee><spbill_create_ip>" + payInfo.getSpbill_create_ip() + "</spbill_create_ip><notify_url>" + payInfo.getNotify_url() + "</notify_url><trade_type>" + payInfo.getTrade_type() + "</trade_type>" + openId + "<device_info>" + payInfo.getDevice_info() + "</device_info><time_expire>" + payInfo.getTime_expire() + "</time_expire><time_start>" + payInfo.getTime_start() + "</time_start>" + sceneInfo + "</xml>";
        return xml;
    }
}

