/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.domain;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.organization.dao.OrgQuestionClassTimeoutMapper;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutEntity;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutSpecialCaseEntity;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutVO;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.idomain.IOrgQuestionClassTimeoutDomain;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.OrgQuestionClassTimeoutInterface;
import cc.lechun.organization.iservice.OrgQuestionClassTimeoutSpecialCaseInterface;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgQuestionClassTimeoutDomain
implements IOrgQuestionClassTimeoutDomain {
    @Autowired
    OrgQuestionClassTimeoutInterface timeoutInterface;
    @Autowired
    OrgQuestionClassTimeoutMapper timeoutMapper;
    @Autowired
    OrgQuestionClassTimeoutSpecialCaseInterface specialCaseInterface;
    @Autowired
    IPeriodService periodService;

    @Override
    public BaseJsonVo<OrgQuestionClassTimeoutVO> isEdit(PaperEntity paper, String userId, Integer classSubType) {
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(paper.getPeriodId());
        return this.isEdit(periodEntity, paper.getQuestionClassId(), userId, classSubType);
    }

    @Override
    public BaseJsonVo<OrgQuestionClassTimeoutVO> isEdit(PeriodEntity period, Integer questionClassId, String userId, Integer classSubType) {
        OrgQuestionClassTimeoutVO returnValue = new OrgQuestionClassTimeoutVO();
        OrgQuestionClassTimeoutEntity param = new OrgQuestionClassTimeoutEntity();
        param.setQuestionClassId(questionClassId);
        param.setQuestionClassSubType(classSubType);
        OrgQuestionClassTimeoutEntity timeout = (OrgQuestionClassTimeoutEntity)this.timeoutInterface.getSingle(param);
        if (timeout == null) {
            returnValue.build(period);
            if (DateUtils.now().after(period.getPeriodStart()) && DateUtils.now().before(DateUtils.getAddDateByDay((Date)period.getPeriodEnd(), (int)1))) {
                return BaseJsonVo.success((Object)returnValue);
            }
            BaseJsonVo error = BaseJsonVo.error();
            error.setValue((Object)returnValue);
            return error;
        }
        OrgQuestionClassTimeoutSpecialCaseEntity specialParam = new OrgQuestionClassTimeoutSpecialCaseEntity();
        specialParam.setTimeoutId(timeout.getId());
        specialParam.setUserId(userId);
        if (this.specialCaseInterface.existsByEntity(specialParam) > 0) {
            returnValue.buildForever(period);
            return BaseJsonVo.success((Object)returnValue);
        }
        if (returnValue.build(period, timeout).booleanValue()) {
            return BaseJsonVo.success((Object)returnValue);
        }
        BaseJsonVo error = BaseJsonVo.error();
        error.setValue((Object)returnValue);
        return error;
    }

    @Override
    public OrgQuestionClassTimeoutEntity getTimeout(Integer classId, Integer subType) {
        OrgQuestionClassTimeoutEntity param = new OrgQuestionClassTimeoutEntity();
        param.setQuestionClassId(classId);
        param.setQuestionClassSubType(subType);
        return (OrgQuestionClassTimeoutEntity)this.timeoutInterface.getSingle(param);
    }

    @Override
    public void save(OrgQuestionClassTimeoutEntity entity) {
        if (entity != null) {
            if (entity.getId() != null && entity.getId() != 0) {
                this.timeoutInterface.updateByPrimaryKey(entity);
            } else {
                this.timeoutInterface.insert(entity);
            }
        }
    }

    @Override
    @Transactional
    public void batchSaveSpecialCase(Integer timeoutId, String[] userIds) {
        this.specialCaseInterface.deleteByTimeoutId(timeoutId);
        for (String userId : userIds) {
            if (StringUtils.isEmpty((String)userId)) continue;
            OrgQuestionClassTimeoutSpecialCaseEntity entity = new OrgQuestionClassTimeoutSpecialCaseEntity();
            entity.setTimeoutId(timeoutId);
            entity.setUserId(userId);
            this.specialCaseInterface.insert(entity);
        }
    }
}

