/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerVo;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.iservice.IOrgUserInterviewService;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OrgUserInterviewService
extends BaseService
implements IOrgUserInterviewService {
    @Autowired
    private OssService ossService;
    @Autowired
    private IOrgPaperAnswerDomain paperAnswerService;

    @Override
    public BaseJsonVo getFilePath(Integer typeId, MultipartFile[] file) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        try {
            ArrayList fileUrlArray = new ArrayList();
            for (MultipartFile f : file) {
                String filePathUrl = "";
                String fileName = "";
                String allFileUrl = "";
                fileName = new String(f.getOriginalFilename().getBytes(), "UTF-8");
                BaseJsonVo rs = this.ossService.uploadFileNew(1000, (int)typeId, fileName, f.getInputStream());
                HashMap<String, String> fileMap = new HashMap<String, String>();
                if (!rs.isSuccess()) continue;
                filePathUrl = rs.getValue().toString();
                allFileUrl = this.ossService.getImageResoure(filePathUrl);
                fileMap.put("name", fileName);
                fileMap.put("url", allFileUrl);
                fileUrlArray.add(fileMap);
            }
            this.logger.info("=======OrgUserInterviewService====fileUrlArray={}", (Object)JSON.toJSONString(fileUrlArray));
            baseJsonVo.setValue(fileUrlArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo downFile(PaperAnswerVo paperAnswerVo) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        Object fileUrlArray = null;
        String allFileUrl = "";
        PaperAnswerEntity paperAnswerEntity = this.paperAnswerService.queryPaperAnswerBy(paperAnswerVo);
        if (paperAnswerEntity != null) {
            allFileUrl = this.ossService.getImageResoure(paperAnswerEntity.getAnswer());
            baseJsonVo.setValue((Object)allFileUrl);
        }
        return baseJsonVo;
    }
}

