/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveIndexMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveIndexEntity;
import cc.lechun.active.entity.active.ActiveIndexVo;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveIndexService
extends BaseService<ActiveIndexEntity, Integer>
implements ActiveIndexInterface {
    @Resource
    private ActiveIndexMapper activeIndexMapper;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductPicInterface picInterface;

    @Override
    public PageInfo<ActiveIndexVo> getActiveIndexList(PageForm pageForm, Integer platformGroupId) {
        ActiveIndexEntity activeIndexEntity = new ActiveIndexEntity();
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy(" SORT ");
        List list = this.activeIndexMapper.getList(activeIndexEntity);
        List<Object> userGroupVos = new ArrayList();
        if (list != null && list.size() > 0) {
            userGroupVos = list.stream().map(activeIndex -> {
                ActiveIndexVo activeIndexVo = new ActiveIndexVo();
                BeanUtils.copyProperties((Object)activeIndex, (Object)activeIndexVo);
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(activeIndex.getActiveNo());
                activeIndexVo.setActiveName(StringUtils.isNotEmpty((String)activeEntity.getActiveName()) ? activeEntity.getActiveName() : "");
                return activeIndexVo;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(userGroupVos);
        return pg;
    }

    @Override
    public BaseJsonVo saveActiveIndex(ActiveIndexEntity activeIndexEntity) {
        if (activeIndexEntity.getActiveIndexId() == null || activeIndexEntity.getActiveIndexId() == 0) {
            ActiveIndexEntity query = new ActiveIndexEntity();
            query.setActiveNo(activeIndexEntity.getActiveNo());
            List list = this.activeIndexMapper.getList(query);
            if (list.size() >= 1) {
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25!\u8be5\u6d3b\u52a8\u5df2\u914d\u7f6e\u5728\u5217\u8868\u9875\u4e2d");
            }
            return this.activeIndexMapper.insert(activeIndexEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        ActiveIndexEntity query = new ActiveIndexEntity();
        if (StringUtils.isNotEmpty((String)activeIndexEntity.getActiveNo())) {
            query.setActiveNo(activeIndexEntity.getActiveNo());
            ActiveIndexEntity temp = (ActiveIndexEntity)this.activeIndexMapper.getSingle(query);
            if (temp != null && temp.getActiveIndexId().intValue() != activeIndexEntity.getActiveIndexId().intValue()) {
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25!\u8be5\u6d3b\u52a8\u5df2\u914d\u7f6e\u5728\u5217\u8868\u9875\u4e2d");
            }
        }
        return this.activeIndexMapper.updateByPrimaryKeySelective(activeIndexEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }
}

