/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.gift;

import cc.lechun.active.dao.active.GiftMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.GiftDetailEntity;
import cc.lechun.active.entity.active.GiftEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.GiftDetailInterface;
import cc.lechun.active.iservice.active.GiftInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.constants.message.CustomerMessageConstants;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.MessageAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.message.message.TextMessage;

@Service
public class GiftService
extends BaseService
implements GiftInterface {
    @Autowired
    private GiftMapper giftMapper;
    @Autowired
    private GiftDetailInterface giftDetailInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;

    @Override
    public boolean insertEntity(GiftEntity giftEntity) {
        return this.giftMapper.insertSelective(giftEntity) != 0;
    }

    @Override
    @Transactional
    public BaseJsonVo createGift(MallMainOrderVo mainOrderVo) {
        String message = "";
        String toName = "";
        String toContent = "";
        String fromName = "";
        try {
            GiftEntity giftEntity = new GiftEntity();
            giftEntity.setAnswer("");
            giftEntity.setCreateTime(DateUtils.now());
            giftEntity.setFromName(fromName);
            giftEntity.setFromUserId(mainOrderVo.getCustomerId());
            giftEntity.setGiftId(IDGenerate.getUniqueIdStr());
            giftEntity.setOrderMainNo(mainOrderVo.getMainOrderNo());
            giftEntity.setStatus(0);
            giftEntity.setTackTime(null);
            giftEntity.setToContent(toContent);
            giftEntity.setToName(toName);
            giftEntity.setToUserId("");
            giftEntity.setUsedTime(null);
            if (!this.insertEntity(giftEntity)) {
                message = "\u4fdd\u5b58\u793c\u54c1\u8868\u5f02\u5e38";
                throw new RuntimeException();
            }
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                GiftDetailEntity giftDetailEntity;
                if (orderVo.getProducts() != null && orderVo.getProducts().size() > 0) {
                    for (MallProductVO mallProductVO : orderVo.getProducts()) {
                        giftDetailEntity = new GiftDetailEntity();
                        giftDetailEntity.setGiftDetailId(IDGenerate.getUniqueIdStr());
                        giftDetailEntity.setGiftId(giftEntity.getGiftId());
                        giftDetailEntity.setGroupId("");
                        giftDetailEntity.setProductId(mallProductVO.getProId());
                        giftDetailEntity.setProductType(SalesTypeEnum.SALES_PRODUCT.getValue());
                        giftDetailEntity.setStatus(-1);
                        giftDetailEntity.setProductName(mallProductVO.getProName());
                        giftDetailEntity.setQuantity(mallProductVO.getCount());
                        giftDetailEntity.setAmount(mallProductVO.getFactPrice());
                        giftDetailEntity.setPromotionDetailId("");
                        if (this.giftDetailInterface.insertEntity(giftDetailEntity)) continue;
                        message = "\u4fdd\u5b58\u793c\u54c1\u660e\u7ec6\u8868\u5f02\u5e38";
                        throw new RuntimeException();
                    }
                }
                if (orderVo.getGroups() != null && orderVo.getGroups().size() > 0) {
                    for (MallGroupVO mallGroupVO : orderVo.getGroups()) {
                        giftDetailEntity = new GiftDetailEntity();
                        giftDetailEntity.setGiftDetailId(IDGenerate.getUniqueIdStr());
                        giftDetailEntity.setGiftId(giftEntity.getGiftId());
                        giftDetailEntity.setGroupId(mallGroupVO.getGroupId());
                        giftDetailEntity.setProductId("");
                        giftDetailEntity.setProductType(SalesTypeEnum.SALES_GROUP.getValue());
                        giftDetailEntity.setStatus(-1);
                        giftDetailEntity.setProductName(mallGroupVO.getGroupName());
                        giftDetailEntity.setQuantity(mallGroupVO.getCount());
                        giftDetailEntity.setAmount(mallGroupVO.getFactPrice());
                        giftDetailEntity.setPromotionDetailId("");
                        if (this.giftDetailInterface.insertEntity(giftDetailEntity)) continue;
                        message = "\u4fdd\u5b58\u793c\u54c1\u660e\u7ec6\u8868\u5f02\u5e38";
                        throw new RuntimeException();
                    }
                }
                if (orderVo.getPromotions() == null || orderVo.getPromotions().size() <= 0) continue;
                for (MallPromotionVO mallPromotionVO : orderVo.getPromotions()) {
                    giftDetailEntity = new GiftDetailEntity();
                    giftDetailEntity.setGiftDetailId(IDGenerate.getUniqueIdStr());
                    giftDetailEntity.setGiftId(giftEntity.getGiftId());
                    giftDetailEntity.setGroupId(mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getGroupId() : "");
                    giftDetailEntity.setProductId("");
                    giftDetailEntity.setProductType(SalesTypeEnum.SALES_PROMOTION.getValue());
                    giftDetailEntity.setStatus(-1);
                    giftDetailEntity.setProductName(mallPromotionVO.getProduct() != null ? mallPromotionVO.getProduct().getProName() : "");
                    giftDetailEntity.setQuantity(mallPromotionVO.getCount());
                    giftDetailEntity.setAmount(mallPromotionVO.getFactPrice());
                    MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProduct(mallPromotionVO.getPromotionId(), mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getGroupId() : mallPromotionVO.getProduct().getProId());
                    giftDetailEntity.setPromotionDetailId(promotionProduct != null ? promotionProduct.getPromotionProductId() : "");
                    if (this.giftDetailInterface.insertEntity(giftDetailEntity)) continue;
                    message = "\u4fdd\u5b58\u793c\u54c1\u660e\u7ec6\u8868\u5f02\u5e38";
                    throw new RuntimeException();
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error("\u6dfb\u52a0\u793c\u54c1\u8868\u5f02\u5e38" + e.getMessage());
        }
        if (message.isEmpty()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)message);
    }

    public BaseJsonVo sendPaySuccessCustomerMessage(String orderMainNo) {
        String customerId;
        CustomerDetailVo customerDetailVo;
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity != null && (customerDetailVo = this.customerInterface.getCustomerDetail(customerId = orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId())) != null) {
            String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(orderMainEntity.getPlatformId());
            String content = CustomerMessageConstants.getOrderPlanPaySuccessContent((String)orderMainNo, (int)orderMainEntity.getPlatformId());
            TextMessage textMessage = new TextMessage(customerDetailVo.getOpenId(), content);
            BaseResult baseResult = MessageAPI.messageCustomSend((String)accessToken, (Message)textMessage);
            if (baseResult.isSuccess()) {
                return BaseJsonVo.success((Object)"");
            }
        }
        return BaseJsonVo.error((String)"\u53d1\u9001\u5931\u8d25");
    }

    @Override
    public BaseJsonVo validatePleaseYoghourt(String promotionId, int itemType, int quantity) {
        if (itemType != SalesTypeEnum.SALES_PROMOTION.getValue()) {
            return BaseJsonVo.error((String)"\u9500\u552e\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        MallPromotionEntity promotionEntity = this.promotionInterface.getPromotion(promotionId);
        if (promotionEntity == null) {
            return BaseJsonVo.error((String)"\u4fc3\u9500\u4e0d\u5b58\u5728");
        }
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(promotionEntity.getActiveNo());
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (!this.activeInterface.checkActiveEnable(activeEntity).isSuccess()) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        if (activeEntity.getActiveType() != 3) {
            return BaseJsonVo.error((String)"\u4e0d\u662f\u8bf7\u9178\u5976\u6d3b\u52a8");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveGiftMessage(String customerId, String orderMainNo, String toName, String fromName, String toContent) {
        if (toName.length() > 50) {
            return BaseJsonVo.error((String)"\u8d60\u9001\u4eba\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50");
        }
        if (toContent.length() > 200) {
            return BaseJsonVo.error((String)"\u8d60\u8bed\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e200");
        }
        if (toContent.length() == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u586b\u5199\u8d60\u8bed");
        }
        if (fromName.length() == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u586b\u5199\u7b7e\u540d");
        }
        if (fromName.length() > 50) {
            return BaseJsonVo.error((String)"\u7b7e\u540d\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50");
        }
        GiftEntity giftEntity = new GiftEntity();
        giftEntity.setFromUserId(customerId);
        giftEntity.setOrderMainNo(orderMainNo);
        giftEntity = (GiftEntity)this.giftMapper.getSingle(giftEntity);
        if (giftEntity == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9178\u5976\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (giftEntity.getStatus() == 0 || giftEntity.getStatus() == 1) {
            giftEntity.setToName(toName);
            giftEntity.setToContent(toContent);
            giftEntity.setFromName(fromName);
            int i = this.giftMapper.updateByPrimaryKeySelective(giftEntity);
            if (i == 1) {
                return BaseJsonVo.success((Object)"");
            }
        }
        return BaseJsonVo.error((String)"\u8bf7\u9178\u5976\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }

    @Override
    public BaseJsonVo getBuyGiftList(String customerId, String orderMainNo) {
        GiftEntity giftEntity = new GiftEntity();
        giftEntity.setFromUserId(customerId);
        giftEntity.setOrderMainNo(orderMainNo);
        giftEntity.setStatus(1);
        giftEntity = (GiftEntity)this.giftMapper.getSingle(giftEntity);
        if (giftEntity == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9178\u5976\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List<GiftDetailEntity> giftDetailEntityList = this.giftDetailInterface.getGiftDetailEntityList(giftEntity.getGiftId());
        if (giftDetailEntityList == null || giftDetailEntityList.size() == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u9178\u5976\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ArrayList maps = new ArrayList();
        for (GiftDetailEntity g : giftDetailEntityList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("giftId", giftEntity.getGiftId());
            map.put("toName", giftEntity.getToName());
            map.put("toContent", giftEntity.getToContent());
            map.put("fromName", giftEntity.getFromName());
            map.put("cretaeTime", DateUtils.formatDate((Date)giftEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            map.put("tackTime", DateUtils.formatDate((Date)giftEntity.getTackTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            map.put("giftDetailId", g.getGiftDetailId());
            map.put("usedTime", DateUtils.formatDate((Date)g.getUsedTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            map.put("status", String.valueOf(g.getStatus()));
            map.put("productName", g.getProductName());
            map.put("quantity", String.valueOf(g.getQuantity()));
            map.put("productType", String.valueOf(g.getProductType()));
            maps.add(map);
        }
        return BaseJsonVo.success(maps);
    }
}

