/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.dingding;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiDepartmentListRequest;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.request.OapiReportListRequest;
import com.dingtalk.api.request.OapiReportTemplateListbyuseridRequest;
import com.dingtalk.api.request.OapiUserGetRequest;
import com.dingtalk.api.request.OapiUserListbypageRequest;
import com.dingtalk.api.response.OapiDepartmentListResponse;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.dingtalk.api.response.OapiReportListResponse;
import com.dingtalk.api.response.OapiReportTemplateListbyuseridResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.dingtalk.api.response.OapiUserListbypageResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DingdingUtils {
    @Value(value="${dingding.appkey}")
    private String appkey;
    @Value(value="${dingding.appsecret}")
    private String appsecret;
    @Value(value="${dingding.agentId}")
    private String cmsAgentId;
    @Autowired
    private RedisService redisService;

    public BaseJsonVo<String> getAccessToken() {
        String accessToken;
        String redisKey = "dingding_" + this.appkey + this.appsecret;
        Object o = this.redisService.get(redisKey);
        String string = accessToken = o != null ? o.toString() : "";
        if (StringUtils.isEmpty((String)accessToken)) {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
            OapiGettokenRequest request = new OapiGettokenRequest();
            request.setAppkey(this.appkey);
            request.setAppsecret(this.appsecret);
            request.setHttpMethod("GET");
            try {
                OapiGettokenResponse response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
                if (response != null) {
                    accessToken = response.getAccessToken();
                    this.redisService.save(redisKey, accessToken, 7000L);
                }
            }
            catch (ApiException e) {
                e.printStackTrace();
                return BaseJsonVo.error((String)e.getMessage());
            }
        }
        return BaseJsonVo.success((Object)accessToken);
    }

    private BaseJsonVo<List<OapiUserListbypageResponse.Userlist>> getUsers(Long deptId, Long offset, Long size) {
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/listbypage");
        OapiUserListbypageRequest request = new OapiUserListbypageRequest();
        request.setDepartmentId(deptId);
        request.setOffset(offset);
        request.setSize(size);
        request.setOrder("entry_desc");
        request.setHttpMethod("GET");
        try {
            OapiUserListbypageResponse execute = (OapiUserListbypageResponse)client.execute((TaobaoRequest)request, accessToken);
            if (execute.isSuccess()) {
                return BaseJsonVo.success((Object)execute.getUserlist());
            }
            return BaseJsonVo.error((String)execute.getErrmsg());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u7528\u6237\u5217\u8868\u5f02\u5e38");
        }
    }

    public BaseJsonVo<OapiUserGetResponse> getUser(String userId) {
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/get");
        OapiUserGetRequest request = new OapiUserGetRequest();
        request.setUserid(userId);
        request.setHttpMethod("GET");
        try {
            OapiUserGetResponse response = (OapiUserGetResponse)client.execute((TaobaoRequest)request, accessToken);
            if (response.isSuccess()) {
                return BaseJsonVo.success((Object)response);
            }
            return BaseJsonVo.error((String)response.getErrmsg());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u7528\u6237\u5f02\u5e38");
        }
    }

    public List<OapiUserListbypageResponse.Userlist> getAllUsers() {
        BaseJsonVo<List<OapiDepartmentListResponse.Department>> depts = this.getDepts();
        ArrayList<OapiUserListbypageResponse.Userlist> users = new ArrayList<OapiUserListbypageResponse.Userlist>();
        if (depts.isSuccess()) {
            for (OapiDepartmentListResponse.Department d : (List)depts.getValue()) {
                boolean isEnd = false;
                long offset = 0L;
                while (!isEnd) {
                    BaseJsonVo<List<OapiUserListbypageResponse.Userlist>> jsonVo = this.getUsers(d.getId(), offset, 100L);
                    if (jsonVo.isSuccess()) {
                        offset += 100L;
                        if (((List)jsonVo.getValue()).size() > 0) {
                            users.addAll((Collection)jsonVo.getValue());
                            continue;
                        }
                        isEnd = true;
                        continue;
                    }
                    isEnd = true;
                }
            }
        }
        return users;
    }

    public BaseJsonVo<List<OapiDepartmentListResponse.Department>> getDepts() {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/department/list");
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        OapiDepartmentListRequest request = new OapiDepartmentListRequest();
        request.setId("1");
        request.setFetchChild(Boolean.valueOf(true));
        request.setHttpMethod("GET");
        try {
            OapiDepartmentListResponse response = (OapiDepartmentListResponse)client.execute((TaobaoRequest)request, accessToken);
            return BaseJsonVo.success((Object)response.getDepartment());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u90e8\u95e8\u5217\u8868\u5f02\u5e38");
        }
    }

    private BaseJsonVo<OapiReportListResponse.PageVo> getReport(String templateName, Date sdate, Date edate, Long cursor, String dingdingId) {
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/report/list");
        OapiReportListRequest request = new OapiReportListRequest();
        request.setStartTime(Long.valueOf(sdate.getTime()));
        request.setEndTime(Long.valueOf(edate.getTime()));
        request.setTemplateName(templateName);
        if (StringUtils.isNotEmpty((String)dingdingId)) {
            request.setUserid(dingdingId);
        }
        request.setCursor(cursor);
        request.setSize(Long.valueOf(20L));
        try {
            OapiReportListResponse response = (OapiReportListResponse)client.execute((TaobaoRequest)request, accessToken);
            if (!response.isSuccess()) {
                return BaseJsonVo.error((String)response.getErrmsg());
            }
            return BaseJsonVo.success((Object)response.getResult());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u65e5\u5fd7\u5217\u8868\u5f02\u5e38");
        }
    }

    public BaseJsonVo<List<OapiReportListResponse.ReportOapiVo>> getReport(String templateName, Date sdate, Date edate, String dingdingId) {
        ArrayList rtn = new ArrayList();
        long cursor = 0L;
        boolean hasMore = true;
        while (hasMore) {
            BaseJsonVo<OapiReportListResponse.PageVo> jsonVo = this.getReport(templateName, sdate, edate, cursor, dingdingId);
            if (jsonVo.isSuccess()) {
                OapiReportListResponse.PageVo pageVo = (OapiReportListResponse.PageVo)jsonVo.getValue();
                hasMore = pageVo == null ? false : pageVo.getHasMore();
                long l = cursor = pageVo == null ? 0L : pageVo.getNextCursor();
                if (pageVo == null) continue;
                rtn.addAll(pageVo.getDataList());
                continue;
            }
            hasMore = false;
            cursor = 0L;
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        return BaseJsonVo.success(rtn);
    }

    public BaseJsonVo<OapiReportTemplateListbyuseridResponse.HomePageReportTemplateVo> getReportTemplate() {
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/report/template/listbyuserid");
        OapiReportTemplateListbyuseridRequest req = new OapiReportTemplateListbyuseridRequest();
        req.setOffset(Long.valueOf(0L));
        req.setSize(Long.valueOf(100L));
        try {
            OapiReportTemplateListbyuseridResponse rsp = (OapiReportTemplateListbyuseridResponse)client.execute((TaobaoRequest)req, accessToken);
            if (rsp.isSuccess()) {
                return BaseJsonVo.success((Object)rsp.getResult());
            }
            return BaseJsonVo.error((String)rsp.getErrmsg());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u65e5\u5fd7\u6a21\u677f\u5f02\u5e38");
        }
    }

    private BaseJsonVo send(String dingdingId, OapiMessageCorpconversationAsyncsendV2Request.Msg msg) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2");
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
        request.setUseridList(dingdingId);
        request.setAgentId(Long.valueOf(this.cmsAgentId));
        request.setToAllUser(Boolean.valueOf(false));
        request.setMsg(msg);
        try {
            OapiMessageCorpconversationAsyncsendV2Response response = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)request, accessToken);
            if (response.isSuccess()) {
                return BaseJsonVo.success((Object)response.getTaskId());
            }
            return BaseJsonVo.error((String)response.getMsg());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u53d1\u9001\u5f02\u5e38");
        }
    }

    public BaseJsonVo sendTextMessage(String dingdingId, String content) {
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        msg.setMsgtype("text");
        msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
        msg.getText().setContent(content);
        return this.send(dingdingId, msg);
    }

    public BaseJsonVo sendOAMessage(String dingdingId, String title, String content) {
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        msg.setOa(new OapiMessageCorpconversationAsyncsendV2Request.OA());
        msg.getOa().setHead(new OapiMessageCorpconversationAsyncsendV2Request.Head());
        msg.getOa().getHead().setBgcolor("FFF79709");
        msg.getOa().setBody(new OapiMessageCorpconversationAsyncsendV2Request.Body());
        msg.getOa().getBody().setContent(content);
        msg.getOa().getBody().setTitle(title);
        msg.getOa().setPcMessageUrl("http://cms.lechun.cc");
        msg.getOa().setMessageUrl("http://cms.lechun.cc");
        msg.setMsgtype("oa");
        return this.send(dingdingId, msg);
    }

    public BaseJsonVo sendActionCardMessage(String dingdingId, String title, String content) {
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        msg.setActionCard(new OapiMessageCorpconversationAsyncsendV2Request.ActionCard());
        msg.getActionCard().setTitle(title);
        msg.getActionCard().setMarkdown(content);
        msg.getActionCard().setSingleTitle("\u67e5\u770b\u8be6\u60c5");
        msg.getActionCard().setSingleUrl("http://cms.lechun.cc");
        msg.setMsgtype("action_card");
        return this.send(dingdingId, msg);
    }
}

