/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.login;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.common.EnvironmentEnum;
import cc.lechun.common.enums.common.ServerEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.web.ResponseUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.alibaba.fastjson.JSON;
import java.net.InetAddress;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LoginInterceptor.class);
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private RedisService redisService;
    @Value(value="${lechun.environment}")
    private String environment;

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        String urlPrint = httpServletRequest.getRequestURI().substring(1);
        if ("index/health".equals(urlPrint)) {
            return true;
        }
        String uid = IDGenerate.getUniqueIdStr();
        try {
            httpServletResponse.setHeader("X-Application-Context", "application");
            InetAddress address = IpUtil.getLocalHostLANAddress();
            if (address != null) {
                String lc = ServerEnum.getServerTag(address.getHostName());
                httpServletResponse.setHeader("lc", lc);
            }
            if (!EnvironmentEnum.LOCAL.getValue().equals(this.environment)) {
                String url = httpServletRequest.getRequestURI().substring(1);
                int platformId = this.customerLoginService.getPlatFormId();
                logger.info("\u670d\u52a1\u767b\u9646\u9a8c\u8bc1cms,url={},platformId={}", (Object)url, (Object)platformId);
                PlatFormAndGroupVo platFormAndGroupVo = new PlatFormAndGroupVo();
                platformId = 1;
                if (this.redisService.get("LOGIN_PLATFROMGROUPVO") != null) {
                    platFormAndGroupVo = (PlatFormAndGroupVo)this.redisService.get("LOGIN_PLATFROMGROUPVO");
                } else {
                    platFormAndGroupVo.setPlatformId(1);
                    platFormAndGroupVo.setPlatformName("\u4e50\u7eaf\u5fae\u4fe1\u5546\u57ce");
                    platFormAndGroupVo.setPlatformDesc("\u4e50\u7eaf\u5fae\u4fe1\u5546\u57ce");
                    platFormAndGroupVo.setPlatformType(1);
                    platFormAndGroupVo.setPlatformGroupId(1000);
                    platFormAndGroupVo.setStatus(1);
                    platFormAndGroupVo.setCreateTime(DateUtils.StrToDate((String)"2018-01-12 14:49:57", (String)""));
                    platFormAndGroupVo.setApiPath("");
                    platFormAndGroupVo.setWebPath("/home/lechun/web/wechatweb/");
                    platFormAndGroupVo.setDomainPage("https://wx.lechun.cc");
                    platFormAndGroupVo.setDomainServer("https://mallapi.lechun.cc/");
                    platFormAndGroupVo.setPlatformGroupName("\u4e50\u7eaf");
                    platFormAndGroupVo.setPlatformGroupDesc("\u4e50\u7eaf\u9178\u5976");
                    platFormAndGroupVo.setGroupStatus(1);
                    this.redisService.save("LOGIN_PLATFROMGROUPVO", platFormAndGroupVo, 1800L);
                }
                List ls = null;
                if (this.redisService.get("LOGIN_WHITE_IP_LIST_35") != null) {
                    ls = (List)this.redisService.get("LOGIN_WHITE_IP_LIST_35");
                } else {
                    ls = this.dictionaryInterface.getValidDictionaryList(platFormAndGroupVo.getPlatformGroupId(), 35).stream().map(dictionaryEntity -> dictionaryEntity.getDictionaryName()).collect(Collectors.toList());
                    this.redisService.save("LOGIN_WHITE_IP_LIST_35", ls, 1800L);
                }
                logger.info("****preHandle********ls*************ls={},url={}", (Object)JSON.toJSONString((Object)ls), (Object)url);
                if (!ls.contains(url)) {
                    String testId = (String)this.redisService.get("lechun_testId");
                    logger.info("****preHandle********testId*************testId={}", (Object)testId);
                    if (testId == null || !httpServletRequest.getParameter("testId").equals(testId)) {
                        String rurl = httpServletRequest.getHeader("referer");
                        logger.info("****preHandle********rurl*************rurl={}", (Object)rurl);
                        if (rurl == null || rurl.isEmpty()) {
                            ResponseUtils.writeCorsJsonDate((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Object)new BaseJsonVo(40001, "\u9a8c\u8bc1\u5931\u8d25\uff01"));
                            return false;
                        }
                        if (this.redisService.get("LOGIN_WHITE_IP_LIST_37") != null) {
                            ls = (List)this.redisService.get("LOGIN_WHITE_IP_LIST_37");
                        } else {
                            ls = this.dictionaryInterface.getValidDictionaryList(platFormAndGroupVo.getPlatformGroupId(), 37).stream().map(dictionaryEntity -> dictionaryEntity.getDictionaryName()).collect(Collectors.toList());
                            this.redisService.save("LOGIN_WHITE_IP_LIST_37", ls, 1800L);
                        }
                        boolean isExistsDomain = false;
                        for (String str : ls) {
                            if (!rurl.contains(str)) continue;
                            isExistsDomain = true;
                            break;
                        }
                        if (!isExistsDomain) {
                            ResponseUtils.writeCorsJsonDate((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Object)new BaseJsonVo(40001, "\u9a8c\u8bc1\u5931\u8d25\uff01"));
                            return false;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u62e6\u622a\u8bf7\u6c42\u9a8c\u8bc1\u5931\u8d251:" + urlPrint + ";uid=" + uid + ";", (Throwable)e);
            ResponseUtils.writeCorsJsonDate((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Object)BaseJsonVo.error());
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

