/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerAdCookieMapper;
import cc.lechun.mall.entity.customer.CustomerAdCookieEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.customer.CustomerAdCookieInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.AdWechatAPI;
import weixin.popular.bean.advertisement.AdSourceResult;

@Service
public class CustomerAdCookieService
extends BaseService<CustomerAdCookieEntity, Integer>
implements CustomerAdCookieInterface {
    @Resource
    private CustomerAdCookieMapper customerAdCookieMapper;
    @Autowired
    private WeiXinBaseService weiWinBaseService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    RedisService redisService;

    @Override
    public BaseJsonVo<Boolean> createDatasource(Integer platformId, Integer platformGroupId, String name, String description) {
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(platformId);
        WeiXinBaseEntity weiXinBaseEntity = this.weiWinBaseService.getAccessTokenByPlatformId(platformId);
        if (StringUtils.isNotEmpty((String)accessToken)) {
            String type = platformId == 1 ? "WECHAT" : (platformId == 4 ? "WECHAT_MINI_PROGRAM" : "");
            AdSourceResult adSourceResult = AdWechatAPI.createDatasource((String)accessToken, (String)weiXinBaseEntity.getAppid(), (String)type, (String)name, (String)description);
            this.logger.info("\u521b\u5efa\u5e7f\u544a\u6570\u636e\u6e90:{}", adSourceResult.getErrcode().equals("0") ? adSourceResult.getData().getUser_action_set_id() : "\u5931\u8d25");
            List<DictionaryEntity> list = this.dictionaryInterface.getValidDictionaryList(platformGroupId, 212);
            DictionaryEntity dictionaryEntity = new DictionaryEntity();
            if (list.size() > 0) {
                dictionaryEntity = list.get(list.size() - 1);
                dictionaryEntity.setDictionaryKey(adSourceResult.getData().getUser_action_set_id().toString());
                dictionaryEntity.setDictionaryName(name);
                dictionaryEntity.setRemark((StringUtils.isNotEmpty((String)type) ? type : "") + "/" + (StringUtils.isNotEmpty((String)description) ? description : ""));
                short s = (short)(dictionaryEntity.getSort().intValue() + 1);
                dictionaryEntity.setSort(s);
                dictionaryEntity.setDictionaryTypeId(212);
                dictionaryEntity.setPlatformGroupId(platformGroupId);
            } else {
                dictionaryEntity.setDictionaryKey(adSourceResult.getData().getUser_action_set_id().toString());
                dictionaryEntity.setDictionaryName(name);
                dictionaryEntity.setRemark((StringUtils.isNotEmpty((String)type) ? type : "") + "/" + (StringUtils.isNotEmpty((String)description) ? description : ""));
                dictionaryEntity.setSort((short)1);
                dictionaryEntity.setDictionaryTypeId(212);
                dictionaryEntity.setPlatformGroupId(platformGroupId);
            }
            this.dictionaryInterface.saveDictionary(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey(), dictionaryEntity.getDictionaryName(), dictionaryEntity.getSort().shortValue(), dictionaryEntity.getRemark());
            return BaseJsonVo.success((Object)adSourceResult.getData().getUser_action_set_id().toString());
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5e73\u53f0");
    }

    @Override
    public BaseJsonVo getAdSourceList(Integer platformGroupId) {
        List<DictionaryEntity> list = this.dictionaryInterface.getValidDictionaryList(platformGroupId, 212);
        ArrayList<AdSourceVo> result = new ArrayList<AdSourceVo>();
        if (list.size() > 0) {
            for (DictionaryEntity dictionaryEntity : list) {
                AdSourceVo adSourceVo = new AdSourceVo();
                adSourceVo.setAdUrl("&adFlag=" + dictionaryEntity.getDictionaryKey());
                adSourceVo.setDescription(StringUtils.isNotEmpty((String)dictionaryEntity.getRemark()) ? dictionaryEntity.getRemark().split("/")[1] : "");
                adSourceVo.setType(StringUtils.isNotEmpty((String)dictionaryEntity.getRemark()) ? dictionaryEntity.getRemark().split("/")[0] : "");
                adSourceVo.setSourceId(Integer.valueOf(dictionaryEntity.getDictionaryKey()));
                adSourceVo.setName(dictionaryEntity.getDictionaryName());
                adSourceVo.setSourceId(Integer.valueOf(dictionaryEntity.getDictionaryKey()));
                adSourceVo.setRemark("\u5982\u679c\u6295\u653e\u5173\u6ce8\u7c7b\u7684\u8fde\u63a5\u8bf7\u5728url\u524d\u52a0\u4e0a https://mallapi.lechun.cc/lechun-mall/customer/getAdSource?+" + adSourceVo.getAdUrl() + ",\u5982\u679c\u8d2d\u4e70\u7c7b\u7684\u6295\u653e \u8bf7\u5728\u6295\u653e\u8fde\u63a5\u5e26\u4e0a" + adSourceVo.getAdUrl());
                result.add(adSourceVo);
            }
        }
        return BaseJsonVo.success(result);
    }

    @Override
    public BaseJsonVo saveAdDayTime(Integer platformId, Integer day) {
        return BaseJsonVo.success((Object)(this.redisService.save("ADVERTISEMENT_ORDER_TIME:" + platformId, day) ? "\u4fdd\u5b58\u6210\u529f" : "\u4fdd\u5b58\u5931\u8d25"));
    }

    class AdSourceVo {
        private String type;
        private String name;
        private String description;
        private Integer sourceId;
        private String adUrl;
        private String remark = "";

        AdSourceVo() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(Integer sourceId) {
            this.sourceId = sourceId;
        }

        public String getAdUrl() {
            return this.adUrl;
        }

        public void setAdUrl(String adUrl) {
            this.adUrl = adUrl;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String toString() {
            return "AdSourceVo{type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", sourceId=" + this.sourceId + ", adUrl='" + this.adUrl + '\'' + ", remark='" + this.remark + '\'' + '}';
        }
    }
}

