/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallDeliverConfigDetailMapper;
import cc.lechun.mall.entity.deliver.MallDeliverConfigClassEntity;
import cc.lechun.mall.entity.deliver.MallDeliverConfigDetailEntity;
import cc.lechun.mall.entity.deliver.MallDeliverConfigDetailVo;
import cc.lechun.mall.entity.deliver.MallDeliverConfigTimesCityEntity;
import cc.lechun.mall.entity.deliver.MallDeliverConfigTimesEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigDetailInterface;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigTimesCityInterface;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigTimesInterface;
import cc.lechun.mall.service.deliver.MallDeliverConfigClassService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallDeliverConfigDetailService
extends BaseService
implements MallDeliverConfigDetailInterface {
    @Autowired
    private MallDeliverConfigDetailMapper deliverConfigDetailMapper;
    @Autowired
    private MallDeliverConfigClassService configClassService;
    @Autowired
    private MallDeliverConfigTimesCityInterface timesCityInterface;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private MallDeliverConfigTimesInterface configTimesInterface;

    @Override
    public List<MallDeliverConfigDetailEntity> getDeliverConfigDetails(String configClassId) {
        MallDeliverConfigDetailEntity configDetailEntity = new MallDeliverConfigDetailEntity();
        configDetailEntity.setDeliverConfigClassId(configClassId);
        return this.deliverConfigDetailMapper.getList(configDetailEntity);
    }

    @Override
    public int existsByClassId(String configClassId) {
        MallDeliverConfigDetailEntity configDetailEntity = new MallDeliverConfigDetailEntity();
        configDetailEntity.setDeliverConfigClassId(configClassId);
        return this.deliverConfigDetailMapper.existsByEntity(configDetailEntity);
    }

    public boolean save(MallDeliverConfigDetailEntity configDetailEntity) {
        if (this.deliverConfigDetailMapper.exists((Serializable)((Object)configDetailEntity.getDeliverConfigDetailId())) > 0) {
            return this.deliverConfigDetailMapper.updateByPrimaryKeySelective(configDetailEntity) > 0;
        }
        return this.deliverConfigDetailMapper.insertSelective(configDetailEntity) > 0;
    }

    @Override
    public List<MallDeliverConfigDetailVo> getDeliverConfig(String buyId) {
        List<MallDeliverConfigDetailEntity> configDetailEntities;
        ArrayList<MallDeliverConfigDetailVo> deliverConfigDetailVos = new ArrayList<MallDeliverConfigDetailVo>();
        MallDeliverConfigClassEntity configClassEntity = this.configClassService.getDeliverConfigClassByBuyId(buyId);
        if (configClassEntity != null && (configDetailEntities = this.getDeliverConfigDetails(configClassEntity.getDeliverConfigClassId())) != null && configDetailEntities.size() > 0) {
            for (MallDeliverConfigDetailEntity detailEntity : configDetailEntities) {
                List<MallDeliverConfigTimesCityEntity> entities = this.timesCityInterface.getList(detailEntity.getDeliverTimes());
                if (entities == null || entities.size() <= 0) continue;
                MallDeliverConfigDetailVo detailVo = new MallDeliverConfigDetailVo();
                detailVo.setBuyId(buyId);
                detailVo.setConfigClassId(configClassEntity.getDeliverConfigClassId());
                detailVo.setConfigDetailId(detailEntity.getDeliverConfigDetailId());
                detailVo.setConfigTimesId(detailEntity.getDeliverTimes());
                String cityIds = StringUtils.join((Object[])entities.stream().map(c -> c.getCityId()).toArray(), (String)",");
                String cityNames = this.customerAddressInterface.getCityNamesByIds(cityIds);
                detailVo.setCityNames(cityNames);
                detailVo.setCityIds(cityIds);
                detailVo.setDeliverDate(detailEntity.getDeliverDate());
                detailVo.setStatus(configClassEntity.getStatus());
                detailVo.setBuyType(configClassEntity.getBuyType());
                deliverConfigDetailVos.add(detailVo);
            }
        }
        return deliverConfigDetailVos;
    }

    @Override
    @Transactional
    public BaseJsonVo saveDeliverConfig(MallDeliverConfigDetailVo configDetailVo, String userId) {
        if (configDetailVo.getBuyId() == null || configDetailVo.getBuyId().isEmpty()) {
            return BaseJsonVo.error((String)"\u4fc3\u9500Id\u4e3a\u7a7a");
        }
        if (configDetailVo.getCityIds() == null || configDetailVo.getCityIds().isEmpty()) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u9009\u62e9\u57ce\u5e02");
        }
        if (configDetailVo.getDeliverDate() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u914d\u9001\u65e5\u671f");
        }
        MallDeliverConfigClassEntity configClassEntity = new MallDeliverConfigClassEntity();
        configClassEntity.setBuyId(configDetailVo.getBuyId());
        configClassEntity.setBuyType(configDetailVo.getBuyType());
        configClassEntity.setCreateTime(DateUtils.now());
        configClassEntity.setCreateUserId(userId);
        configClassEntity.setStatus(configDetailVo.getStatus());
        String configClassId = configDetailVo.getConfigClassId();
        if (configClassId == null || configClassId.isEmpty()) {
            configClassId = IDGenerate.getUniqueIdStr();
        }
        configClassEntity.setDeliverConfigClassId(configClassId);
        try {
            if (!this.configClassService.save(configClassEntity)) {
                throw new RuntimeException("\u4fdd\u5b58\u5206\u7c7b\u5931\u8d25");
            }
            Integer timesId = configDetailVo.getConfigTimesId();
            MallDeliverConfigTimesEntity configTimesEntity = new MallDeliverConfigTimesEntity();
            configTimesEntity.setDeliverConfigTimesName("sysAuto" + RandomUtils.generateStrId());
            configTimesEntity.setStatus(configDetailVo.getStatus());
            if (timesId != null) {
                configTimesEntity.setDeliverConfigTimesId(timesId);
            }
            if (!this.configTimesInterface.save(configTimesEntity)) {
                throw new RuntimeException("\u4fdd\u5b58Times\u5931\u8d25");
            }
            timesId = configTimesEntity.getDeliverConfigTimesId();
            String configDetailId = configDetailVo.getConfigDetailId();
            if (configDetailId == null || configDetailId.isEmpty()) {
                configDetailId = IDGenerate.getUniqueIdStr();
            }
            MallDeliverConfigDetailEntity configDetailEntity = new MallDeliverConfigDetailEntity();
            configDetailEntity.setDeliverConfigClassId(configClassId);
            configDetailEntity.setDeliverConfigDetailId(configDetailId);
            configDetailEntity.setDeliverDate(configDetailVo.getDeliverDate());
            configDetailEntity.setDeliverTimes(timesId);
            this.save(configDetailEntity);
            String[] citys = configDetailVo.getCityIds().split(",");
            this.timesCityInterface.delete(timesId);
            for (String city : citys) {
                MallDeliverConfigTimesCityEntity timesCityEntity = new MallDeliverConfigTimesCityEntity();
                timesCityEntity.setDeliverConfigTimesId(timesId);
                timesCityEntity.setCityId(Integer.valueOf(city));
                this.timesCityInterface.save(timesCityEntity);
            }
        }
        catch (RuntimeException e) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"");
    }
}

